/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.compiler;

import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Set;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.oxm.schema.model.All;
import org.eclipse.persistence.internal.oxm.schema.model.Any;
import org.eclipse.persistence.internal.oxm.schema.model.AnyAttribute;
import org.eclipse.persistence.internal.oxm.schema.model.Attribute;
import org.eclipse.persistence.internal.oxm.schema.model.Choice;
import org.eclipse.persistence.internal.oxm.schema.model.ComplexContent;
import org.eclipse.persistence.internal.oxm.schema.model.ComplexType;
import org.eclipse.persistence.internal.oxm.schema.model.Content;
import org.eclipse.persistence.internal.oxm.schema.model.Element;
import org.eclipse.persistence.internal.oxm.schema.model.Extension;
import org.eclipse.persistence.internal.oxm.schema.model.Import;
import org.eclipse.persistence.internal.oxm.schema.model.Include;
import org.eclipse.persistence.internal.oxm.schema.model.List;
import org.eclipse.persistence.internal.oxm.schema.model.Restriction;
import org.eclipse.persistence.internal.oxm.schema.model.Schema;
import org.eclipse.persistence.internal.oxm.schema.model.Sequence;
import org.eclipse.persistence.internal.oxm.schema.model.SimpleComponent;
import org.eclipse.persistence.internal.oxm.schema.model.SimpleContent;
import org.eclipse.persistence.internal.oxm.schema.model.SimpleType;
import org.eclipse.persistence.internal.oxm.schema.model.TypeDefParticle;
import org.eclipse.persistence.jaxb.compiler.AnyProperty;
import org.eclipse.persistence.jaxb.compiler.ChoiceProperty;
import org.eclipse.persistence.jaxb.compiler.ElementDeclaration;
import org.eclipse.persistence.jaxb.compiler.EnumTypeInfo;
import org.eclipse.persistence.jaxb.compiler.NamespaceInfo;
import org.eclipse.persistence.jaxb.compiler.Property;
import org.eclipse.persistence.jaxb.compiler.ReferenceProperty;
import org.eclipse.persistence.jaxb.compiler.SchemaTypeInfo;
import org.eclipse.persistence.jaxb.compiler.TypeInfo;
import org.eclipse.persistence.jaxb.javamodel.Helper;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaGenerator {
    private HashMap<String, Schema> schemaForNamespace;
    private Schema schema;
    private int schemaCount;
    private Helper helper;
    private HashMap<String, TypeInfo> typeInfo;
    private HashMap<String, NamespaceInfo> packageToNamespaceMappings;
    private HashMap<String, SchemaTypeInfo> schemaTypeInfo;
    private HashMap<String, QName> userDefinedSchemaTypes;

    public SchemaGenerator(Helper helper) {
        this.helper = helper;
    }

    public Schema generateSchema(ArrayList<JavaClass> arrayList, HashMap<String, TypeInfo> hashMap, HashMap<String, QName> hashMap2, HashMap<String, NamespaceInfo> hashMap3, HashMap<QName, ElementDeclaration> hashMap4) {
        this.typeInfo = hashMap;
        this.userDefinedSchemaTypes = hashMap2;
        this.packageToNamespaceMappings = hashMap3;
        this.schemaCount = 0;
        this.schemaTypeInfo = new HashMap(hashMap.size());
        for (JavaClass javaClass : arrayList) {
            this.addSchemaComponents(javaClass);
        }
        this.populateSchemaTypes();
        if (hashMap4 != null) {
            this.addGlobalElements(hashMap4);
        }
        return this.schema;
    }

    public void addSchemaComponents(JavaClass javaClass) {
        Object object;
        Object object2;
        Object object3;
        XmlRootElement xmlRootElement;
        String string = javaClass.getQualifiedName();
        Element element = null;
        TypeInfo typeInfo = this.typeInfo.get(string);
        SchemaTypeInfo schemaTypeInfo = new SchemaTypeInfo();
        schemaTypeInfo.setSchemaTypeName(new QName(typeInfo.getClassNamespace(), typeInfo.getSchemaTypeName()));
        this.schemaTypeInfo.put(javaClass.getQualifiedName(), schemaTypeInfo);
        NamespaceInfo namespaceInfo = this.packageToNamespaceMappings.get(javaClass.getPackage().getQualifiedName());
        Schema schema = this.getSchemaForNamespace(typeInfo.getClassNamespace());
        typeInfo.setSchema(schema);
        String string2 = typeInfo.getSchemaTypeName();
        String[] stringArray = typeInfo.getPropOrder();
        String string3 = "";
        Property property = null;
        if (this.helper.isAnnotationPresent(javaClass, XmlRootElement.class)) {
            int n;
            char c;
            xmlRootElement = (XmlRootElement)this.helper.getAnnotation(javaClass, XmlRootElement.class);
            element = new Element();
            object3 = xmlRootElement.name();
            if ((((String)object3).equals("##default") || ((String)object3).equals("")) && ((String)(object3 = string.indexOf("$") != -1 ? Introspector.decapitalize(string.substring(string.lastIndexOf(36) + 1)) : Introspector.decapitalize(string.substring(string.lastIndexOf(46) + 1)))).length() >= 3 && Character.isDigit(c = ((String)object3).charAt((n = ((String)object3).length() - 1) - 1))) {
                char c2 = Character.toUpperCase(((String)object3).charAt(n));
                object3 = ((String)object3).substring(0, n) + c2;
            }
            element.setName((String)object3);
            object2 = xmlRootElement.namespace();
            if (((String)object2).equals("##default")) {
                this.getSchemaForNamespace(namespaceInfo.getNamespace()).addTopLevelElement(element);
                schemaTypeInfo.getGlobalElementDeclarations().add(new QName(namespaceInfo.getNamespace(), (String)object2));
                object2 = namespaceInfo.getNamespace();
            } else {
                this.getSchemaForNamespace((String)object2).addTopLevelElement(element);
                schemaTypeInfo.getGlobalElementDeclarations().add(new QName((String)object2, (String)object3));
            }
            object = this.getSchemaForNamespace((String)object2);
            if (schema != object) {
                Import import_ = new Import();
                import_.setNamespace(schema.getTargetNamespace());
                import_.setSchemaLocation(schema.getName());
                ((Schema)object).getImports().add(import_);
            }
            if (!typeInfo.getClassNamespace().equals("")) {
                string3 = this.getPrefixForNamespace(typeInfo.getClassNamespace(), ((Schema)object).getNamespaceResolver());
                if (string3 == null) {
                    string3 = ((Schema)object).getNamespaceResolver().generatePrefix();
                    ((Schema)object).getNamespaceResolver().put(string3, typeInfo.getClassNamespace());
                }
                string3 = string3 + ":";
            }
        }
        xmlRootElement = typeInfo.getPropertyNames();
        if (typeInfo.isEnumerationType() || xmlRootElement.size() == 1 && this.helper.isAnnotationPresent(typeInfo.getProperties().get(xmlRootElement.get(0)).getElement(), XmlValue.class)) {
            object3 = new SimpleType();
            if (string2.equals("")) {
                if (element != null) {
                    element.setSimpleType((SimpleType)object3);
                }
            } else {
                ((SimpleType)object3).setName(string2);
                schema.addTopLevelSimpleTypes((SimpleType)object3);
                if (element != null) {
                    element.setType(string3 + ((SimpleType)object3).getName());
                }
            }
            object2 = null;
            object = new Restriction();
            if (typeInfo.isEnumerationType()) {
                object2 = ((EnumTypeInfo)typeInfo).getRestrictionBase();
                ((Restriction)object).setEnumerationFacets(this.getEnumerationFacetsFor((EnumTypeInfo)typeInfo));
                ((Restriction)object).setBaseType("xsd:" + ((QName)object2).getLocalPart());
                ((SimpleType)object3).setRestriction((Restriction)object);
            } else {
                property = typeInfo.getProperties().get(xmlRootElement.get(0));
                QName qName = this.getSchemaTypeFor(property.getType());
                if (this.helper.isAnnotationPresent(property.getElement(), XmlList.class)) {
                    List list = new List();
                    list.setItemType("xsd:" + qName.getLocalPart());
                    ((SimpleType)object3).setList(list);
                } else {
                    if (this.helper.isAnnotationPresent(property.getElement(), XmlSchemaType.class)) {
                        XmlSchemaType xmlSchemaType = (XmlSchemaType)this.helper.getAnnotation(property.getElement(), XmlSchemaType.class);
                        qName = new QName(xmlSchemaType.namespace(), xmlSchemaType.name());
                    }
                    ((Restriction)object).setBaseType("xsd:" + qName.getLocalPart());
                    ((SimpleType)object3).setRestriction((Restriction)object);
                }
            }
            typeInfo.setSimpleType((SimpleType)object3);
        } else {
            property = this.getXmlValueFieldForSimpleContent(typeInfo.getPropertyList());
            if (property != null) {
                object3 = new ComplexType();
                object2 = new SimpleContent();
                if (string2.equals("")) {
                    if (element != null) {
                        element.setComplexType((ComplexType)object3);
                    }
                    typeInfo.setComplexType((ComplexType)object3);
                } else {
                    ((ComplexType)object3).setName(string2);
                    schema.addTopLevelComplexTypes((ComplexType)object3);
                    if (element != null) {
                        element.setType(string3 + ((ComplexType)object3).getName());
                    }
                }
                object = this.getSchemaTypeFor(property.getType());
                if (this.helper.isAnnotationPresent(property.getElement(), XmlSchemaType.class)) {
                    XmlSchemaType xmlSchemaType = (XmlSchemaType)this.helper.getAnnotation(property.getElement(), XmlSchemaType.class);
                    object = new QName(xmlSchemaType.namespace(), xmlSchemaType.name());
                }
                Extension extension = new Extension();
                extension.setBaseType("xsd:" + ((QName)object).getLocalPart());
                ((Content)object2).setExtension(extension);
                ((ComplexType)object3).setSimpleContent((SimpleContent)object2);
                typeInfo.setComplexType((ComplexType)object3);
            } else {
                Object object4;
                object3 = new ComplexType();
                object2 = javaClass.getSuperclass();
                object = this.typeInfo.get(object2.getQualifiedName());
                Extension extension = null;
                if (object != null) {
                    extension = new Extension();
                    object4 = this.getPrefixForNamespace(((TypeInfo)object).getClassNamespace(), namespaceInfo.getNamespaceResolver());
                    if (object4 != null) {
                        extension.setBaseType((String)object4 + ":" + ((TypeInfo)object).getSchemaTypeName());
                    } else {
                        extension.setBaseType(((TypeInfo)object).getSchemaTypeName());
                    }
                    ComplexContent complexContent = new ComplexContent();
                    complexContent.setExtension(extension);
                    ((ComplexType)object3).setComplexContent(complexContent);
                }
                object4 = null;
                if (stringArray.length == 0) {
                    if (typeInfo.hasElementRefs()) {
                        object4 = new Sequence();
                        if (extension != null) {
                            extension.setSequence((Sequence)object4);
                        } else {
                            ((ComplexType)object3).setSequence((Sequence)object4);
                        }
                    } else if (extension != null) {
                        object4 = new All();
                        extension.setAll((All)object4);
                    } else {
                        object4 = new All();
                        ((ComplexType)object3).setAll((All)object4);
                    }
                } else {
                    object4 = new Sequence();
                    if (extension != null) {
                        extension.setSequence((Sequence)object4);
                    } else {
                        ((ComplexType)object3).setSequence((Sequence)object4);
                    }
                }
                if (string2.equals("")) {
                    if (element != null) {
                        element.setComplexType((ComplexType)object3);
                    }
                    typeInfo.setComplexType((ComplexType)object3);
                    typeInfo.setCompositor((TypeDefParticle)object4);
                } else {
                    ((ComplexType)object3).setName(string2);
                    if (element != null) {
                        element.setType(string3 + ((ComplexType)object3).getName());
                    }
                    schema.addTopLevelComplexTypes((ComplexType)object3);
                    typeInfo.setComplexType((ComplexType)object3);
                    typeInfo.setCompositor((TypeDefParticle)object4);
                }
                typeInfo.setPropOrder(stringArray);
            }
        }
    }

    public void addToSchemaType(ArrayList<Property> arrayList, TypeDefParticle typeDefParticle, ComplexType complexType, Schema schema) {
        for (Property property : arrayList) {
            JavaClass javaClass;
            Object object;
            Object object2;
            Object object3;
            Object object5;
            Object object6;
            java.util.List<ElementDeclaration> list;
            Object object7;
            if (property == null) continue;
            Object object8 = typeDefParticle;
            boolean bl = object8 instanceof Choice;
            Object object9 = complexType;
            if (this.helper.isAnnotationPresent(property.getElement(), XmlTransient.class)) continue;
            if (!bl && this.helper.isAnnotationPresent(property.getElement(), XmlElementWrapper.class)) {
                object7 = (XmlElementWrapper)this.helper.getAnnotation(property.getElement(), XmlElementWrapper.class);
                list = new Element();
                ((SimpleComponent)((Object)list)).setName(object7.name());
                ((Element)((Object)list)).setMinOccurs("0");
                typeDefParticle.addElement((Element)((Object)list));
                object6 = new ComplexType();
                object5 = new Sequence();
                ((ComplexType)object6).setSequence((Sequence)object5);
                ((Element)((Object)list)).setComplexType((ComplexType)object6);
                object9 = object6;
                object8 = object5;
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlAttribute.class)) {
                Object object4;
                object7 = new Attribute();
                list = property.getSchemaName();
                ((SimpleComponent)object7).setName(((QName)((Object)list)).getLocalPart());
                if (property.isRequired()) {
                    ((Attribute)object7).setUse("required");
                }
                object6 = property.getType();
                if (property.getGenericType() != null) {
                    object6 = property.getGenericType();
                }
                object5 = null;
                TypeInfo typeInfo = this.typeInfo.get(property.getType().getQualifiedName());
                if (typeInfo != null) {
                    if (!typeInfo.isComplexType()) {
                        object5 = typeInfo.getSimpleType().getName();
                    }
                } else if (this.helper.isAnnotationPresent(property.getElement(), XmlID.class)) {
                    object5 = "xsd:ID";
                } else if (this.helper.isAnnotationPresent(property.getElement(), XmlIDREF.class)) {
                    object5 = "xsd:IDREF";
                } else {
                    object3 = property.getSchemaType();
                    if (object3 == null) {
                        object3 = this.getSchemaTypeFor((JavaClass)object6);
                    }
                    object5 = object3 != null ? "xsd:" + ((QName)object3).getLocalPart() : "xsd:anySimpleType";
                }
                if (this.isCollectionType(property)) {
                    object3 = new SimpleType();
                    object4 = new List();
                    ((List)object4).setItemType((String)object5);
                    ((SimpleType)object3).setList((List)object4);
                    ((SimpleComponent)object7).setSimpleType((SimpleType)object3);
                } else {
                    if (object5 != null && !((String)object5).contains(":") && typeInfo.getSchema() == schema && (object3 = this.getPrefixForNamespace(schema.getTargetNamespace(), schema.getNamespaceResolver())) != null) {
                        object5 = (String)object3 + ":" + (String)object5;
                    }
                    ((SimpleComponent)object7).setType((String)object5);
                }
                if (!((QName)((Object)list)).getNamespaceURI().equals("")) {
                    object3 = this.getSchemaForNamespace(((QName)((Object)list)).getNamespaceURI());
                    if (((Schema)object3).getTopLevelAttributes().get(((SimpleComponent)object7).getName()) == null) {
                        ((Schema)object3).getTopLevelAttributes().put(((SimpleComponent)object7).getName(), object7);
                    }
                    if (!this.importExists(schema, ((Schema)object3).getName())) {
                        object4 = new Import();
                        ((Import)object4).setNamespace(((Schema)object3).getTargetNamespace());
                        ((Include)object4).setSchemaLocation(((Schema)object3).getName());
                        schema.getImports().add(object4);
                        schema.getNamespaceResolver().put(schema.getNamespaceResolver().generatePrefix(), ((Schema)object3).getTargetNamespace());
                    }
                    object4 = new Attribute();
                    object2 = this.getPrefixForNamespace(((Schema)object3).getTargetNamespace(), schema.getNamespaceResolver());
                    if (object2 == null) {
                        ((Attribute)object4).setRef(((SimpleComponent)object7).getName());
                    } else {
                        ((Attribute)object4).setRef((String)object2 + ":" + ((SimpleComponent)object7).getName());
                    }
                    if (((ComplexType)object9).getSimpleContent() != null) {
                        ((ComplexType)object9).getSimpleContent().getExtension().getOrderedAttributes().add(object4);
                        continue;
                    }
                    ((ComplexType)object9).getOrderedAttributes().add(object4);
                    continue;
                }
                if (((ComplexType)object9).getSimpleContent() != null) {
                    ((ComplexType)object9).getSimpleContent().getExtension().getOrderedAttributes().add(object7);
                    continue;
                }
                if (((ComplexType)object9).getComplexContent() != null) {
                    ((ComplexType)object9).getComplexContent().getExtension().getOrderedAttributes().add(object7);
                    continue;
                }
                ((ComplexType)object9).getOrderedAttributes().add(object7);
                continue;
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlAnyAttribute.class)) {
                object7 = new AnyAttribute();
                ((AnyAttribute)object7).setProcessContents("lax");
                if (complexType.getSimpleContent() != null) {
                    list = complexType.getSimpleContent();
                    ((Content)((Object)list)).getRestriction().setAnyAttribute((AnyAttribute)object7);
                    continue;
                }
                complexType.setAnyAttribute((AnyAttribute)object7);
                continue;
            }
            if (property.isChoice()) {
                object7 = new Choice();
                list = (ArrayList)((ChoiceProperty)property).getChoiceProperties();
                this.addToSchemaType((ArrayList<Property>)list, (TypeDefParticle)object7, (ComplexType)object9, schema);
                if (object8 instanceof Sequence) {
                    ((Sequence)object8).addChoice((Choice)object7);
                    continue;
                }
                if (!(object8 instanceof Choice)) continue;
                ((Choice)object8).addChoice((Choice)object7);
                continue;
            }
            if (property.isAny()) {
                object7 = new Any();
                list = (AnyProperty)property;
                if (((AnyProperty)((Object)list)).isLax()) {
                    ((AnyAttribute)object7).setProcessContents("lax");
                }
                if (object8 instanceof Sequence) {
                    ((Sequence)object8).addAny((Any)object7);
                    continue;
                }
                if (!(object8 instanceof Choice)) continue;
                ((Choice)object8).addAny((Any)object7);
                continue;
            }
            if (property.isReference()) {
                object7 = (ReferenceProperty)property;
                list = ((ReferenceProperty)object7).getReferencedElements();
                if (list.size() == 1) {
                    String string;
                    object6 = new Element();
                    object5 = list.get(0);
                    String string2 = ((ElementDeclaration)object5).getElementName().getLocalPart();
                    object3 = this.getSchemaForNamespace(((ElementDeclaration)object5).getElementName().getNamespaceURI());
                    if (object3 != schema && !this.importExists(schema, ((Schema)object3).getName())) {
                        Import import_ = new Import();
                        import_.setSchemaLocation(((Schema)object3).getName());
                        import_.setNamespace(((Schema)object3).getTargetNamespace());
                        schema.getImports().add(import_);
                        if (import_.getNamespace() != null) {
                            schema.getNamespaceResolver().put(schema.getNamespaceResolver().generatePrefix(), import_.getNamespace());
                        }
                    }
                    if ((string = this.getPrefixForNamespace(((ElementDeclaration)object5).getElementName().getNamespaceURI(), schema.getNamespaceResolver())) == null || string.equals("")) {
                        ((Element)object6).setRef(string2);
                    } else {
                        ((Element)object6).setRef(string + ":" + string2);
                    }
                    if (this.isCollectionType(property)) {
                        ((Element)object6).setMaxOccurs("unbounded");
                    }
                    ((TypeDefParticle)object8).addElement((Element)object6);
                    continue;
                }
                object6 = new Choice();
                if (this.isCollectionType(property)) {
                    ((TypeDefParticle)object6).setMaxOccurs("unbounded");
                }
                for (ElementDeclaration elementDeclaration : list) {
                    object3 = new Element();
                    String string = elementDeclaration.getElementName().getLocalPart();
                    object2 = this.getSchemaForNamespace(elementDeclaration.getElementName().getNamespaceURI());
                    if (object2 != schema && !this.importExists(schema, ((Schema)object2).getName())) {
                        object = new Import();
                        ((Include)object).setSchemaLocation(((Schema)object2).getName());
                        ((Import)object).setNamespace(((Schema)object2).getTargetNamespace());
                        schema.getImports().add(object);
                        if (((Import)object).getNamespace() != null) {
                            schema.getNamespaceResolver().put(schema.getNamespaceResolver().generatePrefix(), ((Import)object).getNamespace());
                        }
                    }
                    if ((object = this.getPrefixForNamespace(elementDeclaration.getElementName().getNamespaceURI(), schema.getNamespaceResolver())) == null || ((String)object).equals("")) {
                        ((Element)object3).setRef(string);
                    } else {
                        ((Element)object3).setRef((String)object + ":" + string);
                    }
                    ((Choice)object6).addElement((Element)object3);
                }
                if (object8 instanceof Sequence) {
                    ((Sequence)object8).addChoice((Choice)object6);
                    continue;
                }
                if (!(object8 instanceof Choice)) continue;
                ((Choice)object8).addChoice((Choice)object6);
                continue;
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlValue.class)) continue;
            object7 = new Element();
            ((Element)object7).setMinOccurs(property.isRequired() ? "1" : "0");
            list = property.getSchemaName();
            object6 = property.getType();
            boolean bl2 = this.isCollectionType(property);
            if (bl2 && (javaClass = property.getGenericType()) != null && object6.hasActualTypeArguments()) {
                object3 = object6.getActualTypeArguments().toArray();
                object6 = (JavaClass)object3[0];
            }
            ((SimpleComponent)object7).setName(((QName)((Object)list)).getLocalPart());
            TypeInfo typeInfo = this.typeInfo.get(object6.getQualifiedName());
            object3 = null;
            boolean bl3 = false;
            if (typeInfo != null) {
                if (this.helper.isAnnotationPresent(property.getElement(), XmlID.class)) {
                    object3 = "xsd:ID";
                } else if (this.helper.isAnnotationPresent(property.getElement(), XmlIDREF.class)) {
                    object3 = "xsd:IDREF";
                } else {
                    bl3 = typeInfo.isComplexType();
                    object3 = typeInfo.isComplexType() ? typeInfo.getComplexType().getName() : typeInfo.getSimpleType().getName();
                }
                if (object3 == null && !typeInfo.hasRootElement()) {
                    if (typeInfo.isComplexType()) {
                        ((Element)object7).setComplexType(typeInfo.getComplexType());
                    } else {
                        ((SimpleComponent)object7).setSimpleType(typeInfo.getSimpleType());
                    }
                }
                if (typeInfo.getSchema() != schema && !this.importExists(schema, typeInfo.getSchema().getName())) {
                    object2 = new Import();
                    ((Include)object2).setSchemaLocation(typeInfo.getSchema().getName());
                    ((Import)object2).setNamespace(typeInfo.getSchema().getTargetNamespace());
                    schema.getImports().add(object2);
                    if (((Import)object2).getNamespace() != null) {
                        schema.getNamespaceResolver().put(schema.getNamespaceResolver().generatePrefix(), ((Import)object2).getNamespace());
                    }
                    if ((object = this.getPrefixForNamespace(typeInfo.getSchema().getTargetNamespace(), schema.getNamespaceResolver())) != null && !((String)object3).equals("")) {
                        object3 = (String)object + ":" + (String)object3;
                    }
                }
            } else {
                object2 = property.getSchemaType();
                if (object2 == null) {
                    object2 = this.getSchemaTypeFor((JavaClass)object6);
                }
                if (object2 != null) {
                    object3 = "xsd:" + ((QName)object2).getLocalPart();
                }
            }
            if (object3 != null && !((String)object3).contains(":") && typeInfo.getSchema() == schema && (object2 = this.getPrefixForNamespace(schema.getTargetNamespace(), schema.getNamespaceResolver())) != null) {
                object3 = (String)object2 + ":" + (String)object3;
            }
            if (bl2) {
                if (this.helper.isAnnotationPresent(property.getElement(), XmlList.class)) {
                    if (bl3) {
                        // empty if block
                    }
                    object2 = new SimpleType();
                    object = new List();
                    ((List)object).setItemType((String)object3);
                    ((SimpleType)object2).setList((List)object);
                    ((SimpleComponent)object7).setSimpleType((SimpleType)object2);
                } else {
                    ((Element)object7).setMaxOccurs("unbounded");
                    ((SimpleComponent)object7).setType((String)object3);
                }
            } else {
                ((SimpleComponent)object7).setType((String)object3);
            }
            if (!((QName)((Object)list)).getNamespaceURI().equals("")) {
                Object object10;
                object2 = new Element();
                ((Element)object2).setMinOccurs(((Element)object7).getMinOccurs());
                ((Element)object2).setMaxOccurs(((Element)object7).getMaxOccurs());
                object = this.getSchemaForNamespace(((QName)((Object)list)).getNamespaceURI());
                if (((Schema)object).getTopLevelElements().get(((SimpleComponent)object7).getName()) == null) {
                    ((Element)object7).setMinOccurs(null);
                    ((Element)object7).setMaxOccurs(null);
                    ((Schema)object).getTopLevelElements().put(((SimpleComponent)object7).getName(), object7);
                }
                if (object != schema && !this.importExists(schema, ((Schema)object).getName())) {
                    object10 = new Import();
                    ((Import)object10).setNamespace(((Schema)object).getTargetNamespace());
                    ((Include)object10).setSchemaLocation(((Schema)object).getName());
                    schema.getImports().add(object10);
                    schema.getNamespaceResolver().put(schema.getNamespaceResolver().generatePrefix(), ((Schema)object).getTargetNamespace());
                }
                if ((object10 = this.getPrefixForNamespace(((Schema)object).getTargetNamespace(), schema.getNamespaceResolver())) == null) {
                    ((Element)object2).setRef(((SimpleComponent)object7).getName());
                } else {
                    ((Element)object2).setRef((String)object10 + ":" + ((SimpleComponent)object7).getName());
                }
                ((TypeDefParticle)object8).addElement((Element)object2);
                continue;
            }
            ((TypeDefParticle)object8).addElement((Element)object7);
        }
    }

    public QName getSchemaTypeFor(JavaClass javaClass) {
        QName qName = this.userDefinedSchemaTypes.get(javaClass.getQualifiedName());
        if (qName == null) {
            qName = (QName)this.helper.getXMLToJavaTypeMap().get(javaClass.getRawName());
        }
        if (qName == null) {
            return XMLConstants.ANY_SIMPLE_TYPE_QNAME;
        }
        return qName;
    }

    public void populateSchemaTypes() {
        for (String string : this.typeInfo.keySet()) {
            TypeInfo typeInfo = this.typeInfo.get(string);
            if (!typeInfo.isComplexType()) continue;
            ComplexType complexType = typeInfo.getComplexType();
            TypeDefParticle typeDefParticle = typeInfo.getCompositor();
            String[] stringArray = typeInfo.getPropOrder();
            if (stringArray.length == 0 || stringArray[0].equals("")) {
                stringArray = typeInfo.getPropertyNames().toArray(new String[typeInfo.getPropertyNames().size()]);
            }
            ArrayList<Property> arrayList = new ArrayList<Property>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                Property property = typeInfo.getProperties().get(stringArray[i]);
                arrayList.add(property);
            }
            this.addToSchemaType(arrayList, typeDefParticle, complexType, typeInfo.getSchema());
        }
    }

    public String getSchemaTypeNameForClassName(String string) {
        String string2 = Introspector.decapitalize(string.substring(string.lastIndexOf(46) + 1));
        return string2;
    }

    public ArrayList<String> getEnumerationFacetsFor(EnumTypeInfo enumTypeInfo) {
        return (ArrayList)enumTypeInfo.getFieldValues();
    }

    public Property getXmlValueFieldForSimpleContent(ArrayList<Property> arrayList) {
        boolean bl = false;
        boolean bl2 = false;
        Property property = null;
        for (Property property2 : arrayList) {
            if (this.helper.isAnnotationPresent(property2.getElement(), XmlValue.class)) {
                bl = true;
                property = property2;
                continue;
            }
            if (this.helper.isAnnotationPresent(property2.getElement(), XmlAttribute.class) || this.helper.isAnnotationPresent(property2.getElement(), XmlTransient.class) || this.helper.isAnnotationPresent(property2.getElement(), XmlAnyAttribute.class)) continue;
            bl2 = true;
        }
        if (bl && !bl2) {
            return property;
        }
        return null;
    }

    public boolean isCollectionType(Property property) {
        JavaClass javaClass = property.getType();
        return this.helper.getJavaClass(Collection.class).isAssignableFrom(javaClass) || this.helper.getJavaClass(java.util.List.class).isAssignableFrom(javaClass) || this.helper.getJavaClass(Set.class).isAssignableFrom(javaClass);
    }

    private Schema getSchemaForNamespace(String string) {
        Schema schema;
        if (this.schemaForNamespace == null) {
            this.schemaForNamespace = new HashMap();
        }
        if ((schema = this.schemaForNamespace.get(string)) == null) {
            NamespaceInfo namespaceInfo = this.getNamespaceInfoForNamespace(string);
            schema = new Schema();
            schema.setName("schema" + this.schemaCount + ".xsd");
            ++this.schemaCount;
            if (!string.equals("")) {
                schema.setTargetNamespace(string);
                String string2 = null;
                if (namespaceInfo != null) {
                    string2 = namespaceInfo.getNamespaceResolver().resolveNamespaceURI(string);
                }
                if (string2 == null) {
                    string2 = schema.getNamespaceResolver().generatePrefix();
                }
                schema.getNamespaceResolver().put(string2, string);
            }
            if (namespaceInfo != null) {
                schema.setAttributeFormDefault(namespaceInfo.isAttributeFormQualified());
                schema.setElementFormDefault(namespaceInfo.isElementFormQualified());
            }
            this.schemaForNamespace.put(string, schema);
        }
        return schema;
    }

    public Collection<Schema> getAllSchemas() {
        if (this.schemaForNamespace == null) {
            this.schemaForNamespace = new HashMap();
        }
        return this.schemaForNamespace.values();
    }

    public NamespaceInfo getNamespaceInfoForNamespace(String string) {
        Collection<NamespaceInfo> collection = this.packageToNamespaceMappings.values();
        for (NamespaceInfo namespaceInfo : collection) {
            if (!namespaceInfo.getNamespace().equals(string)) continue;
            return namespaceInfo;
        }
        return null;
    }

    public String getPrefixForNamespace(String string, NamespaceResolver namespaceResolver) {
        Enumeration enumeration = namespaceResolver.getPrefixes();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = namespaceResolver.resolveNamespacePrefix(string2);
            if (!string3.equals(string)) continue;
            return string2;
        }
        return null;
    }

    public void addGlobalElements(HashMap<QName, ElementDeclaration> hashMap) {
        for (QName qName : hashMap.keySet()) {
            Object object;
            String string;
            Object object2;
            String string2 = qName.getNamespaceURI();
            Schema schema = this.getSchemaForNamespace(string2);
            if (schema.getTopLevelElements().get(qName.getLocalPart()) != null) continue;
            Element element = new Element();
            element.setName(qName.getLocalPart());
            ElementDeclaration elementDeclaration = hashMap.get(qName);
            JavaClass javaClass = this.helper.getJavaClass(elementDeclaration.getJavaTypeName());
            QName qName2 = (QName)this.helper.getXMLToJavaTypeMap().get(javaClass.getRawName());
            if (qName2 != null) {
                element.setType("xsd:" + qName2.getLocalPart());
            } else {
                object2 = this.typeInfo.get(javaClass.getQualifiedName());
                if (object2 != null) {
                    string = null;
                    string = ((TypeInfo)object2).isComplexType() ? ((TypeInfo)object2).getComplexType().getName() : ((TypeInfo)object2).getSimpleType().getName();
                    if (((TypeInfo)object2).getClassNamespace().equals(string2)) {
                        element.setType(string);
                    } else {
                        Object object3;
                        object = this.getSchemaForNamespace(((TypeInfo)object2).getClassNamespace());
                        String string3 = ((Schema)object).getTargetNamespace();
                        if (string3 == null) {
                            string3 = "";
                        }
                        if (!this.importExists(schema, ((Schema)object).getName())) {
                            object3 = new Import();
                            ((Import)object3).setNamespace(((Schema)object).getTargetNamespace());
                            ((Include)object3).setSchemaLocation(((Schema)object).getName());
                            schema.getImports().add(object3);
                            if (!string3.equals("")) {
                                schema.getNamespaceResolver().put(schema.getNamespaceResolver().generatePrefix(), string3);
                            }
                        }
                        if ((object3 = schema.getNamespaceResolver().resolveNamespaceURI(((Schema)object).getTargetNamespace())) != null) {
                            element.setType((String)object3 + ":" + string);
                        } else {
                            element.setType(string);
                        }
                    }
                }
            }
            if (elementDeclaration.getSubstitutionHead() != null) {
                object2 = elementDeclaration.getSubstitutionHead().getLocalPart();
                string = elementDeclaration.getSubstitutionHead().getNamespaceURI();
                object = this.getPrefixForNamespace(string, schema.getNamespaceResolver());
                if (object == null || ((String)object).equals("")) {
                    element.setSubstitutionGroup((String)object2);
                } else {
                    element.setSubstitutionGroup((String)object + ":" + (String)object2);
                }
            }
            schema.addTopLevelElement(element);
            object2 = this.schemaTypeInfo.get(javaClass.getQualifiedName());
            if (object2 == null) {
                object2 = new SchemaTypeInfo();
                ((SchemaTypeInfo)object2).setSchemaTypeName(qName2);
                this.schemaTypeInfo.put(javaClass.getQualifiedName(), (SchemaTypeInfo)object2);
            }
            ((SchemaTypeInfo)object2).getGlobalElementDeclarations().add(qName);
        }
    }

    public HashMap<String, SchemaTypeInfo> getSchemaTypeInfo() {
        return this.schemaTypeInfo;
    }

    private boolean importExists(Schema schema, String string) {
        java.util.List list = schema.getImports();
        for (int i = 0; i < list.size(); ++i) {
            Import import_ = (Import)list.get(i);
            if (import_.getSchemaLocation() == null || !import_.getSchemaLocation().equals(string)) continue;
            return true;
        }
        return false;
    }
}

