/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.compiler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.xml.bind.annotation.XmlAccessOrder;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.oxm.schema.model.ComplexType;
import org.eclipse.persistence.internal.oxm.schema.model.Schema;
import org.eclipse.persistence.internal.oxm.schema.model.SimpleType;
import org.eclipse.persistence.internal.oxm.schema.model.TypeDefParticle;
import org.eclipse.persistence.jaxb.compiler.Property;
import org.eclipse.persistence.jaxb.javamodel.Helper;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.schema.XMLSchemaClassPathReference;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeInfo {
    private static final String ATT = "@";
    private static final String TXT = "/text()";
    private XMLDescriptor descriptor;
    private ComplexType complexType;
    private boolean hasRootElement;
    private boolean hasElementRefs;
    private Schema schema;
    private SimpleType simpleType;
    private ArrayList<String> propOrder;
    private String classNamespace;
    private String schemaTypeName;
    private TypeDefParticle compositor;
    private XmlAccessType accessType;
    private ArrayList<String> propertyNames = new ArrayList();
    private ArrayList<Property> propertyList;
    private HashMap<String, Property> properties = new HashMap();
    private Property idProperty;
    private HashMap<String, JavaClass> adaptersByClass;
    private Helper helper;

    public TypeInfo(Helper helper) {
        this.propertyList = new ArrayList();
        this.adaptersByClass = new HashMap();
        this.helper = helper;
    }

    public XMLDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(XMLDescriptor xMLDescriptor) {
        Object object;
        if (this.isIDSet()) {
            object = this.helper.isAnnotationPresent(this.getIDProperty().getElement(), XmlAttribute.class) ? ATT + this.getIDProperty().getSchemaName() : this.getIDProperty().getSchemaName() + TXT;
            xMLDescriptor.addPrimaryKeyFieldName((String)object);
        }
        this.descriptor = xMLDescriptor;
        object = new XMLSchemaClassPathReference();
        ((XMLSchemaReference)object).setSchemaContext("/" + this.schemaTypeName);
        ((XMLSchemaReference)object).setSchemaContextAsQName(new QName(this.classNamespace, this.schemaTypeName));
        if (this.isEnumerationType() || this.propertyNames.size() == 1 && this.helper.isAnnotationPresent(this.getProperties().get(this.propertyNames.get(0)).getElement(), XmlValue.class)) {
            ((XMLSchemaReference)object).setType(2);
        }
        this.descriptor.setSchemaReference((XMLSchemaReference)object);
    }

    public ComplexType getComplexType() {
        return this.complexType;
    }

    public void setComplexType(ComplexType complexType) {
        this.complexType = complexType;
    }

    public SimpleType getSimpleType() {
        return this.simpleType;
    }

    public void setSimpleType(SimpleType simpleType) {
        this.simpleType = simpleType;
    }

    public String[] getPropOrder() {
        if (this.propOrder == null) {
            return new String[0];
        }
        return this.propOrder.toArray(new String[this.propOrder.size()]);
    }

    public void setPropOrder(String[] stringArray) {
        if (stringArray.length == 0) {
            this.propOrder = null;
        } else {
            this.propOrder = new ArrayList(stringArray.length);
            for (String string : stringArray) {
                this.propOrder.add(string);
            }
        }
    }

    public String getClassNamespace() {
        return this.classNamespace;
    }

    public void setClassNamespace(String string) {
        this.classNamespace = string;
    }

    public boolean isComplexType() {
        return this.complexType != null;
    }

    public TypeDefParticle getCompositor() {
        return this.compositor;
    }

    public void setCompositor(TypeDefParticle typeDefParticle) {
        this.compositor = typeDefParticle;
    }

    public XmlAccessType getAccessType() {
        return this.accessType;
    }

    public void setAccessType(XmlAccessType xmlAccessType) {
        this.accessType = xmlAccessType;
    }

    public ArrayList<String> getPropertyNames() {
        return this.propertyNames;
    }

    public Property getIDProperty() {
        return this.idProperty;
    }

    public HashMap<String, Property> getProperties() {
        return this.properties;
    }

    public void addProperty(String string, Property property) {
        this.properties.put(string, property);
        this.propertyNames.add(string);
        this.propertyList.add(property);
        if (this.propOrder != null && property.isAttribute() && !this.propOrder.contains(property.getPropertyName())) {
            this.propOrder.add(property.getPropertyName());
        }
    }

    public void setIDProperty(Property property) {
        this.idProperty = property;
    }

    public void setProperties(ArrayList<Property> arrayList) {
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                Property property = arrayList.get(i);
                this.addProperty(property.getPropertyName(), property);
            }
        }
    }

    public void orderProperties(XmlAccessOrder xmlAccessOrder) {
        if (xmlAccessOrder == XmlAccessOrder.ALPHABETICAL && this.propertyNames != null) {
            Collections.sort(this.propertyNames);
        }
    }

    public boolean isEnumerationType() {
        return false;
    }

    public boolean isIDSet() {
        return this.idProperty != null;
    }

    public ArrayList<Property> getPropertyList() {
        return this.propertyList;
    }

    public String getSchemaTypeName() {
        return this.schemaTypeName;
    }

    public void setSchemaTypeName(String string) {
        this.schemaTypeName = string;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public JavaClass getAdapterClass(JavaClass javaClass) {
        return this.getAdaptersByClass().get(javaClass.getQualifiedName());
    }

    public JavaClass getAdapterClass(String string) {
        return this.getAdaptersByClass().get(string);
    }

    public HashMap<String, JavaClass> getAdaptersByClass() {
        return this.adaptersByClass;
    }

    public void addAdapterClass(JavaClass javaClass, JavaClass javaClass2) {
        this.adaptersByClass.put(javaClass2.getQualifiedName(), javaClass);
    }

    public void addAdapterClass(JavaClass javaClass, String string) {
        this.adaptersByClass.put(string, javaClass);
    }

    public boolean hasRootElement() {
        return this.hasRootElement;
    }

    public void setHasRootElement(boolean bl) {
        this.hasRootElement = bl;
    }

    public boolean hasElementRefs() {
        return this.hasElementRefs;
    }

    public void setHasElementRefs(boolean bl) {
        this.hasElementRefs = bl;
    }
}

