/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings.xdb;

import java.io.StringReader;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.platform.database.XMLTypePlaceholder;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.platform.xml.XMLComparer;
import org.eclipse.persistence.platform.xml.XMLParser;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.eclipse.persistence.platform.xml.XMLTransformer;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DirectToXMLTypeMapping
extends DirectToFieldMapping {
    protected boolean shouldReadWholeDocument = false;
    private XMLTransformer xmlTransformer = XMLPlatformFactory.getInstance().getXMLPlatform().newXMLTransformer();
    private XMLComparer xmlComparer;
    private XMLParser xmlParser;

    public void initialize(AbstractSession abstractSession) throws DescriptorException {
        super.initialize(abstractSession);
        this.setFieldClassification(XMLTypePlaceholder.class);
    }

    public DirectToXMLTypeMapping() {
        this.xmlTransformer.setFormattedOutput(false);
        this.xmlParser = XMLPlatformFactory.getInstance().getXMLPlatform().newXMLParser();
        this.xmlComparer = new XMLComparer();
    }

    public void setShouldReadWholeDocument(boolean bl) {
        this.shouldReadWholeDocument = bl;
    }

    public boolean shouldReadWholeDocument() {
        return this.shouldReadWholeDocument;
    }

    public Object getAttributeValue(Object object, AbstractSession abstractSession) throws DescriptorException {
        Object object2 = object;
        try {
            if (object2 != null && this.getAttributeClassification() != ClassConstants.STRING) {
                String string = (String)object2;
                StringReader stringReader = new StringReader(string);
                return this.xmlParser.parse(stringReader);
            }
        }
        catch (Exception exception) {
            throw ConversionException.couldNotBeConverted(object, this.getAttributeClassification(), exception);
        }
        return object2;
    }

    public boolean isDirectToXMLTypeMapping() {
        return true;
    }

    public void buildClone(Object object, Object object2, UnitOfWorkImpl unitOfWorkImpl) {
        Object object3 = this.getAttributeValueFromObject(object);
        if (object3 != null) {
            if (this.getAttributeClassification() == ClassConstants.DOCUMENT || this.getAttributeClassification() == ClassConstants.NODE) {
                Document document = (Document)object3;
                this.setAttributeValueInObject(object2, document.cloneNode(true));
            } else {
                super.buildClone(object, object2, unitOfWorkImpl);
            }
        }
    }

    public boolean compareObjects(Object object, Object object2, AbstractSession abstractSession) {
        if (this.getAttributeClassification() == ClassConstants.STRING) {
            return object.equals(object2);
        }
        Object object3 = this.getFieldValue(this.getAttributeValueFromObject(object), abstractSession);
        Object object4 = this.getFieldValue(this.getAttributeValueFromObject(object2), abstractSession);
        if (object3 == null && object4 == null) {
            return true;
        }
        if (object3 == null || object4 == null) {
            return false;
        }
        if (object3 instanceof Node && object4 instanceof Node) {
            return this.xmlComparer.isNodeEqual((Node)object3, (Node)object4);
        }
        return object3.equals(object4);
    }

    public Object valueFromRow(AbstractRecord abstractRecord, JoinedAttributeManager joinedAttributeManager, ObjectBuildingQuery objectBuildingQuery, AbstractSession abstractSession) {
        Object object = abstractRecord.get(this.field);
        Object object2 = this.getAttributeValue(object, abstractSession);
        return object2;
    }
}

