/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.sql.DataSource;
import oracle.jdbc.pool.OracleOCIConnectionPool;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.sessions.JNDIConnector;

public class OracleOCIProxyConnector
extends JNDIConnector {
    public OracleOCIProxyConnector() {
    }

    public OracleOCIProxyConnector(Context context, String string) throws ValidationException {
        super(context, string);
    }

    public OracleOCIProxyConnector(String string) {
        super(string);
    }

    public OracleOCIProxyConnector(OracleOCIConnectionPool oracleOCIConnectionPool) {
        super((DataSource)oracleOCIConnectionPool);
    }

    public Connection connect(Properties properties) throws DatabaseException, ValidationException {
        String string = properties.getProperty("proxytype");
        if (string == null || string.length() == 0) {
            return super.connect(properties);
        }
        try {
            OracleOCIConnectionPool oracleOCIConnectionPool = (OracleOCIConnectionPool)this.getDataSource();
            if (oracleOCIConnectionPool == null) {
                try {
                    oracleOCIConnectionPool = (OracleOCIConnectionPool)this.getContext().lookup(this.getName());
                    this.setDataSource((DataSource)oracleOCIConnectionPool);
                }
                catch (NamingException namingException) {
                    throw ValidationException.cannotAcquireDataSource(this.getName(), namingException);
                }
            }
            return oracleOCIConnectionPool.getProxyConnection(string, properties);
        }
        catch (SQLException sQLException) {
            throw DatabaseException.sqlException(sQLException, true);
        }
        catch (ClassCastException classCastException) {
            throw ValidationException.oracleOCIProxyConnectorRequiresOracleOCIConnectionPool();
        }
    }
}

