/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import commonj.sdo.helper.HelperContext;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.helper.DynamicClassWriter;
import org.eclipse.persistence.sdo.helper.SDOTypeHelper;

public class SDOClassLoader
extends ClassLoader {
    private Map generatedClasses;
    private HelperContext aHelperContext;

    public SDOClassLoader(ClassLoader classLoader, HelperContext helperContext) {
        super(classLoader);
        this.aHelperContext = helperContext;
        this.generatedClasses = new HashMap();
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        Class<?> clazz = null;
        clazz = (Class<?>)this.generatedClasses.get(string);
        if (clazz != null) {
            return clazz;
        }
        try {
            clazz = this.getParent().loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw classNotFoundException;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw noClassDefFoundError;
        }
        return clazz;
    }

    public Class loadClass(String string, SDOType sDOType) throws ClassNotFoundException {
        Class clazz;
        block6: {
            clazz = null;
            clazz = (Class)this.generatedClasses.get(string);
            if (clazz != null) {
                return clazz;
            }
            try {
                clazz = this.getParent().loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = this.createGeneric(string, sDOType);
                if (clazz == null) {
                    throw classNotFoundException;
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                clazz = this.createGeneric(string, sDOType);
                if (clazz != null) break block6;
                throw noClassDefFoundError;
            }
        }
        if (!sDOType.isDataType() && null != this.aHelperContext && null != this.aHelperContext.getTypeHelper()) {
            ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getImplClassesToSDOType().put(clazz, sDOType);
        }
        return clazz;
    }

    public Class createGeneric(String string, SDOType sDOType) {
        Class<?> clazz = (Class<?>)this.generatedClasses.get(string);
        if (clazz != null) {
            return clazz;
        }
        if (string == null) {
            return null;
        }
        DynamicClassWriter dynamicClassWriter = new DynamicClassWriter(string, sDOType, this.aHelperContext);
        byte[] byArray = dynamicClassWriter.createClass();
        clazz = this.defineClass(string, byArray, 0, byArray.length);
        this.generatedClasses.put(string, clazz);
        return clazz;
    }
}

