/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.Collator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWColumnHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWMappingHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.AggregateRuntimeFieldNameGenerator;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWAggregateMapping;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWAggregatePathToColumn
extends MWModel {
    private List mappingHandles;
    private volatile AggregateRuntimeFieldNameGenerator aggregateRuntimeFieldNameGenerator;
    public static final String AGGREGATE_RUNTIME_FIELD_NAME_GENERATOR_PROPERTY = "aggregateRuntimeFieldNameGenerator";
    private volatile String fieldDescription;
    private MWColumnHandle columnHandle;
    public static final String COLUMN_PROPERTY = "column";

    private MWAggregatePathToColumn() {
    }

    MWAggregatePathToColumn(MWAggregateMapping mWAggregateMapping) {
        super(mWAggregateMapping);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.mappingHandles = new Vector();
        this.columnHandle = new MWColumnHandle(this, this.buildColumnScrubber());
    }

    public MWColumn getColumn() {
        return this.columnHandle.getColumn();
    }

    public void setColumn(MWColumn mWColumn) {
        MWColumn mWColumn2 = this.getColumn();
        this.columnHandle.setColumn(mWColumn);
        this.firePropertyChanged(COLUMN_PROPERTY, mWColumn2, mWColumn);
    }

    public AggregateRuntimeFieldNameGenerator getAggregateRuntimeFieldNameGenerator() {
        return this.aggregateRuntimeFieldNameGenerator;
    }

    public void setAggregateRuntimeFieldNameGenerator(AggregateRuntimeFieldNameGenerator aggregateRuntimeFieldNameGenerator) {
        this.aggregateRuntimeFieldNameGenerator = aggregateRuntimeFieldNameGenerator;
    }

    void addMappingNode(MWMapping mWMapping) {
        if (this.getMappingNodes().contains(mWMapping)) {
            return;
        }
        this.mappingHandles.add(new MWMappingHandle(this, mWMapping, MWHandle.NodeReferenceScrubber.NULL_INSTANCE));
    }

    private void addMappingAt(int n, MWMapping mWMapping) {
        this.mappingHandles.add(n, new MWMappingHandle(this, mWMapping, MWHandle.NodeReferenceScrubber.NULL_INSTANCE));
    }

    MWAggregatePathToColumn copy(MWAggregateMapping mWAggregateMapping) {
        MWAggregatePathToColumn mWAggregatePathToColumn = new MWAggregatePathToColumn(mWAggregateMapping);
        Iterator iterator = this.getMappingNodes().iterator();
        while (iterator.hasNext()) {
            mWAggregatePathToColumn.addMappingNode((MWMapping)iterator.next());
        }
        mWAggregatePathToColumn.setAggregateRuntimeFieldNameGenerator(this.getAggregateRuntimeFieldNameGenerator());
        mWAggregatePathToColumn.setColumn(this.columnHandle.getColumn());
        return mWAggregatePathToColumn;
    }

    MWMapping mappingAt(int n) {
        return (MWMapping)this.getMappingNodes().get(n);
    }

    List getMappingNodes() {
        Vector<MWMapping> vector = new Vector<MWMapping>(this.mappingHandles.size());
        CloneIterator cloneIterator = new CloneIterator(this.mappingHandles);
        while (cloneIterator.hasNext()) {
            vector.add(((MWMappingHandle)cloneIterator.next()).getMapping());
        }
        return vector;
    }

    void insertRootMappingNode(MWMapping mWMapping) {
        this.addMappingAt(0, mWMapping);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        List list2 = this.mappingHandles;
        synchronized (list2) {
            list.addAll(this.mappingHandles);
        }
        list.add(this.columnHandle);
    }

    private MWHandle.NodeReferenceScrubber buildColumnScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWAggregatePathToColumn.this.setColumn(null);
            }

            public String toString() {
                return "MWAggregatePathToColumn.buildColumnScrubber()";
            }
        };
    }

    public void mappingReplaced(MWMapping mWMapping, MWMapping mWMapping2) {
        super.mappingReplaced(mWMapping, mWMapping2);
    }

    boolean isPathReadOnly() {
        for (MWMapping mWMapping : this.getMappingNodes()) {
            if (!mWMapping.isReadOnly()) continue;
            return true;
        }
        return false;
    }

    boolean fieldIsWritten() {
        if (this.isPathReadOnly()) {
            return false;
        }
        return this.aggregateRuntimeFieldNameGenerator.fieldIsWritten();
    }

    public String getPathDescription() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        Iterator iterator = this.getMappingNodes().iterator();
        if (iterator.hasNext()) {
            printWriter.print(this.mappingAt(0).getParentDescriptor().getMWClass().shortName());
        } else {
            printWriter.print(this.aggregateRuntimeFieldNameGenerator.owningDescriptor().getMWClass().shortName());
        }
        while (iterator.hasNext()) {
            printWriter.print(".");
            printWriter.print(((MWMapping)iterator.next()).getName());
        }
        return stringWriter.getBuffer().toString();
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.getPathDescription());
        stringBuffer.append(" -> ");
        if (this.getColumn() == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append(this.getColumn().qualifiedName());
        }
    }

    public String description() {
        StringBuffer stringBuffer = new StringBuffer();
        this.toString(stringBuffer);
        return stringBuffer.toString();
    }

    public int compareTo(Object object) {
        MWAggregatePathToColumn mWAggregatePathToColumn = (MWAggregatePathToColumn)object;
        return Collator.getInstance().compare(this.getPathDescription() + this.getAggregateRuntimeFieldNameGenerator().fieldNameForRuntime(), mWAggregatePathToColumn.getPathDescription() + mWAggregatePathToColumn.getAggregateRuntimeFieldNameGenerator().fieldNameForRuntime());
    }

    private MWAggregateMapping getAggregateMapping() {
        return (MWAggregateMapping)this.getParent();
    }

    private MWRelationalDescriptor getParentDescriptor() {
        return (MWRelationalDescriptor)((Object)this.getAggregateMapping().getParentDescriptor());
    }

    void adjustRuntimeMapping(AggregateObjectMapping aggregateObjectMapping) {
        if (!this.getParentDescriptor().isAggregateDescriptor()) {
            if (this.getColumn() != null) {
                aggregateObjectMapping.addFieldNameTranslation(this.getColumn().qualifiedName(), this.calculateAggregateFieldName());
            }
        } else {
            aggregateObjectMapping.addFieldNameTranslation(this.calculateSourceFieldName(), this.calculateAggregateFieldName());
        }
    }

    private String calculateAggregateFieldName() {
        String string = "";
        ListIterator listIterator = this.getMappingNodes().listIterator();
        while (listIterator.hasNext()) {
            MWMapping mWMapping = (MWMapping)listIterator.next();
            if (string.equals("")) {
                string = string + mWMapping.getName();
                continue;
            }
            string = string + "_" + mWMapping.getName();
        }
        if (!string.equals("")) {
            string = string + "->";
        }
        string = string + this.getAggregateRuntimeFieldNameGenerator().fieldNameForRuntime();
        return string;
    }

    private String calculateSourceFieldName() {
        return ((MWAggregateMapping)this.getParent()).getName() + "_" + this.calculateAggregateFieldName();
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWAggregatePathToColumn.class);
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName(AGGREGATE_RUNTIME_FIELD_NAME_GENERATOR_PROPERTY);
        xMLDirectMapping.setGetMethodName("getFieldDescriptionForTopLink");
        xMLDirectMapping.setSetMethodName("setFieldDescriptionForTopLink");
        xMLDirectMapping.setXPath("field-description/text()");
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("columnHandle");
        xMLCompositeObjectMapping.setGetMethodName("getColumnHandleForTopLink");
        xMLCompositeObjectMapping.setSetMethodName("setColumnHandleForTopLink");
        xMLCompositeObjectMapping.setReferenceClass(MWColumnHandle.class);
        xMLCompositeObjectMapping.setXPath("column-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping.setAttributeName("mappingHandles");
        xMLCompositeCollectionMapping.setGetMethodName("getMappingHandlesForTopLink");
        xMLCompositeCollectionMapping.setSetMethodName("setMappingHandlesForTopLink");
        xMLCompositeCollectionMapping.setReferenceClass(MWMappingHandle.class);
        xMLCompositeCollectionMapping.setXPath("mapping-handles/mapping-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping);
        return xMLDescriptor;
    }

    private String getFieldDescriptionForTopLink() {
        return this.getAggregateRuntimeFieldNameGenerator().fieldNameForRuntime();
    }

    private void setFieldDescriptionForTopLink(String string) {
        this.fieldDescription = string;
    }

    private List getMappingHandlesForTopLink() {
        return this.mappingHandles;
    }

    private void setMappingHandlesForTopLink(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ((MWMappingHandle)iterator.next()).setScrubber(MWHandle.NodeReferenceScrubber.NULL_INSTANCE);
        }
        this.mappingHandles = list;
    }

    private MWColumnHandle getColumnHandleForTopLink() {
        return this.columnHandle.getColumn() == null ? null : this.columnHandle;
    }

    private void setColumnHandleForTopLink(MWColumnHandle mWColumnHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildColumnScrubber();
        this.columnHandle = mWColumnHandle == null ? new MWColumnHandle(this, nodeReferenceScrubber) : mWColumnHandle.setScrubber(nodeReferenceScrubber);
    }

    public void postProjectBuild() {
        Object object;
        Iterator iterator;
        super.postProjectBuild();
        if (this.fieldDescription == null) {
            return;
        }
        if (this.mappingHandles.size() == 0) {
            iterator = ((MWRelationalDescriptor)((Object)this.getAggregateMapping().getReferenceDescriptor())).buildAggregateFieldNameGenerators().iterator();
        } else {
            object = (MWMappingHandle)this.mappingHandles.get(this.mappingHandles.size() - 1);
            iterator = ((MWMappingHandle)object).getMapping().aggregateFieldNameGenerators();
            if (!iterator.hasNext()) {
                iterator = ((MWRelationalDescriptor)((Object)((MWAggregateMapping)((MWMappingHandle)object).getMapping()).getReferenceDescriptor())).buildAggregateFieldNameGenerators().iterator();
            }
        }
        while (iterator.hasNext()) {
            object = (AggregateRuntimeFieldNameGenerator)iterator.next();
            if (!this.fieldDescription.equals(object.fieldNameForRuntime())) continue;
            this.setAggregateRuntimeFieldNameGenerator((AggregateRuntimeFieldNameGenerator)object);
            break;
        }
        this.fieldDescription = null;
    }
}

