/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.persistence.internal.indirection.IndirectionPolicy;
import org.eclipse.persistence.internal.indirection.ProxyIndirectionPolicy;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumnPair;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWReference;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalClassDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWColumnPairHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWProxyIndirectionMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWAbstractTableReferenceMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWVariableOneToOneMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassCodeGenPolicy;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public final class MWOneToOneMapping
extends MWAbstractTableReferenceMapping
implements MWProxyIndirectionMapping {
    private Collection targetForeignKeyHandles;
    public static final String TARGET_FOREIGN_KEYS_COLLECTION = "targetForeignKeys";
    private MWHandle.NodeReferenceScrubber targetForeignKeyScrubber;

    private MWOneToOneMapping() {
    }

    MWOneToOneMapping(MWRelationalClassDescriptor mWRelationalClassDescriptor, MWClassAttribute mWClassAttribute, String string) {
        super(mWRelationalClassDescriptor, mWClassAttribute, string);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.targetForeignKeyHandles = new Vector();
    }

    protected void initialize(MWClassAttribute mWClassAttribute, String string) {
        super.initialize(mWClassAttribute, string);
        if (!this.getInstanceVariable().isValueHolder() && this.getInstanceVariable().getType().isInterface()) {
            this.indirectionType = "proxy-indirection";
        }
        if (this.getProject().usesWeaving()) {
            this.indirectionType = "value-holder-indirection";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        Collection collection = this.targetForeignKeyHandles;
        synchronized (collection) {
            list.addAll(this.targetForeignKeyHandles);
        }
    }

    private MWHandle.NodeReferenceScrubber targetForeignKeyScrubber() {
        if (this.targetForeignKeyScrubber == null) {
            this.targetForeignKeyScrubber = this.buildTargetForeignKeyScrubber();
        }
        return this.targetForeignKeyScrubber;
    }

    private MWHandle.NodeReferenceScrubber buildTargetForeignKeyScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWOneToOneMapping.this.removeTargetForeignKeyHandle((MWColumnPairHandle)mWHandle);
            }

            public String toString() {
                return "MWOneToOneMapping.buildTargetForeignKeyScrubber()";
            }
        };
    }

    protected void automapIndirection() {
        if (this.getInstanceVariable().isValueHolder() || this.getProject().usesWeaving()) {
            this.setUseValueHolderIndirection();
        }
    }

    private Iterator targetForeignKeyHandles() {
        return new CloneIterator(this.targetForeignKeyHandles){

            protected void remove(Object object) {
                MWOneToOneMapping.this.removeTargetForeignKeyHandle((MWColumnPairHandle)object);
            }
        };
    }

    void removeTargetForeignKeyHandle(MWColumnPairHandle mWColumnPairHandle) {
        this.targetForeignKeyHandles.remove(mWColumnPairHandle);
        this.fireItemRemoved(TARGET_FOREIGN_KEYS_COLLECTION, mWColumnPairHandle.getColumnPair());
    }

    public Iterator targetForeignKeys() {
        return new TransformationIterator(this.targetForeignKeyHandles()){

            protected Object transform(Object object) {
                return ((MWColumnPairHandle)object).getColumnPair();
            }
        };
    }

    public int targetForeignKeysSize() {
        return this.targetForeignKeyHandles.size();
    }

    public void addTargetForeignKey(MWColumnPair mWColumnPair) {
        this.targetForeignKeyHandles.add(new MWColumnPairHandle(this, mWColumnPair, this.targetForeignKeyScrubber()));
        this.fireItemAdded(TARGET_FOREIGN_KEYS_COLLECTION, mWColumnPair);
    }

    public void removeTargetForeignKey(MWColumnPair mWColumnPair) {
        Iterator iterator = this.targetForeignKeys();
        while (iterator.hasNext()) {
            if (iterator.next() != mWColumnPair) continue;
            iterator.remove();
            return;
        }
        throw new IllegalArgumentException(mWColumnPair.toString());
    }

    public void clearTargetForeignKeys() {
        Iterator iterator = this.targetForeignKeyHandles();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    public void setReference(MWReference mWReference) {
        if (this.getReference() != mWReference) {
            this.clearTargetForeignKeys();
        }
        super.setReference(mWReference);
    }

    public boolean usesProxyIndirection() {
        return this.getIndirectionType() == "proxy-indirection";
    }

    public void setUseProxyIndirection() {
        this.setIndirectionType("proxy-indirection");
    }

    public boolean containsTargetForeignKey(MWColumnPair mWColumnPair) {
        return CollectionTools.contains(this.targetForeignKeys(), (Object)mWColumnPair);
    }

    protected boolean fieldIsWritten(MWColumnPair mWColumnPair) {
        return !this.containsTargetForeignKey(mWColumnPair);
    }

    protected Set buildCandidateReferences() {
        HashSet hashSet = new HashSet();
        hashSet.addAll(this.buildCandidateSourceReferences());
        hashSet.addAll(this.buildCandidateTargetReferences());
        return hashSet;
    }

    public boolean sourceReferenceFieldsAreFromSourceDescriptorTables() {
        return true;
    }

    public boolean isOneToOneMapping() {
        return true;
    }

    public MWOneToOneMapping asMWOneToOneMapping() {
        return this;
    }

    protected void initializeOn(MWMapping mWMapping) {
        mWMapping.initializeFromMWOneToOneMapping(this);
    }

    public void initializeFromMWDirectMapping(MWDirectMapping mWDirectMapping) {
        super.initializeFromMWDirectMapping(mWDirectMapping);
    }

    public void initializeFromMWVariableOneToOneMapping(MWVariableOneToOneMapping mWVariableOneToOneMapping) {
        super.initializeFromMWVariableOneToOneMapping(mWVariableOneToOneMapping);
        if (mWVariableOneToOneMapping.usesValueHolderIndirection()) {
            this.setUseValueHolderIndirection();
        } else if (mWVariableOneToOneMapping.usesNoIndirection()) {
            this.setUseNoIndirection();
        }
    }

    public String initialValue(MWClassCodeGenPolicy mWClassCodeGenPolicy) {
        String string = super.initialValue(mWClassCodeGenPolicy);
        if (this.isResponsibleForWritingPrimaryKey()) {
            string = StringTools.CR + "\t\t" + mWClassCodeGenPolicy.oneToOneMappingThatControlsWritingOfPrimaryKeyComment(this) + StringTools.CR + "\t\t" + this.getInstanceVariable().initialValueSourceCodeFor(null);
        }
        return string;
    }

    protected boolean isResponsibleForWritingPrimaryKey() {
        if (this.parentDescriptorIsAggregate() || this.isReadOnly()) {
            return false;
        }
        ArrayList arrayList = new ArrayList();
        this.addWrittenFieldsTo(arrayList);
        Iterator iterator = ((MWTableDescriptor)this.getParentDescriptor()).primaryKeyPolicy().primaryKeys();
        while (iterator.hasNext()) {
            if (!arrayList.contains(iterator.next())) continue;
            return true;
        }
        return false;
    }

    protected Collection buildAggregateFieldNameGenerators() {
        Collection collection = super.buildAggregateFieldNameGenerators();
        if (this.getReference() != null) {
            Iterator iterator = this.getReference().columnPairs();
            while (iterator.hasNext()) {
                collection.add(new MWAbstractTableReferenceMapping.ColumnPairAggregateRuntimeFieldNameGenerator(this, (MWColumnPair)iterator.next(), true));
            }
        }
        return collection;
    }

    public boolean usesAnyOf() {
        return false;
    }

    public boolean isTraversableForReadAllQueryOrderable() {
        return true;
    }

    public String iconKey() {
        return "mapping.oneToOne";
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        this.addUsesIndirectionWhileMaintainsBiDirectionalRelationship(list);
    }

    private void addUsesIndirectionWhileMaintainsBiDirectionalRelationship(List list) {
        if (this.maintainsBidirectionalRelationship() && this.usesNoIndirection()) {
            list.add(this.buildProblem("0468"));
        }
    }

    public void addWrittenFieldsTo(Collection collection) {
        if (this.isReadOnly()) {
            return;
        }
        if (this.getReference() != null) {
            Iterator iterator = this.getReference().columnPairs();
            while (iterator.hasNext()) {
                MWColumnPair mWColumnPair = (MWColumnPair)iterator.next();
                if (this.containsTargetForeignKey(mWColumnPair) || mWColumnPair.getSourceColumn() == null) continue;
                collection.add(mWColumnPair.getSourceColumn());
            }
        }
    }

    protected DatabaseMapping buildRuntimeMapping() {
        return new OneToOneMapping();
    }

    public DatabaseMapping runtimeMapping() {
        OneToOneMapping oneToOneMapping = (OneToOneMapping)super.runtimeMapping();
        if (this.getReference() == null) {
            return oneToOneMapping;
        }
        Iterator iterator = this.getReference().columnPairs();
        while (iterator.hasNext()) {
            MWColumnPair mWColumnPair = (MWColumnPair)iterator.next();
            MWColumn mWColumn = mWColumnPair.getSourceColumn();
            MWColumn mWColumn2 = mWColumnPair.getTargetColumn();
            if (mWColumn == null || mWColumn2 == null) continue;
            if (this.containsTargetForeignKey(mWColumnPair)) {
                if (CollectionTools.contains(this.getParentRelationalDescriptor().candidateTables(), (Object)mWColumnPair.sourceTable()) && !CollectionTools.contains(this.getParentRelationalDescriptor().candidateTables(), (Object)mWColumnPair.targetTable())) {
                    mWColumn = mWColumnPair.getTargetColumn();
                    mWColumn2 = mWColumnPair.getSourceColumn();
                }
                if (!this.parentDescriptorIsAggregate()) {
                    oneToOneMapping.addTargetForeignKeyFieldName(mWColumn.qualifiedName(), mWColumn2.qualifiedName());
                    continue;
                }
                oneToOneMapping.addTargetForeignKeyFieldName(mWColumn.qualifiedName(), this.getName() + "->" + mWColumn2.qualifiedName() + "_IN_REFERENCE_" + this.getReference().getName());
                continue;
            }
            if (!this.parentDescriptorIsAggregate()) {
                oneToOneMapping.addForeignKeyFieldName(mWColumn.qualifiedName(), mWColumn2.qualifiedName());
                continue;
            }
            oneToOneMapping.addForeignKeyFieldName(this.getName() + "->" + mWColumn.getName() + "_IN_REFERENCE_" + this.getReference().getName(), mWColumn2.qualifiedName());
        }
        if (this.usesProxyIndirection()) {
            oneToOneMapping.setIndirectionPolicy((IndirectionPolicy)new ProxyIndirectionPolicy());
        }
        return oneToOneMapping;
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWOneToOneMapping.class);
        xMLDescriptor.getInheritancePolicy().setParentClass(MWAbstractTableReferenceMapping.class);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping.setAttributeName("targetForeignKeyHandles");
        xMLCompositeCollectionMapping.setGetMethodName("getTargetForeignKeyHandlesForTopLink");
        xMLCompositeCollectionMapping.setSetMethodName("setTargetForeignKeyHandlesForTopLink");
        xMLCompositeCollectionMapping.setReferenceClass(MWColumnPairHandle.class);
        xMLCompositeCollectionMapping.setXPath("target-foreign-key-handles/column-pair-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping);
        return xMLDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getTargetForeignKeyHandlesForTopLink() {
        Collection collection = this.targetForeignKeyHandles;
        synchronized (collection) {
            return new TreeSet(this.targetForeignKeyHandles);
        }
    }

    private void setTargetForeignKeyHandlesForTopLink(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ((MWColumnPairHandle)iterator.next()).setScrubber(this.targetForeignKeyScrubber());
        }
        this.targetForeignKeyHandles = collection;
    }

    public static XMLDescriptor legacy60BuildDescriptor() {
        XMLDescriptor xMLDescriptor = MWModel.legacy60BuildStandardDescriptor();
        xMLDescriptor.setJavaClass(MWOneToOneMapping.class);
        xMLDescriptor.getInheritancePolicy().setParentClass(MWAbstractTableReferenceMapping.class);
        ((XMLDirectMapping)xMLDescriptor.addDirectMapping("usesJoining", "legacyGetUsesJoiningForToplink", "legacySetUsesJoiningForToplink", "uses-joining")).setNullValue((Object)Boolean.FALSE);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping.setAttributeName("targetForeignKeyHandles");
        xMLCompositeCollectionMapping.setGetMethodName("getTargetForeignKeyHandlesForTopLink");
        xMLCompositeCollectionMapping.setSetMethodName("setTargetForeignKeyHandlesForTopLink");
        xMLCompositeCollectionMapping.setReferenceClass(MWColumnPairHandle.class);
        xMLCompositeCollectionMapping.setXPath("target-foreign-key-handles/column-pair-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping);
        return xMLDescriptor;
    }

    private boolean legacyGetUsesJoiningForToplink() {
        throw new UnsupportedOperationException();
    }

    private void legacySetUsesJoiningForToplink(boolean bl) {
        if (bl) {
            this.setJoinFetchingForToplink("INNER");
        } else {
            this.setJoinFetchingForToplink("NONE");
        }
    }
}

