/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.platform.database.oracle.NCharacter;
import org.eclipse.persistence.platform.database.oracle.NClob;
import org.eclipse.persistence.platform.database.oracle.NString;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWConverterMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWTypeConversionConverter;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWTypeDeclaration;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.ArrayIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;

public final class MWRelationalTypeConversionConverter
extends MWTypeConversionConverter {
    private static final Class[] N_TYPE_CLASSES = new Class[]{NCharacter.class, NString.class, NClob.class};
    private static final String[] ORACLE_SPECIFIC_TYPE_NAMES = new String[]{"oracle.sql.TIMESTAMP", "oracle.sql.TIMESTAMPLTZ", "oracle.sql.TIMESTAMPTZ"};

    private MWRelationalTypeConversionConverter() {
    }

    protected MWRelationalTypeConversionConverter(MWConverterMapping mWConverterMapping) {
        super(mWConverterMapping);
    }

    public MWRelationalTypeConversionConverter(MWConverterMapping mWConverterMapping, Map map) {
        super(mWConverterMapping);
        this.legacyInitialize(map);
    }

    public Set getBasicTypes() {
        Set set = super.getBasicTypes();
        this.addNTypeDatabaseTypeDeclarationsTo(set);
        this.addOracleSpecificDatabaseTypeDeclarationsTo(set);
        return set;
    }

    private Iterator nTypes() {
        return new TransformationIterator(new ArrayIterator(N_TYPE_CLASSES)){

            protected Object transform(Object object) {
                return MWRelationalTypeConversionConverter.this.typeFor((Class)object);
            }
        };
    }

    private void addNTypeDatabaseTypeDeclarationsTo(Collection collection) {
        Iterator iterator = this.nTypes();
        while (iterator.hasNext()) {
            collection.add(new MWTypeDeclaration((MWModel)this, (MWClass)iterator.next()));
        }
    }

    private Iterator oracleSpecificTypes() {
        return new TransformationIterator(new ArrayIterator(ORACLE_SPECIFIC_TYPE_NAMES)){

            protected Object transform(Object object) {
                return MWRelationalTypeConversionConverter.this.typeNamed((String)object);
            }
        };
    }

    private void addOracleSpecificDatabaseTypeDeclarationsTo(Collection collection) {
        Iterator iterator = this.oracleSpecificTypes();
        while (iterator.hasNext()) {
            collection.add(new MWTypeDeclaration((MWModel)this, (MWClass)iterator.next()));
        }
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        if (this.getDataType() != null) {
            this.checkNType(list);
            this.checkOracleSpecificType(list);
        }
    }

    private void checkNType(List list) {
        if (this.dataTypeIsNType() && !this.getDatabase().getDatabasePlatform().containsDatabaseTypeNamed("NCHAR")) {
            list.add(this.buildProblem("0545"));
        }
    }

    private void checkOracleSpecificType(List list) {
        if (this.dataTypeIsOracleSpecificType() && !this.getDatabase().getDatabasePlatform().containsDatabaseTypeNamed("TIMESTAMP WITH LOCAL TIME ZONE")) {
            list.add(this.buildProblem("0546"));
        }
    }

    private boolean dataTypeIsNType() {
        return CollectionTools.contains(this.nTypes(), (Object)this.getDataType().getType());
    }

    private boolean dataTypeIsOracleSpecificType() {
        return CollectionTools.contains(this.oracleSpecificTypes(), (Object)this.getDataType().getType());
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWRelationalTypeConversionConverter.class);
        xMLDescriptor.getInheritancePolicy().setParentClass(MWTypeConversionConverter.class);
        return xMLDescriptor;
    }
}

