/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.eis.mappings.EISOneToOneMapping;
import org.eclipse.persistence.internal.indirection.IndirectionPolicy;
import org.eclipse.persistence.internal.indirection.ProxyIndirectionPolicy;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.xml.MWEisDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWProxyIndirectionMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWEisReferenceMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWXmlFieldPair;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.xml.MWEisInteraction;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.xml.MWEisQueryManager;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXmlField;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWEisOneToOneMapping
extends MWEisReferenceMapping
implements MWProxyIndirectionMapping {
    private volatile boolean useDescriptorReadObjectInteraction;
    public static final String USE_DESCRIPTOR_READ_OBJECT_INTERACTION_PROPERTY = "useDescriptorReadObjectInteraction";

    private MWEisOneToOneMapping() {
    }

    public MWEisOneToOneMapping(MWEisDescriptor mWEisDescriptor, MWClassAttribute mWClassAttribute, String string) {
        super(mWEisDescriptor, mWClassAttribute, string);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.useDescriptorReadObjectInteraction = true;
    }

    protected void initialize(MWClassAttribute mWClassAttribute, String string) {
        super.initialize(mWClassAttribute, string);
        if (!this.getInstanceVariable().isValueHolder() && this.getInstanceVariable().getType().isInterface()) {
            this.indirectionType = "proxy-indirection";
        }
    }

    protected boolean requiresSelectionInteraction() {
        return false;
    }

    public boolean usesDescriptorReadObjectInteraction() {
        return this.useDescriptorReadObjectInteraction;
    }

    public void setUseDescriptorReadObjectInteraction(boolean bl) {
        boolean bl2 = this.useDescriptorReadObjectInteraction;
        this.useDescriptorReadObjectInteraction = bl;
        if (bl2 != bl) {
            this.firePropertyChanged(USE_DESCRIPTOR_READ_OBJECT_INTERACTION_PROPERTY, bl2, bl);
            this.setSelectionInteraction(bl ? null : new MWEisInteraction(this));
        }
    }

    private MWEisInteraction referenceDescriptorReadInteraction() {
        return this.referenceRootEisDescriptor() == null ? null : ((MWEisQueryManager)this.referenceRootEisDescriptor().getQueryManager()).getReadObjectInteraction();
    }

    public boolean sourceFieldMayUseCollectionXpath() {
        return false;
    }

    public boolean usesProxyIndirection() {
        return this.getIndirectionType() == "proxy-indirection";
    }

    public void setUseProxyIndirection() {
        this.setIndirectionType("proxy-indirection");
    }

    protected void initializeOn(MWMapping mWMapping) {
        mWMapping.initializeFromMWEisOneToOneMapping(this);
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        this.checkFieldPairs(list);
        this.checkReferenceDescriptorReadInteraction(list);
        this.checkFieldPairsAndReadInteractionArguments(list);
        this.addUsesIndirectionWhileMaintainsBiDirectionalRelationship(list);
    }

    private void checkFieldPairs(List list) {
        if (this.isReadOnly() && this.getSelectionInteraction() == null || this.xmlFieldPairsSize() == 0) {
            list.add(this.buildProblem("0610"));
        }
    }

    private void checkReferenceDescriptorReadInteraction(List list) {
        if (this.usesDescriptorReadObjectInteraction() && this.referenceRootEisDescriptor() != null && this.referenceDescriptorReadInteraction().getFunctionName() == null) {
            list.add(this.buildProblem("0611"));
        }
    }

    private void checkFieldPairsAndReadInteractionArguments(List list) {
        if (!this.usesDescriptorReadObjectInteraction() || this.referenceDescriptorReadInteraction() == null) {
            return;
        }
        ListIterator listIterator = this.referenceDescriptorReadInteraction().inputArguments();
        while (listIterator.hasNext()) {
            String string = ((MWEisInteraction.ArgumentPair)listIterator.next()).getArgumentFieldName();
            if (this.hasCorrespondingTargetKey(string)) continue;
            list.add(this.buildProblem("0612", string));
        }
    }

    private void addUsesIndirectionWhileMaintainsBiDirectionalRelationship(List list) {
        if (this.maintainsBidirectionalRelationship() && this.usesNoIndirection()) {
            list.add(this.buildProblem("0468"));
        }
    }

    private boolean hasCorrespondingTargetKey(String string) {
        ListIterator listIterator = this.xmlFieldPairs();
        while (listIterator.hasNext()) {
            MWXmlField mWXmlField = ((MWXmlFieldPair)listIterator.next()).getTargetXmlField();
            if (mWXmlField == null || !mWXmlField.getXpath().equals(string)) continue;
            return true;
        }
        return false;
    }

    protected DatabaseMapping buildRuntimeMapping() {
        return new EISOneToOneMapping();
    }

    public DatabaseMapping runtimeMapping() {
        EISOneToOneMapping eISOneToOneMapping = (EISOneToOneMapping)super.runtimeMapping();
        ListIterator listIterator = this.xmlFieldPairs();
        while (listIterator.hasNext()) {
            ((MWXmlFieldPair)listIterator.next()).addRuntimeForeignKeyField(eISOneToOneMapping);
        }
        if (this.usesProxyIndirection()) {
            eISOneToOneMapping.setIndirectionPolicy((IndirectionPolicy)new ProxyIndirectionPolicy());
        }
        return eISOneToOneMapping;
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWEisOneToOneMapping.class);
        xMLDescriptor.getInheritancePolicy().setParentClass(MWEisReferenceMapping.class);
        XMLDirectMapping xMLDirectMapping = (XMLDirectMapping)xMLDescriptor.addDirectMapping(USE_DESCRIPTOR_READ_OBJECT_INTERACTION_PROPERTY, "use-descriptor-read-object-interaction/text()");
        xMLDirectMapping.setNullValue((Object)Boolean.FALSE);
        return xMLDescriptor;
    }
}

