/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.meta;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.persistence.indirection.IndirectContainer;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.codegen.AttributeDefinition;
import org.eclipse.persistence.internal.codegen.ClassDefinition;
import org.eclipse.persistence.internal.codegen.MethodDefinition;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.transformers.AttributeTransformer;
import org.eclipse.persistence.mappings.transformers.FieldTransformer;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWNominative;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWClassHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.DefaultMWClassRefreshPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassCodeGenPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRefreshPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWModifiable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWModifier;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWTypeDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ClassDescription;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassDescription;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassNotFoundException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalConstructor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalMethod;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.events.ChangeNotifier;
import org.eclipse.persistence.tools.workbench.utility.events.NullChangeNotifier;
import org.eclipse.persistence.tools.workbench.utility.iterators.ChainIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.CompositeIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.FilteringIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.SingleElementIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TreeIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public final class MWClass
extends MWModel
implements ClassDescription,
MWModifiable,
MWNominative {
    private volatile String name;
    public static final String NAME_PROPERTY = "name";
    private MWClassHandle declaringTypeHandle;
    public static final String DECLARING_TYPE_PROPERTY = "declaringType";
    private MWModifier modifier;
    private volatile boolean interfaceFlag;
    public static final String INTERFACE_PROPERTY = "interface";
    private MWClassHandle superclassHandle;
    public static final String SUPERCLASS_PROPERTY = "superclass";
    public static final String SUPERCLASSES_COLLECTION = "superclasses";
    private volatile Date lastRefreshTimestamp;
    public static final String LAST_REFRESH_TIMESTAMP_PROPERTY = "lastRefreshTimestamp";
    private Collection interfaceHandles;
    public static final String INTERFACES_COLLECTION = "interfaces";
    private MWHandle.NodeReferenceScrubber interfaceScrubber;
    private Collection attributes;
    public static final String ATTRIBUTES_COLLECTION = "attributes";
    private Collection ejb20Attributes;
    public static final String EJB20_ATTRIBUTES_COLLECTION = "ejb20Attributes";
    private volatile MWClassAttribute unknownPrimaryKeyAttribute;
    public static final String UNKNOWN_PK_ATTRIBUTE_PROPERTY = "unknownPKAttribute";
    private Collection methods;
    public static final String METHODS_COLLECTION = "methods";
    private Collection typeHandles;
    public static final String TYPES_COLLECTION = "types";
    private MWHandle.NodeReferenceScrubber typeScrubber;
    private volatile boolean primitive;
    private boolean coreType;
    private volatile boolean partiallyPopulatedCoreType;
    private volatile boolean coreTypeRefreshInProgress;
    private static PrimitiveWrapperPair[] primitiveWrapperPairs;
    private static PrimitiveWrapperPair voidPrimitiveWrapperPair;
    public static final String LEGACY_50_STUB_ATTRIBUTE_NAME = "stub";
    public static final Boolean LEGACY_50_STUB_NULL_VALUE;
    private static final int ALLOWED_MODIFIERS_FLAGS = 1040;
    private static final int METHOD_ALLOWED_MODIFIERS_FLAGS = 3088;

    private MWClass() {
    }

    MWClass(MWClassRepository mWClassRepository, String string, boolean bl) {
        super(mWClassRepository);
        this.name = string;
        this.coreType = bl;
        this.partiallyPopulatedCoreType = bl;
    }

    protected void initialize() {
        super.initialize();
        this.modifier = new MWModifier(this);
        this.partiallyPopulatedCoreType = false;
        this.coreTypeRefreshInProgress = false;
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.declaringTypeHandle = new MWClassHandle(this, this.defaultDeclaringType(), this.buildDeclaringTypeScrubber());
        this.interfaceFlag = this.defaultInterfaceFlag();
        this.lastRefreshTimestamp = null;
        this.interfaceHandles = new Vector();
        this.attributes = new Vector();
        this.ejb20Attributes = new Vector();
        this.unknownPrimaryKeyAttribute = null;
        this.methods = new Vector();
        this.typeHandles = new Vector();
    }

    void initializeNameDependentState() {
        this.primitive = this.defaultPrimitiveFlag();
        this.superclassHandle = new MWClassHandle(this, this.buildSuperclassScrubber());
        this.superclassHandle.setType(this.defaultSuperclass());
    }

    private MWClass defaultDeclaringType() {
        return null;
    }

    private boolean defaultInterfaceFlag() {
        return false;
    }

    private boolean defaultPrimitiveFlag() {
        return CollectionTools.contains(MWClass.primitiveClassNames(), (Object)this.getName());
    }

    private MWClass defaultSuperclass() {
        if (this.requiresSuperclass()) {
            return this.objectType();
        }
        return null;
    }

    public void clear() {
        if (this.isCoreType()) {
            throw new IllegalStateException();
        }
        this.setDeclaringType(this.defaultDeclaringType());
        this.getModifier().clear();
        this.setInterface(this.defaultInterfaceFlag());
        this.setSuperclass(this.defaultSuperclass());
        this.clearInterfaces();
        this.clearAttributes();
        this.clearEjb20Attributes();
        this.clearMethods();
        this.clearTypes();
    }

    public ChangeNotifier getChangeNotifier() {
        return this.coreTypeRefreshInProgress ? NullChangeNotifier.instance() : super.getChangeNotifier();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        String string2 = this.name;
        this.name = string;
        if (this.attributeValueHasChanged(string2, string)) {
            try {
                this.getRepository().typeRenamed(string2, string);
            }
            catch (RuntimeException runtimeException) {
                this.name = string2;
                throw runtimeException;
            }
            this.firePropertyChanged(NAME_PROPERTY, string2, string);
            this.getProject().nodeRenamed(this);
        }
    }

    public String fullName() {
        return this.getName();
    }

    public String shortName() {
        return ClassTools.shortNameForClassNamed(this.getName());
    }

    public String packageName() {
        return ClassTools.packageNameForClassNamed(this.getName());
    }

    public String packageDisplayName() {
        return MWClass.packageDisplayNameForClassNamed(this.getName());
    }

    public MWClass getDeclaringType() {
        return this.declaringTypeHandle.getType();
    }

    public void setDeclaringType(MWClass mWClass) {
        MWClass mWClass2 = this.declaringTypeHandle.getType();
        this.declaringTypeHandle.setType(mWClass);
        this.firePropertyChanged(DECLARING_TYPE_PROPERTY, mWClass2, mWClass);
    }

    public MWModifier getModifier() {
        return this.modifier;
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public boolean isInterface() {
        return this.interfaceFlag;
    }

    public void setInterface(boolean bl) {
        if (this.isNonReferenceType() && bl) {
            throw new IllegalStateException("A primitive cannot be converted to an interface: " + this.getName());
        }
        boolean bl2 = this.interfaceFlag;
        this.interfaceFlag = bl;
        if (bl2 != bl) {
            this.setSuperclass(this.defaultSuperclass());
        }
        this.firePropertyChanged(INTERFACE_PROPERTY, bl2, bl);
        if (bl2 != bl) {
            this.notifyMethodsOfAllowedModifiersChange();
        }
    }

    public boolean isClass() {
        return !this.isInterface();
    }

    public MWClass getSuperclass() {
        return this.superclassHandle.getType();
    }

    public void setSuperclass(MWClass mWClass) {
        if (this.requiresSuperclass() && mWClass == null) {
            throw new IllegalStateException("Superclass required: " + this);
        }
        if (this.cannotHaveSuperclass() && mWClass != null) {
            throw new IllegalStateException("Superclass not allowed: " + this);
        }
        MWClass mWClass2 = this.superclassHandle.getType();
        this.superclassHandle.setType(mWClass);
        this.firePropertyChanged(SUPERCLASS_PROPERTY, mWClass2, mWClass);
        if (mWClass2 != mWClass && !this.isCoreType()) {
            this.superclassesChanged();
            this.getRepository().hierarchyChanged(this);
            this.getProject().hierarchyChanged(this);
        }
    }

    public Date getLastRefreshTimestamp() {
        return this.lastRefreshTimestamp;
    }

    private void setLastRefreshTimestamp(Date date) {
        Date date2 = this.lastRefreshTimestamp;
        this.lastRefreshTimestamp = date;
        this.firePropertyChanged(LAST_REFRESH_TIMESTAMP_PROPERTY, date2, date);
    }

    boolean isCoreType() {
        return this.coreType;
    }

    private Iterator interfaceHandles() {
        return new CloneIterator(this.interfaceHandles){

            protected void remove(Object object) {
                MWClass.this.removeInterfaceHandle((MWClassHandle)object);
            }

            public String toString() {
                return "MWClass.interfaceHandles()";
            }
        };
    }

    void removeInterfaceHandle(MWClassHandle mWClassHandle) {
        this.interfaceHandles.remove(mWClassHandle);
        this.fireItemRemoved(INTERFACES_COLLECTION, mWClassHandle.getType());
    }

    public Iterator interfaces() {
        return new TransformationIterator(this.interfaceHandles()){

            protected Object transform(Object object) {
                return ((MWClassHandle)object).getType();
            }

            public String toString() {
                return "MWClass.interfaces()";
            }
        };
    }

    public int interfacesSize() {
        return this.interfaceHandles.size();
    }

    public void addInterface(MWClass mWClass) {
        this.interfaceHandles.add(new MWClassHandle(this, mWClass, this.interfaceScrubber()));
        this.fireItemAdded(INTERFACES_COLLECTION, mWClass);
    }

    public void addInterfaces(Collection collection) {
        this.addInterfaces(collection.iterator());
    }

    public void addInterfaces(Iterator iterator) {
        while (iterator.hasNext()) {
            this.addInterface((MWClass)iterator.next());
        }
    }

    public void removeInterface(MWClass mWClass) {
        Iterator iterator = this.interfaces();
        while (iterator.hasNext()) {
            if (iterator.next() != mWClass) continue;
            iterator.remove();
            return;
        }
        throw new IllegalArgumentException(mWClass.toString());
    }

    public void removeInterfaces(Collection collection) {
        this.removeInterfaces(collection.iterator());
    }

    public void removeInterfaces(Iterator iterator) {
        while (iterator.hasNext()) {
            this.removeInterface((MWClass)iterator.next());
        }
    }

    public void clearInterfaces() {
        Iterator iterator = this.interfaceHandles();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    public Iterator attributes() {
        this.checkForPartiallyPopulatedCoreType();
        return new CloneIterator(this.attributes){

            protected void remove(Object object) {
                MWClass.this.removeAttribute((MWClassAttribute)object);
            }

            public String toString() {
                return "MWClass.attributes()";
            }
        };
    }

    public int attributesSize() {
        this.checkForPartiallyPopulatedCoreType();
        return this.attributes.size();
    }

    public MWClassAttribute addAttribute(String string) {
        return this.addAttribute(string, this.objectType());
    }

    public MWClassAttribute addAttribute(String string, MWClass mWClass) {
        return this.addAttribute(string, mWClass, 0);
    }

    public MWClassAttribute addAttribute(String string, MWClass mWClass, int n) {
        return this.addAttribute(this.buildAttribute(string, mWClass, n));
    }

    MWClassAttribute addAttribute(ExternalField externalField) {
        return this.addAttribute(new MWClassAttribute(this, externalField));
    }

    private MWClassAttribute addAttribute(MWClassAttribute mWClassAttribute) {
        this.checkForPartiallyPopulatedCoreType();
        MWClassAttribute mWClassAttribute2 = this.ejb20AttributeNamed(mWClassAttribute.getName());
        if (mWClassAttribute2 != null) {
            this.removeEjb20Attribute(mWClassAttribute2);
        }
        this.addItemToCollection(mWClassAttribute, this.attributes, ATTRIBUTES_COLLECTION);
        return mWClassAttribute;
    }

    public void removeAttribute(MWClassAttribute mWClassAttribute) {
        this.checkForPartiallyPopulatedCoreType();
        this.removeNodeFromCollection(mWClassAttribute, this.attributes, ATTRIBUTES_COLLECTION);
    }

    public void removeAttributes(Collection collection) {
        this.removeAttributes(collection.iterator());
    }

    public void removeAttributes(Iterator iterator) {
        while (iterator.hasNext()) {
            this.removeAttribute((MWClassAttribute)iterator.next());
        }
    }

    public void clearAttributes() {
        this.removeAttributes(this.attributes());
    }

    public Iterator ejb20Attributes() {
        return new CloneIterator(this.ejb20Attributes){

            protected void remove(Object object) {
                MWClass.this.removeEjb20Attribute((MWClassAttribute)object);
            }

            public String toString() {
                return "MWClass.ejb20Attributes()";
            }
        };
    }

    public Iterator nonEjb20Attributes() {
        return this.attributes();
    }

    public int ejb20AttributesSize() {
        return this.ejb20Attributes.size();
    }

    public MWClassAttribute addEjb20Attribute(String string, MWClass mWClass) {
        return this.addEjb20Attribute(string, mWClass, 0);
    }

    public MWClassAttribute addEjb20Attribute(String string, MWClass mWClass, int n) {
        MWClassAttribute mWClassAttribute = this.addEjb20Attribute(this.buildEjb20Attribute(string, mWClass, n));
        mWClassAttribute.generateGetAndSetMethods();
        return mWClassAttribute;
    }

    private MWClassAttribute addEjb20AttributeInternal(String string, MWClass mWClass, int n) {
        return this.addEjb20Attribute(this.buildEjb20Attribute(string, mWClass, n));
    }

    private MWClassAttribute addEjb20Attribute(MWClassAttribute mWClassAttribute) {
        if (this.attributeNamed(mWClassAttribute.getName()) != null) {
            return null;
        }
        this.addItemToCollection(mWClassAttribute, this.ejb20Attributes, EJB20_ATTRIBUTES_COLLECTION);
        return mWClassAttribute;
    }

    public void removeEjb20Attribute(MWClassAttribute mWClassAttribute) {
        this.removeNodeFromCollection(mWClassAttribute, this.ejb20Attributes, EJB20_ATTRIBUTES_COLLECTION);
    }

    public void removeEjb20Attributes(Collection collection) {
        this.removeEjb20Attributes(collection.iterator());
    }

    public void removeEjb20Attributes(Iterator iterator) {
        while (iterator.hasNext()) {
            this.removeEjb20Attribute((MWClassAttribute)iterator.next());
        }
    }

    public void clearEjb20Attributes() {
        this.removeEjb20Attributes(this.ejb20Attributes());
    }

    public boolean usesUnknownPrimaryKeyAttribute() {
        return this.unknownPrimaryKeyAttribute != null;
    }

    public MWClassAttribute getUnknownPrimaryKeyAttribute() {
        return this.unknownPrimaryKeyAttribute;
    }

    public Iterator methods() {
        this.checkForPartiallyPopulatedCoreType();
        return new CloneIterator(this.methods){

            protected void remove(Object object) {
                MWClass.this.removeMethod((MWMethod)object);
            }

            public String toString() {
                return "MWClass.methods()";
            }
        };
    }

    public int methodsSize() {
        this.checkForPartiallyPopulatedCoreType();
        return this.methods.size();
    }

    public MWMethod addMethod(String string) {
        return this.addMethod(this.buildMethod(string));
    }

    public MWMethod addMethod(String string, MWClass mWClass) {
        return this.addMethod(this.buildMethod(string, mWClass));
    }

    public MWMethod addMethod(String string, MWClass mWClass, int n) {
        return this.addMethod(this.buildMethod(string, mWClass, n));
    }

    private MWMethod addMethod(MWMethod mWMethod) {
        this.checkForPartiallyPopulatedCoreType();
        this.methods.add(mWMethod);
        this.fireItemAdded(METHODS_COLLECTION, mWMethod);
        return mWMethod;
    }

    public void removeMethod(MWMethod mWMethod) {
        this.checkForPartiallyPopulatedCoreType();
        this.removeNodeFromCollection(mWMethod, this.methods, METHODS_COLLECTION);
    }

    public void removeMethods(Collection collection) {
        this.removeMethods(collection.iterator());
    }

    public void removeMethods(Iterator iterator) {
        while (iterator.hasNext()) {
            this.removeMethod((MWMethod)iterator.next());
        }
    }

    public void clearMethods() {
        this.removeMethods(this.methods());
    }

    private Iterator typeHandles() {
        this.checkForPartiallyPopulatedCoreType();
        return new CloneIterator(this.typeHandles){

            protected void remove(Object object) {
                MWClass.this.removeTypeHandle((MWClassHandle)object);
            }

            public String toString() {
                return "MWClass.typeHandles()";
            }
        };
    }

    void removeTypeHandle(MWClassHandle mWClassHandle) {
        this.typeHandles.remove(mWClassHandle);
        this.fireItemRemoved(TYPES_COLLECTION, mWClassHandle.getType());
    }

    public Iterator types() {
        return new TransformationIterator(this.typeHandles()){

            protected Object transform(Object object) {
                return ((MWClassHandle)object).getType();
            }

            public String toString() {
                return "MWClass.types()";
            }
        };
    }

    public int typesSize() {
        this.checkForPartiallyPopulatedCoreType();
        return this.typeHandles.size();
    }

    public void addType(MWClass mWClass) {
        this.checkForPartiallyPopulatedCoreType();
        this.typeHandles.add(new MWClassHandle(this, mWClass, this.typeScrubber()));
        this.fireItemAdded(TYPES_COLLECTION, mWClass);
    }

    public void addTypes(Collection collection) {
        this.addTypes(collection.iterator());
    }

    public void addTypes(Iterator iterator) {
        while (iterator.hasNext()) {
            this.addType((MWClass)iterator.next());
        }
    }

    public void removeType(MWClass mWClass) {
        Iterator iterator = this.types();
        while (iterator.hasNext()) {
            if (iterator.next() != mWClass) continue;
            iterator.remove();
            return;
        }
        throw new IllegalArgumentException(mWClass.toString());
    }

    public void removeTypes(Collection collection) {
        this.removeTypes(collection.iterator());
    }

    public void removeTypes(Iterator iterator) {
        while (iterator.hasNext()) {
            this.removeType((MWClass)iterator.next());
        }
    }

    public void clearTypes() {
        Iterator iterator = this.typeHandles();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    public boolean supportsAbstract() {
        return true;
    }

    public boolean canBeSetAbstract() {
        return !this.getModifier().isFinal();
    }

    public boolean canBeSetFinal() {
        return !this.isAbstract();
    }

    public boolean supportsInterface() {
        return true;
    }

    public boolean canBeSetInterface() {
        return true;
    }

    public boolean supportsNative() {
        return false;
    }

    public boolean canBeSetNative() {
        return false;
    }

    public boolean canBeSetPackage() {
        return true;
    }

    public boolean canBeSetPrivate() {
        return this.isMemberType();
    }

    public boolean canBeSetProtected() {
        return this.isMemberType();
    }

    public boolean canBeSetPublic() {
        return true;
    }

    public boolean canBeSetStatic() {
        return this.isMemberType();
    }

    public boolean isStrict() {
        return this.getModifier().isStrict() || this.getDeclaringType() != null && this.getDeclaringType().isStrict();
    }

    public boolean supportsStrict() {
        return true;
    }

    public boolean canBeSetStrict() {
        return true;
    }

    public boolean supportsSynchronized() {
        return false;
    }

    public boolean canBeSetSynchronized() {
        return false;
    }

    public boolean supportsTransient() {
        return false;
    }

    public boolean canBeSetTransient() {
        return false;
    }

    public boolean supportsVolatile() {
        return false;
    }

    public boolean canBeSetVolatile() {
        return false;
    }

    public void modifierChanged(int n, int n2) {
        this.firePropertyChanged("modifierCode", n, n2);
        if (MWModifier.anyFlagsAreDifferent(1040, n, n2)) {
            this.modifier.allowedModifiersChanged();
        }
        if (MWModifier.anyFlagsAreDifferent(3088, n, n2)) {
            this.notifyMethodsOfAllowedModifiersChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyMethodsOfAllowedModifiersChange() {
        Collection collection = this.methods;
        synchronized (collection) {
            Iterator iterator = this.methods.iterator();
            while (iterator.hasNext()) {
                ((MWMethod)iterator.next()).allowedModifiersChanged();
            }
        }
    }

    public void accessLevelChanged(String string, String string2) {
        this.firePropertyChanged("modifierAccessLevel", string, string2);
    }

    public Iterator externalClassDescriptions() {
        return this.getRepository().externalClassDescriptionsNamed(this.getName());
    }

    public String getAdditionalInfo() {
        return this.getProject().getName();
    }

    public boolean isMemberType() {
        return this.getDeclaringType() != null;
    }

    public boolean isReferenceType() {
        return !this.isNonReferenceType();
    }

    public boolean isNonReferenceType() {
        return this.isPrimitive() || this.isVoid();
    }

    public boolean isAbstract() {
        return this.getModifier().isAbstract() || this.isInterface();
    }

    public boolean isConcrete() {
        return !this.isAbstract();
    }

    public Iterator declaringTypeLineage() {
        return new ChainIterator(this){

            protected Object nextLink(Object object) {
                return ((MWClass)object).getDeclaringType();
            }

            public String toString() {
                return "MWClass.declaringTypeLineage()";
            }
        };
    }

    public boolean declaringTypeLineageContains(MWClass mWClass) {
        return CollectionTools.contains(this.declaringTypeLineage(), (Object)mWClass);
    }

    public Iterator declaringTypes() {
        MWClass mWClass = this.getDeclaringType();
        if (mWClass == null) {
            return NullIterator.instance();
        }
        return mWClass.declaringTypeLineage();
    }

    public boolean isStub() {
        if (this.isCoreType()) {
            return false;
        }
        return this.declaringTypeIsDefaultValue() && this.modifier.isDefaultValue() && this.superclassIsDefaultValue() && this.interfaceHandles.isEmpty() && this.getComment().length() == 0 && this.attributes.isEmpty() && this.ejb20Attributes.isEmpty() && this.unknownPrimaryKeyAttribute == null && this.methods.isEmpty() && this.typeHandles.isEmpty();
    }

    public boolean isFullyPopulated() {
        return !this.isStub();
    }

    public boolean isFullyTyped() {
        Iterator iterator = this.lineageIncludingInterfaces();
        while (iterator.hasNext()) {
            if (!((MWClass)iterator.next()).isStub()) continue;
            return false;
        }
        return true;
    }

    private boolean declaringTypeIsDefaultValue() {
        return this.getDeclaringType() == this.defaultDeclaringType();
    }

    private boolean superclassIsDefaultValue() {
        if (this.cannotHaveSuperclass()) {
            return this.getSuperclass() == null;
        }
        return this.getSuperclass().getName().equals(Object.class.getName());
    }

    Iterator expandedInterfaces() {
        class ExpandedInterfacesTreeIterator
        extends TreeIterator {
            ExpandedInterfacesTreeIterator(Object object) {
                super(object);
            }

            ExpandedInterfacesTreeIterator(Iterator iterator) {
                super(iterator);
            }

            protected Iterator children(Object object) {
                return ((MWClass)object).interfaces();
            }
        }
        return this.isInterface() ? new ExpandedInterfacesTreeIterator(this) : new ExpandedInterfacesTreeIterator(this.interfaces());
    }

    public Iterator allInterfaces() {
        return new CompositeIterator(new TransformationIterator(this.lineage()){

            protected Object transform(Object object) {
                return ((MWClass)object).expandedInterfaces();
            }

            public String toString() {
                return "MWClass.allInterfaces()";
            }
        });
    }

    public Iterator allInterfacesWithoutDuplicates() {
        return CollectionTools.set(this.allInterfaces()).iterator();
    }

    public boolean allInterfacesContains(MWClass mWClass) {
        return CollectionTools.contains(this.allInterfaces(), (Object)mWClass);
    }

    public Iterator allAttributes() {
        return new CompositeIterator(new TransformationIterator(this.lineage()){

            protected Object transform(Object object) {
                return ((MWClass)object).attributes();
            }

            public String toString() {
                return "MWClass.allAttributes()";
            }
        });
    }

    public Iterator attributeNames() {
        return this.attributeNames(this.attributes());
    }

    public Iterator visibleAttributeNames() {
        return this.attributeNames(this.visibleAttributes());
    }

    private Iterator attributeNames(Iterator iterator) {
        return new TransformationIterator(iterator){

            protected Object transform(Object object) {
                return ((MWClassAttribute)object).getName();
            }

            public String toString() {
                return "MWClass.attributeNames(Iterator)";
            }
        };
    }

    public MWClassAttribute attributeNamed(String string) {
        return this.attributeNamed(this.attributes(), string);
    }

    public boolean containsAttributeNamed(String string) {
        return this.attributeNamed(string) != null;
    }

    public MWClassAttribute attributeNamedFromAll(String string) {
        return this.attributeNamed(this.allAttributes(), string);
    }

    public boolean containsAttributeNamedFromAll(String string) {
        return this.attributeNamedFromAll(string) != null;
    }

    public MWClassAttribute attributeNamedFromCombinedAll(String string) {
        return this.attributeNamed(this.allCombinedAttributes(), string);
    }

    public boolean containsAttributeNamedFromCombinedAll(String string) {
        return this.attributeNamedFromCombinedAll(string) != null;
    }

    private MWClassAttribute attributeNamed(Iterator iterator, String string) {
        while (iterator.hasNext()) {
            MWClassAttribute mWClassAttribute = (MWClassAttribute)iterator.next();
            if (!mWClassAttribute.getName().equals(string)) continue;
            return mWClassAttribute;
        }
        return null;
    }

    public Iterator instanceVariables() {
        return this.instanceVariables(this.attributes());
    }

    public Iterator allInstanceVariables() {
        return this.instanceVariables(this.allAttributes());
    }

    private Iterator instanceVariables(Iterator iterator) {
        return new FilteringIterator(iterator){

            protected boolean accept(Object object) {
                return ((MWClassAttribute)object).isInstanceVariable();
            }

            public String toString() {
                return "MWClass.instanceVariables(Iterator)";
            }
        };
    }

    public Iterator visibleAttributes() {
        return this.visibleAttributes(this.allAttributes());
    }

    private Iterator visibleAttributes(Iterator iterator) {
        return new FilteringIterator(iterator){

            protected boolean accept(Object object) {
                MWClassAttribute mWClassAttribute = (MWClassAttribute)object;
                if (mWClassAttribute.getDeclaringType() == MWClass.this) {
                    return true;
                }
                if (mWClassAttribute.getModifier().isPrivate()) {
                    return false;
                }
                if (mWClassAttribute.getModifier().isPublic() || mWClassAttribute.getModifier().isProtected()) {
                    return true;
                }
                return MWClass.this.packageName().equals(mWClassAttribute.getDeclaringType().packageName());
            }

            public String toString() {
                return "MWClass.visibleAttributes(Iterator)";
            }
        };
    }

    public Iterator allEjb20Attributes() {
        return new CompositeIterator(new TransformationIterator(this.lineage()){

            protected Object transform(Object object) {
                return ((MWClass)object).ejb20Attributes();
            }

            public String toString() {
                return "MWClass.allEjb20Attributes()";
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MWClassAttribute ejb20AttributeNamed(String string) {
        Collection collection = this.ejb20Attributes;
        synchronized (collection) {
            return this.attributeNamed(this.ejb20Attributes.iterator(), string);
        }
    }

    public boolean containsEjb20AttributeNamed(String string) {
        return this.ejb20AttributeNamed(string) != null;
    }

    boolean ejb20AttributesContains(MWClassAttribute mWClassAttribute) {
        return this.ejb20Attributes.contains(mWClassAttribute);
    }

    public MWClassAttribute ejb20AttributeNamedFromAll(String string) {
        return this.attributeNamed(this.allEjb20Attributes(), string);
    }

    public boolean containsEjb20AttributeNamedFromAll(String string) {
        return this.ejb20AttributeNamedFromAll(string) != null;
    }

    public Iterator combinedAttributes() {
        return new CompositeIterator(this.attributes(), this.ejb20Attributes());
    }

    public MWClassAttribute combinedAttributeNamed(String string) {
        return this.attributeNamed(this.combinedAttributes(), string);
    }

    public boolean containsCombinedAttributeNamed(String string) {
        return this.combinedAttributeNamed(string) != null;
    }

    public Iterator allCombinedAttributes() {
        return this.unknownPrimaryKeyAttribute == null ? new CompositeIterator(this.allAttributes(), this.allEjb20Attributes()) : new CompositeIterator(this.allAttributes(), this.allEjb20Attributes(), new SingleElementIterator(this.unknownPrimaryKeyAttribute));
    }

    public Iterator allMethods() {
        return new CompositeIterator(new TransformationIterator(this.lineage()){

            protected Object transform(Object object) {
                return ((MWClass)object).methods();
            }

            public String toString() {
                return "MWClass.allMethods()";
            }
        });
    }

    public Iterator constructors() {
        return new FilteringIterator(this.methods()){

            protected boolean accept(Object object) {
                return ((MWMethod)object).isConstructor();
            }

            public String toString() {
                return "MWClass.constructors()";
            }
        };
    }

    public Iterator nonConstructors() {
        return this.nonConstructors(this.methods());
    }

    public Iterator allNonConstructors() {
        return this.nonConstructors(this.allMethods());
    }

    private Iterator nonConstructors(Iterator iterator) {
        return new FilteringIterator(iterator){

            protected boolean accept(Object object) {
                return !((MWMethod)object).isConstructor();
            }

            public String toString() {
                return "MWClass.nonConstructors(Iterator)";
            }
        };
    }

    public Iterator instanceMethods() {
        return this.instanceMethods(this.methods());
    }

    public Iterator allInstanceMethods() {
        return this.instanceMethods(this.allMethods());
    }

    private Iterator instanceMethods(Iterator iterator) {
        return new FilteringIterator(iterator){

            protected boolean accept(Object object) {
                return ((MWMethod)object).isInstanceMethod();
            }

            public String toString() {
                return "MWClass.instanceMethods(Iterator)";
            }
        };
    }

    public Iterator staticMethods() {
        return this.staticMethods(this.methods());
    }

    public Iterator allStaticMethods() {
        return this.staticMethods(this.allMethods());
    }

    private Iterator staticMethods(Iterator iterator) {
        return new FilteringIterator(iterator){

            protected boolean accept(Object object) {
                return ((MWMethod)object).isStatic();
            }

            public String toString() {
                return "MWClass.staticMethods(Iterator)";
            }
        };
    }

    public Iterator candidateTopLinkGetMethods() {
        return new FilteringIterator(this.methods()){

            public boolean accept(Object object) {
                return ((MWMethod)object).isCandidateTopLinkGetMethod();
            }

            public String toString() {
                return "MWClass.candidateTopLinkGetMethods()";
            }
        };
    }

    public Iterator candidateTopLinkSetMethods() {
        return new FilteringIterator(this.methods()){

            public boolean accept(Object object) {
                return ((MWMethod)object).isCandidateTopLinkSetMethod();
            }

            public String toString() {
                return "MWClass.candidateTopLinkSetMethods()";
            }
        };
    }

    public Iterator candidateMapContainerPolicyKeyMethods() {
        return new FilteringIterator(this.allMethods()){

            protected boolean accept(Object object) {
                return ((MWMethod)object).isCandidateMapContainerPolicyKeyMethod();
            }

            public String toString() {
                return "MWClass.candidateMapContainerPolicyKeyMethods()";
            }
        };
    }

    public Iterator candidateClassExtractionMethods() {
        return new FilteringIterator(this.allMethods()){

            protected boolean accept(Object object) {
                return ((MWMethod)object).isCandidateClassExtractionMethod();
            }

            public String toString() {
                return "MWClass.candidateClassExtractionMethods()";
            }
        };
    }

    public Iterator candidateCloneMethods() {
        return new FilteringIterator(this.allMethods()){

            protected boolean accept(Object object) {
                return ((MWMethod)object).isCandidateCloneMethod();
            }

            public String toString() {
                return "MWClass.candidateCloneMethods()";
            }
        };
    }

    public Iterator candidateDescriptorEventMethods() {
        return new FilteringIterator(this.allMethods()){

            protected boolean accept(Object object) {
                return ((MWMethod)object).isCandidateDescriptorEventMethod();
            }

            public String toString() {
                return "MWClass.candidateDescriptorEventMethods()";
            }
        };
    }

    public Iterator candidateFactoryMethods() {
        return new FilteringIterator(this.methods()){

            protected boolean accept(Object object) {
                return ((MWMethod)object).isCandidateFactoryMethod();
            }

            public String toString() {
                return "MWClass.candidateFactoryMethods()";
            }
        };
    }

    public Iterator candidateInstantiationMethods() {
        return new FilteringIterator(this.methods()){

            protected boolean accept(Object object) {
                return ((MWMethod)object).isCandidateInstantiationMethod();
            }

            public String toString() {
                return "MWClass.candidateInstantiationMethods()";
            }
        };
    }

    public Iterator candidateFactoryInstantiationMethodsFor(final MWClass mWClass) {
        return new FilteringIterator(this.allMethods()){

            public boolean accept(Object object) {
                return ((MWMethod)object).isCandidateFactoryInstantiationMethodFor(mWClass);
            }

            public String toString() {
                return "MWClass.candidateFactoryInstantiationMethodsFor(MWClass)";
            }
        };
    }

    public Iterator candidateDescriptorAfterLoadMethods() {
        return new FilteringIterator(this.methods()){

            protected boolean accept(Object object) {
                return ((MWMethod)object).isCandidateDescriptorAfterLoadMethod();
            }

            public String toString() {
                return "MWClass.candidateDescriptorAfterLoadMethods()";
            }
        };
    }

    public Iterator candidateAttributeTransformerMethods() {
        return new FilteringIterator(this.allMethods()){

            protected boolean accept(Object object) {
                return ((MWMethod)object).isCandidateAttributeTransformerMethod();
            }

            public String toString() {
                return "MWClass.candidateAttributeTransformerMethods()";
            }
        };
    }

    public Iterator candidateFieldTransformerMethods() {
        return new FilteringIterator(this.allMethods()){

            protected boolean accept(Object object) {
                return ((MWMethod)object).isCandidateFieldTransformerMethod();
            }

            public String toString() {
                return "MWClass.candidateFieldTransformerMethods()";
            }
        };
    }

    Iterator candidateGetMethodsFor(final MWClassAttribute mWClassAttribute) {
        return new FilteringIterator(this.methods()){

            public boolean accept(Object object) {
                return ((MWMethod)object).isCandidateGetMethodFor(mWClassAttribute);
            }

            public String toString() {
                return "MWClass.candidateGetMethodsFor(MWClassAttribute)";
            }
        };
    }

    Iterator candidateSetMethodsFor(final MWClassAttribute mWClassAttribute) {
        return new FilteringIterator(this.methods()){

            public boolean accept(Object object) {
                return ((MWMethod)object).isCandidateSetMethodFor(mWClassAttribute);
            }

            public String toString() {
                return "MWClass.candidateSetMethodsFor(MWClassAttribute)";
            }
        };
    }

    Iterator candidateGetMethodsFor(final MWClass mWClass) {
        return new FilteringIterator(this.methods()){

            public boolean accept(Object object) {
                return ((MWMethod)object).isCandidateGetMethodFor(mWClass);
            }

            public String toString() {
                return "MWClass.candidateGetMethodsFor(MWClass)";
            }
        };
    }

    Iterator candidateSetMethodsFor(final MWClass mWClass) {
        return new FilteringIterator(this.methods()){

            public boolean accept(Object object) {
                return ((MWMethod)object).isCandidateSetMethodFor(mWClass);
            }

            public String toString() {
                return "MWClass.candidateSetMethodsFor(MWClass)";
            }
        };
    }

    Iterator candidateAddMethodsFor(final MWClass mWClass) {
        return new FilteringIterator(this.methods()){

            public boolean accept(Object object) {
                return ((MWMethod)object).isCandidateAddMethodFor(mWClass);
            }

            public String toString() {
                return "MWClass.candidateAddMethodsFor(MWClass)";
            }
        };
    }

    Iterator candidateAddMethodsFor(final MWClass mWClass, final MWClass mWClass2) {
        return new FilteringIterator(this.methods()){

            public boolean accept(Object object) {
                return ((MWMethod)object).isCandidateAddMethodFor(mWClass, mWClass2);
            }

            public String toString() {
                return "MWClass.candidateAddMethodsFor(MWClass, MWClass)";
            }
        };
    }

    Iterator candidateRemoveMethodsFor(final MWClass mWClass) {
        return new FilteringIterator(this.methods()){

            public boolean accept(Object object) {
                return ((MWMethod)object).isCandidateRemoveMethodFor(mWClass);
            }

            public String toString() {
                return "MWClass.candidateRemoveMethodsFor(MWClass)";
            }
        };
    }

    private Iterator ejb20GetMethods() {
        return new FilteringIterator(this.methods()){

            protected boolean accept(Object object) {
                return ((MWMethod)object).isEjb20GetMethod();
            }

            public String toString() {
                return "MWClass.ejb20GetMethods()";
            }
        };
    }

    MWMethod ejb20SetMethodFor(MWMethod mWMethod) {
        Iterator iterator = this.methods();
        while (iterator.hasNext()) {
            MWMethod mWMethod2 = (MWMethod)iterator.next();
            if (!mWMethod2.isEjb20SetMethodFor(mWMethod)) continue;
            return mWMethod2;
        }
        return null;
    }

    MWMethod zeroArgumentMethodNamed(String string) {
        Iterator iterator = this.methods();
        while (iterator.hasNext()) {
            MWMethod mWMethod = (MWMethod)iterator.next();
            if (!mWMethod.hasSignature(string)) continue;
            return mWMethod;
        }
        return null;
    }

    MWMethod oneArgumentMethodNamed(String string, MWClass mWClass) {
        return this.oneArgumentMethodNamed(string, mWClass, 0);
    }

    MWMethod oneArgumentMethodNamed(String string, MWClass mWClass, int n) {
        Iterator iterator = this.methods();
        while (iterator.hasNext()) {
            MWMethod mWMethod = (MWMethod)iterator.next();
            if (!mWMethod.hasSignature(string, mWClass, n)) continue;
            return mWMethod;
        }
        return null;
    }

    MWMethod oneArgumentMethodNamed(String string, MWTypeDeclaration mWTypeDeclaration) {
        return this.oneArgumentMethodNamed(string, mWTypeDeclaration.getType(), mWTypeDeclaration.getDimensionality());
    }

    MWMethod twoArgumentMethodNamed(String string, MWClass mWClass, MWClass mWClass2) {
        Iterator iterator = this.methods();
        while (iterator.hasNext()) {
            MWMethod mWMethod = (MWMethod)iterator.next();
            if (!mWMethod.hasSignature(string, mWClass, 0, mWClass2, 0)) continue;
            return mWMethod;
        }
        return null;
    }

    public MWMethod methodWithSignature(String string) {
        return this.methodWithSignature(this.methods(), string);
    }

    public MWMethod methodWithSignatureFromAll(String string) {
        return this.methodWithSignature(this.allMethods(), string);
    }

    private MWMethod methodWithSignature(Iterator iterator, String string) {
        while (iterator.hasNext()) {
            MWMethod mWMethod = (MWMethod)iterator.next();
            if (!mWMethod.signature().equals(string)) continue;
            return mWMethod;
        }
        return null;
    }

    public MWMethod zeroArgumentConstructor() {
        Iterator iterator = this.methods();
        while (iterator.hasNext()) {
            MWMethod mWMethod = (MWMethod)iterator.next();
            if (!mWMethod.isZeroArgumentConstructor()) continue;
            return mWMethod;
        }
        return null;
    }

    public boolean hasAccessibleZeroArgumentConstructor() {
        if (this.isObject()) {
            return true;
        }
        return this.zeroArgumentConstructor() != null || this.inheritsAccessibleZeroArgumentConstructor();
    }

    private boolean inheritsAccessibleZeroArgumentConstructor() {
        return !this.constructors().hasNext() && this.getSuperclass() != null && this.getSuperclass().hasAccessibleZeroArgumentConstructor();
    }

    public boolean isAssignableFrom(MWClass mWClass) {
        if (this == mWClass) {
            return true;
        }
        if (CollectionTools.contains(mWClass.superclasses(), (Object)this)) {
            return true;
        }
        if (CollectionTools.contains(mWClass.allInterfaces(), (Object)this)) {
            return true;
        }
        return mWClass.isInterface() && this.isObject();
    }

    public boolean mightBeAssignableFrom(MWClass mWClass) {
        return this.isAssignableFrom(mWClass) || !mWClass.isFullyTyped();
    }

    public boolean isAssignableTo(MWClass mWClass) {
        return mWClass.isAssignableFrom(this);
    }

    public boolean mightBeAssignableTo(MWClass mWClass) {
        return mWClass.mightBeAssignableFrom(this);
    }

    public boolean isBooleanPrimitive() {
        return this == this.booleanPrimitiveType();
    }

    public boolean isCharPrimitive() {
        return this == this.charPrimitiveType();
    }

    public boolean isBytePrimitive() {
        return this == this.bytePrimitiveType();
    }

    public boolean isShortPrimitive() {
        return this == this.shortPrimitiveType();
    }

    public boolean isIntPrimitive() {
        return this == this.intPrimitiveType();
    }

    public boolean isLongPrimitive() {
        return this == this.longPrimitiveType();
    }

    public boolean isFloatPrimitive() {
        return this == this.floatPrimitiveType();
    }

    public boolean isDoublePrimitive() {
        return this == this.doublePrimitiveType();
    }

    public boolean isObject() {
        return this == this.objectType();
    }

    public boolean isSerializable() {
        return this == this.serializableType();
    }

    public boolean isCloneable() {
        return this == this.cloneableType();
    }

    public boolean isAssignableToCollection() {
        return this.isAssignableTo(this.collectionType());
    }

    public boolean mightBeAssignableToCollection() {
        return this.mightBeAssignableTo(this.collectionType());
    }

    public boolean isAssignableToList() {
        return this.isAssignableTo(this.listType());
    }

    public boolean mightBeAssignableToList() {
        return this.mightBeAssignableTo(this.listType());
    }

    public boolean isAssignableToMap() {
        return this.isAssignableTo(this.mapType());
    }

    public boolean mightBeAssignableToMap() {
        return this.mightBeAssignableTo(this.mapType());
    }

    public boolean isAssignableToSet() {
        return this.isAssignableTo(this.setType());
    }

    public boolean mightBeAssignableToSet() {
        return this.mightBeAssignableTo(this.setType());
    }

    public boolean mightBeAssignableToSortedSet() {
        return this.mightBeAssignableTo(this.sortedSetType());
    }

    public boolean mightBeAssignableToComparator() {
        return this.mightBeAssignableTo(this.comparatorType());
    }

    public boolean isAssignableToIndirectContainer() {
        return this.isAssignableTo(this.indirectContainerType());
    }

    public boolean mightBeAssignableToIndirectContainer() {
        return this.mightBeAssignableTo(this.indirectContainerType());
    }

    public boolean isAssignableToAttributeTransformer() {
        return this.isAssignableTo(this.attributeTransformerType());
    }

    public boolean mightBeAssignableToAttributeTransformer() {
        return this.mightBeAssignableTo(this.attributeTransformerType());
    }

    public boolean isAssignableToFieldTransformer() {
        return this.isAssignableTo(this.fieldTransformerType());
    }

    public boolean mightBeAssignableToFieldTransformer() {
        return this.mightBeAssignableTo(this.fieldTransformerType());
    }

    public boolean isContainer() {
        return this.isAssignableToCollection() || this.isAssignableToMap();
    }

    public boolean isSubclassOf(MWClass mWClass) {
        return CollectionTools.contains(this.superclasses(), (Object)mWClass);
    }

    public boolean isValueHolder() {
        return this == this.valueHolderType();
    }

    public boolean isVoid() {
        return this.getName().equals(MWClass.voidClassName());
    }

    public boolean isInstantiable() {
        return this.isConcrete() && this.isReferenceType();
    }

    public boolean cannotHaveSuperclass() {
        if (this.isNonReferenceType()) {
            return true;
        }
        if (this.isInterface()) {
            return true;
        }
        return this.getName().equals(Object.class.getName());
    }

    public boolean requiresSuperclass() {
        return !this.cannotHaveSuperclass();
    }

    public Iterator lineage() {
        return new ChainIterator(this){

            protected Object nextLink(Object object) {
                return ((MWClass)object).getSuperclass();
            }

            public String toString() {
                return "MWClass.lineage()";
            }
        };
    }

    public Iterator lineageIncludingInterfaces() {
        return new TreeIterator(this){

            protected Iterator children(Object object) {
                MWClass mWClass = (MWClass)object;
                MWClass mWClass2 = mWClass.getSuperclass();
                return mWClass2 == null ? mWClass.interfaces() : new CompositeIterator(mWClass2, mWClass.interfaces());
            }

            public String toString() {
                return "MWClass.lineageIncludingInterfaces()";
            }
        };
    }

    public Iterator lineageTo(final MWClass mWClass) {
        return new ChainIterator(this){

            protected Object nextLink(Object object) {
                return object == mWClass ? null : ((MWClass)object).getSuperclass();
            }

            public String toString() {
                return "MWClass.lineageTo(MWClass)";
            }
        };
    }

    public boolean lineageContains(MWClass mWClass) {
        return CollectionTools.contains(this.lineage(), (Object)mWClass);
    }

    public Iterator superclasses() {
        MWClass mWClass = this.getSuperclass();
        return mWClass == null ? NullIterator.instance() : mWClass.lineage();
    }

    public Iterator subclasses() {
        return this.getRepository().subclassesOf(this);
    }

    public Iterator allSubclasses() {
        return this.getRepository().allSubclassesOf(this);
    }

    public Iterator hierarchy() {
        return new CompositeIterator(this.lineage(), this.allSubclasses());
    }

    private MWClass booleanPrimitiveType() {
        return this.typeFor(Boolean.TYPE);
    }

    private MWClass charPrimitiveType() {
        return this.typeFor(Character.TYPE);
    }

    private MWClass bytePrimitiveType() {
        return this.typeFor(Byte.TYPE);
    }

    private MWClass shortPrimitiveType() {
        return this.typeFor(Short.TYPE);
    }

    private MWClass intPrimitiveType() {
        return this.typeFor(Integer.TYPE);
    }

    private MWClass longPrimitiveType() {
        return this.typeFor(Long.TYPE);
    }

    private MWClass floatPrimitiveType() {
        return this.typeFor(Float.TYPE);
    }

    private MWClass doublePrimitiveType() {
        return this.typeFor(Double.TYPE);
    }

    private MWClass objectType() {
        return this.typeFor(Object.class);
    }

    private MWClass cloneableType() {
        return this.typeFor(Cloneable.class);
    }

    private MWClass serializableType() {
        return this.typeFor(Serializable.class);
    }

    private MWClass collectionType() {
        return this.typeFor(Collection.class);
    }

    private MWClass listType() {
        return this.typeFor(List.class);
    }

    private MWClass mapType() {
        return this.typeFor(Map.class);
    }

    private MWClass setType() {
        return this.typeFor(Set.class);
    }

    private MWClass sortedSetType() {
        return this.typeFor(SortedSet.class);
    }

    private MWClass comparatorType() {
        return this.typeFor(Comparator.class);
    }

    private MWClass indirectContainerType() {
        return this.typeFor(IndirectContainer.class);
    }

    private MWClass attributeTransformerType() {
        return this.typeFor(AttributeTransformer.class);
    }

    private MWClass fieldTransformerType() {
        return this.typeFor(FieldTransformer.class);
    }

    private MWClass valueHolderType() {
        return this.typeFor(ValueHolderInterface.class);
    }

    public boolean typesContains(MWClass mWClass) {
        return CollectionTools.contains(this.types(), (Object)mWClass);
    }

    public String defaultTableNameWithLength(int n) {
        String string = this.shortName().toUpperCase();
        return string.length() <= n ? string : string.substring(0, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.modifier);
        list.add(this.declaringTypeHandle);
        list.add(this.superclassHandle);
        Collection collection = this.interfaceHandles;
        synchronized (collection) {
            list.addAll(this.interfaceHandles);
        }
        collection = this.typeHandles;
        synchronized (collection) {
            list.addAll(this.typeHandles);
        }
        collection = this.attributes;
        synchronized (collection) {
            list.addAll(this.attributes);
        }
        collection = this.methods;
        synchronized (collection) {
            list.addAll(this.methods);
        }
        collection = this.ejb20Attributes;
        synchronized (collection) {
            list.addAll(this.ejb20Attributes);
        }
        if (this.unknownPrimaryKeyAttribute != null) {
            list.add(this.unknownPrimaryKeyAttribute);
        }
    }

    private MWHandle.NodeReferenceScrubber buildDeclaringTypeScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWClass.this.setDeclaringType(null);
            }

            public String toString() {
                return "MWClass.buildDeclaringTypeScrubber()";
            }
        };
    }

    private MWHandle.NodeReferenceScrubber buildSuperclassScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWClass.this.setSuperclass(null);
            }

            public String toString() {
                return "MWClass.buildSuperclassScrubber()";
            }
        };
    }

    private MWHandle.NodeReferenceScrubber interfaceScrubber() {
        if (this.interfaceScrubber == null) {
            this.interfaceScrubber = this.buildInterfaceScrubber();
        }
        return this.interfaceScrubber;
    }

    private MWHandle.NodeReferenceScrubber buildInterfaceScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWClass.this.removeInterfaceHandle((MWClassHandle)mWHandle);
            }

            public String toString() {
                return "MWClass.buildInterfaceScrubber()";
            }
        };
    }

    private MWHandle.NodeReferenceScrubber typeScrubber() {
        if (this.typeScrubber == null) {
            this.typeScrubber = this.buildTypeScrubber();
        }
        return this.typeScrubber;
    }

    private MWHandle.NodeReferenceScrubber buildTypeScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWClass.this.removeTypeHandle((MWClassHandle)mWHandle);
            }

            public String toString() {
                return "MWClass.buildTypeScrubber()";
            }
        };
    }

    protected void aspectChanged(String string) {
        super.aspectChanged(string);
        this.getRepository().typeChanged(this);
    }

    protected void markParentBranchDirty() {
        if (!this.isCoreType()) {
            super.markParentBranchDirty();
        }
    }

    void configureImpliedStubInterfaces() {
        Iterator iterator = this.interfaces();
        while (iterator.hasNext()) {
            ((MWClass)iterator.next()).configureAsImpliedStubInterface();
        }
    }

    private void configureAsImpliedStubInterface() {
        if (this.isStub()) {
            this.interfaceFlag = true;
            this.superclassHandle.setType(null);
        }
    }

    private synchronized void checkForPartiallyPopulatedCoreType() {
        if (this.partiallyPopulatedCoreType) {
            this.coreTypeRefreshInProgress = true;
            try {
                this.refreshMembers();
            }
            catch (ExternalClassNotFoundException externalClassNotFoundException) {
                throw new RuntimeException(this.name, externalClassNotFoundException);
            }
            finally {
                this.coreTypeRefreshInProgress = false;
            }
        }
    }

    public void refresh() throws ExternalClassNotFoundException {
        this.refresh(DefaultMWClassRefreshPolicy.instance());
    }

    public void refresh(MWClassRefreshPolicy mWClassRefreshPolicy) throws ExternalClassNotFoundException {
        this.getRepository().refreshType(this, mWClassRefreshPolicy);
    }

    void refreshDeclaration(ExternalClass externalClass) throws ExternalClassNotFoundException {
        try {
            if (!this.getName().equals(externalClass.getName())) {
                throw new IllegalArgumentException(this.getName() + " != " + externalClass.getName());
            }
            this.refreshDeclaringType(externalClass.getDeclaringClass());
            this.getModifier().refresh(externalClass.getModifiers());
            this.setInterface(externalClass.isInterface());
            this.refreshSuperclass(externalClass.getSuperclass());
            this.refreshInterfaces(externalClass.getInterfaces());
        }
        catch (Throwable throwable) {
            throw new ExternalClassNotFoundException(this.getName(), throwable);
        }
        this.setLastRefreshTimestamp(new Date());
    }

    void refresh(ExternalClass externalClass) throws ExternalClassNotFoundException {
        this.refresh(externalClass, DefaultMWClassRefreshPolicy.instance());
    }

    void refresh(ExternalClass externalClass, MWClassRefreshPolicy mWClassRefreshPolicy) throws ExternalClassNotFoundException {
        this.refreshDeclaration(externalClass);
        this.refreshMembers(externalClass, mWClassRefreshPolicy);
    }

    private void refreshMembers() throws ExternalClassNotFoundException {
        this.refreshMembers(DefaultMWClassRefreshPolicy.instance());
    }

    private void refreshMembers(MWClassRefreshPolicy mWClassRefreshPolicy) throws ExternalClassNotFoundException {
        this.getRepository().refreshTypeMembers(this, mWClassRefreshPolicy);
    }

    synchronized void refreshMembers(ExternalClass externalClass, MWClassRefreshPolicy mWClassRefreshPolicy) throws ExternalClassNotFoundException {
        this.partiallyPopulatedCoreType = false;
        try {
            this.refreshAttributes(externalClass.getDeclaredFields(), mWClassRefreshPolicy);
            this.refreshConstructors(externalClass.getDeclaredConstructors());
            this.refreshMethods(externalClass.getDeclaredMethods());
            this.refreshTypes(externalClass.getDeclaredClasses());
        }
        catch (Throwable throwable) {
            throw new ExternalClassNotFoundException(this.getName(), throwable);
        }
        mWClassRefreshPolicy.finalizeRefresh(this);
    }

    private void refreshDeclaringType(ExternalClassDescription externalClassDescription) {
        if (externalClassDescription == null) {
            this.setDeclaringType(null);
        } else {
            this.setDeclaringType(this.typeNamed(externalClassDescription.getName()));
        }
    }

    private void refreshSuperclass(ExternalClassDescription externalClassDescription) {
        if (externalClassDescription == null) {
            this.setSuperclass(null);
        } else {
            this.setSuperclass(this.typeNamed(externalClassDescription.getName()));
        }
    }

    private void refreshInterfaces(ExternalClassDescription[] externalClassDescriptionArray) {
        Collection collection = CollectionTools.collection(this.interfaces());
        for (int i = 0; i < externalClassDescriptionArray.length; ++i) {
            MWClass mWClass = this.getRepository().typeNamed(externalClassDescriptionArray[i].getName());
            mWClass.configureAsImpliedStubInterface();
            if (collection.remove(mWClass)) continue;
            this.addInterface(mWClass);
        }
        this.removeInterfaces(collection);
    }

    private void refreshAttributes(ExternalField[] externalFieldArray, MWClassRefreshPolicy mWClassRefreshPolicy) {
        mWClassRefreshPolicy.refreshAttributes(this, externalFieldArray);
    }

    private void refreshConstructors(ExternalConstructor[] externalConstructorArray) {
        Collection collection = CollectionTools.collection(this.constructors());
        for (int i = 0; i < externalConstructorArray.length; ++i) {
            this.refreshConstructor(externalConstructorArray[i], collection);
        }
        this.removeMethods(collection);
    }

    private void refreshConstructor(ExternalConstructor externalConstructor, Collection collection) {
        MWMethod mWMethod = this.constructorWithSameSignatureAs(externalConstructor);
        if (mWMethod == null) {
            this.addMethod(new MWMethod(this, externalConstructor));
        } else {
            mWMethod.refresh(externalConstructor);
            collection.remove(mWMethod);
        }
    }

    private MWMethod constructorWithSameSignatureAs(ExternalConstructor externalConstructor) {
        Iterator iterator = this.constructors();
        while (iterator.hasNext()) {
            MWMethod mWMethod = (MWMethod)iterator.next();
            if (!mWMethod.hasSameSignatureAs(externalConstructor)) continue;
            return mWMethod;
        }
        return null;
    }

    private void refreshMethods(ExternalMethod[] externalMethodArray) {
        Collection collection = CollectionTools.collection(this.nonConstructors());
        for (int i = 0; i < externalMethodArray.length; ++i) {
            this.refreshMethod(externalMethodArray[i], collection);
        }
        this.removeMethods(collection);
    }

    private void refreshMethod(ExternalMethod externalMethod, Collection collection) {
        if (externalMethod.isSynthetic()) {
            return;
        }
        MWMethod mWMethod = this.methodWithSameSignatureAs(externalMethod);
        if (mWMethod == null) {
            this.addMethod(new MWMethod(this, externalMethod));
        } else {
            mWMethod.refresh(externalMethod);
            collection.remove(mWMethod);
        }
    }

    private MWMethod methodWithSameSignatureAs(ExternalMethod externalMethod) {
        Iterator iterator = this.nonConstructors();
        while (iterator.hasNext()) {
            MWMethod mWMethod = (MWMethod)iterator.next();
            if (!mWMethod.hasSameSignatureAs(externalMethod)) continue;
            return mWMethod;
        }
        return null;
    }

    private void refreshTypes(ExternalClassDescription[] externalClassDescriptionArray) {
        this.clearTypes();
        for (int i = 0; i < externalClassDescriptionArray.length; ++i) {
            MWClass mWClass = this.typeNamed(externalClassDescriptionArray[i].getName());
            this.addType(mWClass);
        }
    }

    public void refreshEjb20Attributes() {
        Collection collection = CollectionTools.collection(this.ejb20Attributes());
        Iterator iterator = this.ejb20GetMethods();
        while (iterator.hasNext()) {
            MWMethod mWMethod = (MWMethod)iterator.next();
            MWMethod mWMethod2 = this.ejb20SetMethodFor(mWMethod);
            if (mWMethod2 == null) continue;
            this.refreshEjb20Attribute(mWMethod, mWMethod2, collection);
        }
        this.removeEjb20Attributes(collection);
        if (this.getSuperclass() != null) {
            this.getSuperclass().refreshEjb20Attributes();
        }
    }

    private void refreshEjb20Attribute(MWMethod mWMethod, MWMethod mWMethod2, Collection collection) {
        String string = StringTools.uncapitalize(mWMethod.getName().substring(3));
        MWClass mWClass = mWMethod.getReturnType();
        int n = mWMethod.getReturnTypeDimensionality();
        MWClassAttribute mWClassAttribute = this.ejb20AttributeNamed(string);
        if (mWClassAttribute == null) {
            mWClassAttribute = this.addEjb20AttributeInternal(string, mWClass, n);
        } else {
            mWClassAttribute.setType(mWClass);
            mWClassAttribute.setDimensionality(n);
            collection.remove(mWClassAttribute);
        }
        mWClassAttribute.setGetMethod(mWMethod);
        mWClassAttribute.setSetMethod(mWMethod2);
    }

    public MWMethod addZeroArgumentConstructor() {
        MWMethod mWMethod = this.zeroArgumentConstructor();
        if (mWMethod != null) {
            return mWMethod;
        }
        return this.addMethod(this.buildZeroArgumentConstructor());
    }

    void superclassesChanged() {
        this.fireCollectionChanged(SUPERCLASSES_COLLECTION);
    }

    void changeFromEjb20(MWClassAttribute mWClassAttribute) {
        if (this.ejb20Attributes.remove(mWClassAttribute)) {
            this.fireItemRemoved(EJB20_ATTRIBUTES_COLLECTION, mWClassAttribute);
            this.attributes.add(mWClassAttribute);
            this.fireItemAdded(ATTRIBUTES_COLLECTION, mWClassAttribute);
        }
    }

    void changeToEjb20(MWClassAttribute mWClassAttribute) {
        if (this.attributes.remove(mWClassAttribute)) {
            this.fireItemRemoved(ATTRIBUTES_COLLECTION, mWClassAttribute);
            this.ejb20Attributes.add(mWClassAttribute);
            this.fireItemAdded(EJB20_ATTRIBUTES_COLLECTION, mWClassAttribute);
        }
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
    }

    public void addDescriptorProblemsTo(List list) {
        this.checkSuperclass(list);
        this.checkInterfaces(list);
        this.checkAttributes(list);
    }

    private void checkSuperclass(List list) {
        MWClass mWClass = this.getSuperclass();
        if (mWClass != null && mWClass.isInterface()) {
            list.add(this.buildProblem("0133", this.displayStringWithPackage()));
        }
    }

    private void checkInterfaces(List list) {
        Iterator iterator = this.interfaces();
        while (iterator.hasNext()) {
            MWClass mWClass = (MWClass)iterator.next();
            if (mWClass.isInterface()) continue;
            list.add(this.buildProblem("0132", mWClass.displayStringWithPackage()));
        }
    }

    private void checkAttributes(List list) {
        Iterator iterator = this.attributes();
        while (iterator.hasNext()) {
            ((MWClassAttribute)iterator.next()).addDescriptorProblemsTo(list);
        }
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.getName());
    }

    public String displayString() {
        return this.shortName();
    }

    public String displayStringWithPackage() {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(this.shortName());
        if (this.isReferenceType()) {
            stringBuffer.append(" (");
            stringBuffer.append(this.packageDisplayName());
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    void printDefaultReturnValueOn(StringBuffer stringBuffer) {
        if (this.isVoid()) {
            throw new IllegalStateException(this.toString());
        }
        if (this.isPrimitive()) {
            if (this.isBooleanPrimitive()) {
                stringBuffer.append("false");
            } else {
                stringBuffer.append('0');
            }
        } else {
            stringBuffer.append("null");
        }
    }

    public ClassDefinition classDefinition(MWClassCodeGenPolicy mWClassCodeGenPolicy) {
        if (this.isCoreType()) {
            return null;
        }
        ClassDefinition classDefinition = new ClassDefinition();
        classDefinition.setComment(mWClassCodeGenPolicy.classComment(this));
        classDefinition.setPackageName(this.packageName());
        classDefinition.setAccessLevel(this.getModifier().accessLevel());
        if (this.isInterface()) {
            classDefinition.setType(2);
        } else {
            classDefinition.setType(1);
        }
        classDefinition.setName(this.shortName());
        MWClass mWClass = this.getSuperclass();
        if (mWClass != null && mWClass != this.objectType()) {
            classDefinition.setSuperClass(mWClass.getName());
        }
        Iterator iterator = this.interfaces();
        while (iterator.hasNext()) {
            classDefinition.addInterface(((MWClass)iterator.next()).getName());
        }
        iterator = this.attributes();
        while (iterator.hasNext()) {
            classDefinition.addAttribute((AttributeDefinition)((MWClassAttribute)iterator.next()).attributeDefinition());
        }
        iterator = this.methods();
        while (iterator.hasNext()) {
            MWMethod mWMethod = (MWMethod)iterator.next();
            classDefinition.addMethod((MethodDefinition)mWMethod.methodDefinition(mWClassCodeGenPolicy.getMethodCodeGenPolicy(mWMethod)));
        }
        classDefinition.calculateImports();
        return classDefinition;
    }

    MWClass defaultContainerImplementationType() {
        if (this.isConcrete() && this.isReferenceType() && this.isContainer()) {
            return this;
        }
        MWClass mWClass = null;
        if (this.isAssignableToMap()) {
            mWClass = this.typeFor(HashMap.class);
        } else if (this.isAssignableToSet()) {
            mWClass = this.typeFor(HashSet.class);
        } else if (this.isAssignableToCollection()) {
            mWClass = this.typeFor(ArrayList.class);
        }
        if (mWClass == null || this.isAssignableFrom(mWClass)) {
            return mWClass;
        }
        return null;
    }

    private MWClassAttribute buildAttribute(String string, MWClass mWClass, int n) {
        return new MWClassAttribute(this, string, mWClass, n);
    }

    private MWClassAttribute buildEjb20Attribute(String string, MWClass mWClass, int n) {
        return this.buildAttribute(string, mWClass, n);
    }

    private MWMethod buildMethod(String string) {
        return new MWMethod(this, string);
    }

    private MWMethod buildMethod(String string, MWClass mWClass) {
        return new MWMethod(this, string, mWClass);
    }

    private MWMethod buildMethod(String string, MWClass mWClass, int n) {
        return new MWMethod(this, string, mWClass, n);
    }

    private MWMethod buildZeroArgumentConstructor() {
        return MWMethod.buildZeroArgumentConstructor(this);
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWClass.class);
        xMLDescriptor.setDefaultRootElement("class");
        xMLDescriptor.addDirectMapping(NAME_PROPERTY, "name/text()");
        XMLDirectMapping xMLDirectMapping = (XMLDirectMapping)xMLDescriptor.addDirectMapping("interfaceFlag", "is-interface/text()");
        xMLDirectMapping.setNullValue((Object)Boolean.FALSE);
        XMLDirectMapping xMLDirectMapping2 = (XMLDirectMapping)xMLDescriptor.addDirectMapping("modifier", "getModifierForTopLink", "setModifierForTopLink", "modifier/text()");
        xMLDirectMapping2.setNullValue((Object)new Integer(0));
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("declaringTypeHandle");
        xMLCompositeObjectMapping.setSetMethodName("setDeclaringTypeHandleForTopLink");
        xMLCompositeObjectMapping.setGetMethodName("getDeclaringTypeHandleForTopLink");
        xMLCompositeObjectMapping.setReferenceClass(MWClassHandle.class);
        xMLCompositeObjectMapping.setXPath("declaring-type-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        XMLCompositeObjectMapping xMLCompositeObjectMapping2 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping2.setAttributeName("superclassHandle");
        xMLCompositeObjectMapping2.setReferenceClass(MWClassHandle.class);
        xMLCompositeObjectMapping2.setSetMethodName("setSuperclassHandleForTopLink");
        xMLCompositeObjectMapping2.setGetMethodName("getSuperclassHandleForTopLink");
        xMLCompositeObjectMapping2.setXPath("superclass-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping2);
        xMLDescriptor.addDirectMapping(LAST_REFRESH_TIMESTAMP_PROPERTY, "last-refresh-timestamp/text()");
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping.setAttributeName("interfaceHandles");
        xMLCompositeCollectionMapping.setSetMethodName("setInterfaceHandlesForTopLink");
        xMLCompositeCollectionMapping.setGetMethodName("getInterfaceHandlesForTopLink");
        xMLCompositeCollectionMapping.setReferenceClass(MWClassHandle.class);
        xMLCompositeCollectionMapping.setXPath("interface-handles/class-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping2 = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping2.setAttributeName(ATTRIBUTES_COLLECTION);
        xMLCompositeCollectionMapping2.setSetMethodName("setAttributesForTopLink");
        xMLCompositeCollectionMapping2.setGetMethodName("getAttributesForTopLink");
        xMLCompositeCollectionMapping2.setReferenceClass(MWClassAttribute.class);
        xMLCompositeCollectionMapping2.setXPath("attributes/class-attribute");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping2);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping3 = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping3.setAttributeName(EJB20_ATTRIBUTES_COLLECTION);
        xMLCompositeCollectionMapping3.setSetMethodName("setEjb20AttributesForTopLink");
        xMLCompositeCollectionMapping3.setGetMethodName("getEjb20AttributesForTopLink");
        xMLCompositeCollectionMapping3.setReferenceClass(MWClassAttribute.class);
        xMLCompositeCollectionMapping3.setXPath("ejb-20-attributes/class-attribute");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping3);
        XMLCompositeObjectMapping xMLCompositeObjectMapping3 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping3.setAttributeName("unknownPrimaryKeyAttribute");
        xMLCompositeObjectMapping3.setReferenceClass(MWClassAttribute.class);
        xMLCompositeObjectMapping3.setXPath("unknown-primary-key-attribute");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping3);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping4 = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping4.setAttributeName(METHODS_COLLECTION);
        xMLCompositeCollectionMapping4.setSetMethodName("setMethodsForTopLink");
        xMLCompositeCollectionMapping4.setGetMethodName("getMethodsForTopLink");
        xMLCompositeCollectionMapping4.setReferenceClass(MWMethod.class);
        xMLCompositeCollectionMapping4.setXPath("methods/method");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping4);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping5 = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping5.setAttributeName("typeHandles");
        xMLCompositeCollectionMapping5.setSetMethodName("setTypeHandlesForTopLink");
        xMLCompositeCollectionMapping5.setGetMethodName("getTypeHandlesForTopLink");
        xMLCompositeCollectionMapping5.setReferenceClass(MWClassHandle.class);
        xMLCompositeCollectionMapping5.setXPath("type-handles/class-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping5);
        XMLDirectMapping xMLDirectMapping3 = (XMLDirectMapping)xMLDescriptor.addDirectMapping("coreType", "core-type/text()");
        xMLDirectMapping3.setNullValue((Object)Boolean.FALSE);
        return xMLDescriptor;
    }

    private int getModifierForTopLink() {
        return this.modifier.getCode();
    }

    private void setModifierForTopLink(int n) {
        this.modifier.setCodeForTopLink(n);
    }

    private MWClassHandle getDeclaringTypeHandleForTopLink() {
        return this.declaringTypeHandle.getType() == null ? null : this.declaringTypeHandle;
    }

    private void setDeclaringTypeHandleForTopLink(MWClassHandle mWClassHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildDeclaringTypeScrubber();
        this.declaringTypeHandle = mWClassHandle == null ? new MWClassHandle(this, nodeReferenceScrubber) : mWClassHandle.setScrubber(nodeReferenceScrubber);
    }

    private MWClassHandle getSuperclassHandleForTopLink() {
        return this.superclassHandle.getType() == null ? null : this.superclassHandle;
    }

    private void setSuperclassHandleForTopLink(MWClassHandle mWClassHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildSuperclassScrubber();
        this.superclassHandle = mWClassHandle == null ? new MWClassHandle(this, nodeReferenceScrubber) : mWClassHandle.setScrubber(nodeReferenceScrubber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getInterfaceHandlesForTopLink() {
        Collection collection = this.interfaceHandles;
        synchronized (collection) {
            return new TreeSet(this.interfaceHandles);
        }
    }

    private void setInterfaceHandlesForTopLink(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ((MWClassHandle)iterator.next()).setScrubber(this.interfaceScrubber());
        }
        this.interfaceHandles = collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getAttributesForTopLink() {
        Collection collection = this.attributes;
        synchronized (collection) {
            return new TreeSet(this.attributes);
        }
    }

    private void setAttributesForTopLink(Collection collection) {
        this.attributes = collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getEjb20AttributesForTopLink() {
        Collection collection = this.ejb20Attributes;
        synchronized (collection) {
            return new TreeSet(this.ejb20Attributes);
        }
    }

    private void setEjb20AttributesForTopLink(Collection collection) {
        this.ejb20Attributes = collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getMethodsForTopLink() {
        Collection collection = this.methods;
        synchronized (collection) {
            return new TreeSet(this.methods);
        }
    }

    private void setMethodsForTopLink(Collection collection) {
        this.methods = collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getTypeHandlesForTopLink() {
        Collection collection = this.typeHandles;
        synchronized (collection) {
            return new TreeSet(this.typeHandles);
        }
    }

    private void setTypeHandlesForTopLink(Collection collection) {
        for (MWClassHandle mWClassHandle : collection) {
            mWClassHandle.setScrubber(this.typeScrubber());
        }
        this.typeHandles = collection;
    }

    public void postProjectBuild() {
        super.postProjectBuild();
        this.primitive = this.defaultPrimitiveFlag();
    }

    public static XMLDescriptor legacy60BuildDescriptor() {
        XMLDescriptor xMLDescriptor = MWModel.legacy60BuildStandardDescriptor();
        xMLDescriptor.setJavaClass(MWClass.class);
        xMLDescriptor.setDefaultRootElement("class");
        xMLDescriptor.addDirectMapping(NAME_PROPERTY, "legacyGetNameForToplink", "legacySetNameForToplink", "name/text()");
        XMLDirectMapping xMLDirectMapping = (XMLDirectMapping)xMLDescriptor.addDirectMapping("interfaceFlag", "is-interface/text()");
        xMLDirectMapping.setNullValue((Object)Boolean.FALSE);
        XMLDirectMapping xMLDirectMapping2 = (XMLDirectMapping)xMLDescriptor.addDirectMapping("modifier", "getModifierForTopLink", "setModifierForTopLink", "modifier/text()");
        xMLDirectMapping2.setNullValue((Object)new Integer(0));
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("declaringTypeHandle");
        xMLCompositeObjectMapping.setSetMethodName("setDeclaringTypeHandleForTopLink");
        xMLCompositeObjectMapping.setGetMethodName("getDeclaringTypeHandleForTopLink");
        xMLCompositeObjectMapping.setReferenceClass(MWClassHandle.class);
        xMLCompositeObjectMapping.setXPath("declaring-type-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        XMLCompositeObjectMapping xMLCompositeObjectMapping2 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping2.setAttributeName("superclassHandle");
        xMLCompositeObjectMapping2.setReferenceClass(MWClassHandle.class);
        xMLCompositeObjectMapping2.setSetMethodName("setSuperclassHandleForTopLink");
        xMLCompositeObjectMapping2.setGetMethodName("getSuperclassHandleForTopLink");
        xMLCompositeObjectMapping2.setXPath("superclass-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping2);
        xMLDescriptor.addDirectMapping(LAST_REFRESH_TIMESTAMP_PROPERTY, "last-refresh-timestamp/text()");
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping.setAttributeName("interfaceHandles");
        xMLCompositeCollectionMapping.setSetMethodName("setInterfaceHandlesForTopLink");
        xMLCompositeCollectionMapping.setGetMethodName("getInterfaceHandlesForTopLink");
        xMLCompositeCollectionMapping.setReferenceClass(MWClassHandle.class);
        xMLCompositeCollectionMapping.setXPath("interface-handles/class-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping2 = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping2.setAttributeName(ATTRIBUTES_COLLECTION);
        xMLCompositeCollectionMapping2.setSetMethodName("setAttributesForTopLink");
        xMLCompositeCollectionMapping2.setGetMethodName("getAttributesForTopLink");
        xMLCompositeCollectionMapping2.setReferenceClass(MWClassAttribute.class);
        xMLCompositeCollectionMapping2.setXPath("attributes/class-attribute");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping2);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping3 = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping3.setAttributeName(EJB20_ATTRIBUTES_COLLECTION);
        xMLCompositeCollectionMapping3.setSetMethodName("setEjb20AttributesForTopLink");
        xMLCompositeCollectionMapping3.setGetMethodName("getEjb20AttributesForTopLink");
        xMLCompositeCollectionMapping3.setReferenceClass(MWClassAttribute.class);
        xMLCompositeCollectionMapping3.setXPath("ejb-20-attributes/class-attribute");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping3);
        XMLCompositeObjectMapping xMLCompositeObjectMapping3 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping3.setAttributeName("unknownPrimaryKeyAttribute");
        xMLCompositeObjectMapping3.setReferenceClass(MWClassAttribute.class);
        xMLCompositeObjectMapping3.setXPath("unknown-primary-key-attribute");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping3);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping4 = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping4.setAttributeName(METHODS_COLLECTION);
        xMLCompositeCollectionMapping4.setSetMethodName("setMethodsForTopLink");
        xMLCompositeCollectionMapping4.setGetMethodName("getMethodsForTopLink");
        xMLCompositeCollectionMapping4.setReferenceClass(MWMethod.class);
        xMLCompositeCollectionMapping4.setXPath("methods/method");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping4);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping5 = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping5.setAttributeName("typeHandles");
        xMLCompositeCollectionMapping5.setSetMethodName("setTypeHandlesForTopLink");
        xMLCompositeCollectionMapping5.setGetMethodName("getTypeHandlesForTopLink");
        xMLCompositeCollectionMapping5.setReferenceClass(MWClassHandle.class);
        xMLCompositeCollectionMapping5.setXPath("type-handles/class-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping5);
        XMLDirectMapping xMLDirectMapping3 = (XMLDirectMapping)xMLDescriptor.addDirectMapping("coreType", "core-type/text()");
        xMLDirectMapping3.setNullValue((Object)Boolean.FALSE);
        return xMLDescriptor;
    }

    private String legacyGetNameForToplink() {
        return this.name;
    }

    private void legacySetNameForToplink(String string) {
        this.name = MWModel.legacyReplaceToplinkDeprecatedClassReferences(string);
    }

    public static String packageDisplayNameForClassNamed(String string) {
        if (MWClass.nonReferenceClassNamesContains(string)) {
            return "";
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return "(default package)";
        }
        return string.substring(0, n);
    }

    public static String packageDisplayNameFor(Class clazz) {
        return MWClass.packageDisplayNameForClassNamed(clazz.getName());
    }

    private static PrimitiveWrapperPair[] buildPrimitiveWrapperPairs() {
        PrimitiveWrapperPair[] primitiveWrapperPairArray = new PrimitiveWrapperPair[]{new PrimitiveWrapperPair(Boolean.TYPE, Boolean.class), new PrimitiveWrapperPair(Character.TYPE, Character.class), new PrimitiveWrapperPair(Byte.TYPE, Byte.class), new PrimitiveWrapperPair(Short.TYPE, Short.class), new PrimitiveWrapperPair(Integer.TYPE, Integer.class), new PrimitiveWrapperPair(Long.TYPE, Long.class), new PrimitiveWrapperPair(Float.TYPE, Float.class), new PrimitiveWrapperPair(Double.TYPE, Double.class)};
        return primitiveWrapperPairArray;
    }

    private static synchronized PrimitiveWrapperPair[] getPrimitiveWrapperPairs() {
        if (primitiveWrapperPairs == null) {
            primitiveWrapperPairs = MWClass.buildPrimitiveWrapperPairs();
        }
        return primitiveWrapperPairs;
    }

    private static Iterator primitiveWrapperPairs() {
        return CollectionTools.iterator(MWClass.getPrimitiveWrapperPairs());
    }

    private static Iterator primitiveClasses(Iterator iterator) {
        return new TransformationIterator(iterator){

            protected Object transform(Object object) {
                return ((PrimitiveWrapperPair)object).getPrimitiveClass();
            }

            public String toString() {
                return "MWClass.primitiveClasses(Iterator)";
            }
        };
    }

    private static Iterator primitiveClassNames(Iterator iterator) {
        return new TransformationIterator(iterator){

            protected Object transform(Object object) {
                return ((PrimitiveWrapperPair)object).primitiveClassName();
            }

            public String toString() {
                return "MWClass.primitiveClassNames(Iterator)";
            }
        };
    }

    private static Iterator wrapperClasses(Iterator iterator) {
        return new TransformationIterator(iterator){

            protected Object transform(Object object) {
                return ((PrimitiveWrapperPair)object).getWrapperClass();
            }

            public String toString() {
                return "MWClass.wrapperClasses(Iterator)";
            }
        };
    }

    public static Class primitiveClassNamed(String string) {
        PrimitiveWrapperPair[] primitiveWrapperPairArray = MWClass.getPrimitiveWrapperPairs();
        int n = primitiveWrapperPairArray.length;
        for (int i = 0; i < n; ++i) {
            if (!primitiveWrapperPairArray[i].primitiveClassName().equals(string)) continue;
            return primitiveWrapperPairArray[i].getPrimitiveClass();
        }
        return null;
    }

    public static Iterator primitiveClasses() {
        return MWClass.primitiveClasses(MWClass.primitiveWrapperPairs());
    }

    public static Iterator primitiveWrapperClasses() {
        return MWClass.wrapperClasses(MWClass.primitiveWrapperPairs());
    }

    public static Iterator primitiveClassNames() {
        return MWClass.primitiveClassNames(MWClass.primitiveWrapperPairs());
    }

    private static synchronized PrimitiveWrapperPair getVoidPrimitiveWrapperPair() {
        if (voidPrimitiveWrapperPair == null) {
            voidPrimitiveWrapperPair = new PrimitiveWrapperPair(Void.TYPE, Void.class);
        }
        return voidPrimitiveWrapperPair;
    }

    public static Class voidClass() {
        return MWClass.getVoidPrimitiveWrapperPair().getPrimitiveClass();
    }

    public static Class voidWrapperClass() {
        return MWClass.getVoidPrimitiveWrapperPair().getWrapperClass();
    }

    public static String voidClassName() {
        return MWClass.getVoidPrimitiveWrapperPair().primitiveClassName();
    }

    private static Iterator nonReferencePrimitiveWrapperPairs() {
        return new CompositeIterator(CollectionTools.singletonIterator(MWClass.getVoidPrimitiveWrapperPair()), MWClass.primitiveWrapperPairs());
    }

    public static Iterator nonReferenceClasses() {
        return MWClass.primitiveClasses(MWClass.nonReferencePrimitiveWrapperPairs());
    }

    public static Iterator nonReferenceClassNames() {
        return MWClass.primitiveClassNames(MWClass.nonReferencePrimitiveWrapperPairs());
    }

    public static boolean nonReferenceClassNamesContains(String string) {
        return CollectionTools.contains(MWClass.nonReferenceClassNames(), (Object)string);
    }

    public static Iterator nonReferenceWrapperClasses() {
        return MWClass.wrapperClasses(MWClass.nonReferencePrimitiveWrapperPairs());
    }

    static {
        LEGACY_50_STUB_NULL_VALUE = Boolean.FALSE;
    }

    private static class PrimitiveWrapperPair {
        private Class primitiveClass;
        private Class wrapperClass;

        PrimitiveWrapperPair(Class clazz, Class clazz2) {
            this.primitiveClass = clazz;
            this.wrapperClass = clazz2;
        }

        Class getPrimitiveClass() {
            return this.primitiveClass;
        }

        Class getWrapperClass() {
            return this.wrapperClass;
        }

        String primitiveClassName() {
            return this.getPrimitiveClass().getName();
        }

        String wrapperClassName() {
            return this.getWrapperClass().getName();
        }
    }
}

