/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.meta;

import java.io.PrintWriter;
import java.lang.reflect.Modifier;
import org.eclipse.persistence.internal.codegen.AccessLevel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWModifiable;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWModifier
extends MWModel {
    private volatile int code;
    public static final String CODE_PROPERTY = "code";
    public static final String ACCESS_LEVEL_PROPERTY = "accessLevel";
    public static final String PUBLIC = "public";
    public static final String PACKAGE = "package";
    public static final String PROTECTED = "protected";
    public static final String PRIVATE = "private";

    private MWModifier() {
    }

    MWModifier(MWModifiable mWModifiable) {
        super((MWModel)((Object)mWModifiable));
    }

    MWModifier(MWModifiable mWModifiable, int n) {
        this(mWModifiable);
        this.setCode(n);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.code = MWModifier.defaultCode();
    }

    void initializeFrom(MWModifier mWModifier) {
        this.setCode(mWModifier.getCode());
    }

    void clear() {
        this.setCode(MWModifier.defaultCode());
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int n) {
        int n2 = this.code;
        this.setCodeInternal(n);
        this.firePropertyChanged(CODE_PROPERTY, n2, this.code);
        if (n2 != this.code) {
            this.modifiableParent().modifierChanged(n2, this.code);
        }
    }

    private void setCodeInternal(int n) {
        this.code = n &= 0xFFFFFDFF;
    }

    void setCodeForTopLink(int n) {
        this.setCodeInternal(n);
    }

    private void setBit(boolean bl, int n) {
        int n2 = this.code;
        n2 = bl ? (n2 |= n) : (n2 &= ~n);
        this.setCode(n2);
    }

    public boolean supportsAbstract() {
        return this.modifiableParent().supportsAbstract();
    }

    public boolean canBeSetAbstract() {
        return this.modifiableParent().canBeSetAbstract();
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.code);
    }

    public void setAbstract(boolean bl) {
        this.setBit(bl, 1024);
    }

    public boolean canBeSetFinal() {
        return this.modifiableParent().canBeSetFinal();
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.code);
    }

    public void setFinal(boolean bl) {
        this.setBit(bl, 16);
    }

    private boolean supportsInterface() {
        return this.modifiableParent().supportsInterface();
    }

    private boolean canBeSetInterface() {
        return this.modifiableParent().canBeSetInterface();
    }

    private boolean isInterface() {
        return Modifier.isInterface(this.code);
    }

    private void setInterface(boolean bl) {
        this.setBit(bl, 512);
    }

    public boolean supportsNative() {
        return this.modifiableParent().supportsNative();
    }

    public boolean canBeSetNative() {
        return this.modifiableParent().canBeSetNative();
    }

    public boolean isNative() {
        return Modifier.isNative(this.code);
    }

    public void setNative(boolean bl) {
        this.setBit(bl, 256);
    }

    public String getAccessLevel() {
        if (this.isPublic()) {
            return PUBLIC;
        }
        if (this.isProtected()) {
            return PROTECTED;
        }
        if (this.isPackage()) {
            return PACKAGE;
        }
        if (this.isPrivate()) {
            return PRIVATE;
        }
        throw new IllegalStateException(this.toString());
    }

    public void setAccessLevel(String string) {
        String string2 = this.getAccessLevel();
        if (string == PUBLIC) {
            this.setPublic(true);
        } else if (string == PROTECTED) {
            this.setProtected(true);
        } else if (string == PRIVATE) {
            this.setPrivate(true);
        } else if (string == PACKAGE) {
            this.setPackage(true);
        } else {
            throw new IllegalArgumentException("Allowable values: MWModifier.PUBLIC, MWModifier.PROTECTED, MWModifier.PRIVATE, MWModifier.PACKAGE");
        }
        this.firePropertyChanged(ACCESS_LEVEL_PROPERTY, string2, string);
        if (this.attributeValueHasChanged(string2, string)) {
            this.modifiableParent().accessLevelChanged(string2, string);
        }
    }

    public boolean canBeSetPackage() {
        return this.modifiableParent().canBeSetPackage();
    }

    public boolean isPackage() {
        return !this.isPublic() && !this.isPrivate() && !this.isProtected();
    }

    public void setPackage(boolean bl) {
        int n = this.code;
        n = bl ? (n &= 0xFFFFFFFE) : (n |= 1);
        n &= 0xFFFFFFFD;
        this.setCode(n &= 0xFFFFFFFB);
    }

    public boolean canBeSetPrivate() {
        return this.modifiableParent().canBeSetPrivate();
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.code);
    }

    public void setPrivate(boolean bl) {
        int n = this.code;
        if (bl) {
            n |= 2;
            n &= 0xFFFFFFFB;
            n &= 0xFFFFFFFE;
        } else {
            n &= 0xFFFFFFFD;
        }
        this.setCode(n);
    }

    public boolean canBeSetProtected() {
        return this.modifiableParent().canBeSetProtected();
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.code);
    }

    public void setProtected(boolean bl) {
        int n = this.code;
        if (bl) {
            n |= 4;
            n &= 0xFFFFFFFD;
            n &= 0xFFFFFFFE;
        } else {
            n &= 0xFFFFFFFB;
        }
        this.setCode(n);
    }

    public boolean canBeSetPublic() {
        return this.modifiableParent().canBeSetPublic();
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.code);
    }

    public void setPublic(boolean bl) {
        int n = this.code;
        if (bl) {
            n |= 1;
            n &= 0xFFFFFFFD;
            n &= 0xFFFFFFFB;
        } else {
            n &= 0xFFFFFFFE;
        }
        this.setCode(n);
    }

    public boolean canBeSetStatic() {
        return this.modifiableParent().canBeSetStatic();
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.code);
    }

    public void setStatic(boolean bl) {
        this.setBit(bl, 8);
    }

    public boolean supportsStrict() {
        return this.modifiableParent().supportsStrict();
    }

    public boolean canBeSetStrict() {
        return this.modifiableParent().canBeSetStrict();
    }

    public boolean isStrict() {
        return Modifier.isStrict(this.code);
    }

    public void setStrict(boolean bl) {
        this.setBit(bl, 2048);
    }

    public boolean supportsSynchronized() {
        return this.modifiableParent().supportsSynchronized();
    }

    public boolean canBeSetSynchronized() {
        return this.modifiableParent().canBeSetSynchronized();
    }

    public boolean isSynchronized() {
        return Modifier.isSynchronized(this.code);
    }

    public void setSynchronized(boolean bl) {
        this.setBit(bl, 32);
    }

    public boolean supportsTransient() {
        return this.modifiableParent().supportsTransient();
    }

    public boolean canBeSetTransient() {
        return this.modifiableParent().canBeSetTransient();
    }

    public boolean isTransient() {
        return Modifier.isTransient(this.code);
    }

    public void setTransient(boolean bl) {
        this.setBit(bl, 128);
    }

    public boolean supportsVolatile() {
        return this.modifiableParent().supportsVolatile();
    }

    public boolean canBeSetVolatile() {
        return this.modifiableParent().canBeSetVolatile();
    }

    public boolean isVolatile() {
        return Modifier.isVolatile(this.code);
    }

    public void setVolatile(boolean bl) {
        this.setBit(bl, 64);
    }

    private MWModifiable modifiableParent() {
        return (MWModifiable)((Object)this.getMWParent());
    }

    public static int defaultCode() {
        return 1;
    }

    public boolean isDefaultValue() {
        return this.code == MWModifier.defaultCode();
    }

    AccessLevel accessLevel() {
        AccessLevel accessLevel = new AccessLevel();
        if (this.isPublic()) {
            accessLevel.setLevel(AccessLevel.PUBLIC);
        } else if (this.isProtected()) {
            accessLevel.setLevel(AccessLevel.PROTECTED);
        } else if (this.isPackage()) {
            accessLevel.setLevel(AccessLevel.PACKAGE);
        } else {
            accessLevel.setLevel(AccessLevel.PRIVATE);
        }
        accessLevel.setIsAbstract(this.isAbstract());
        accessLevel.setIsFinal(this.isFinal());
        accessLevel.setIsNative(this.isNative());
        accessLevel.setIsStatic(this.isStatic());
        accessLevel.setIsSynchronized(this.isSynchronized());
        accessLevel.setIsTransient(this.isTransient());
        accessLevel.setIsVolatile(this.isVolatile());
        return accessLevel;
    }

    void refresh(int n) {
        this.setCode(n);
    }

    void allowedModifiersChanged() {
        this.fireStateChanged();
    }

    private void checkCode() {
        if (this.isPublic() && !this.canBeSetPublic() || this.isProtected() && !this.canBeSetProtected() || this.isPackage() && !this.canBeSetPackage() || this.isPrivate() && !this.canBeSetPrivate() || this.isInterface() && !this.canBeSetInterface() || this.isFinal() && !this.canBeSetFinal() || this.isStatic() && !this.canBeSetStatic() || this.isAbstract() && !this.canBeSetAbstract() || this.isNative() && !this.canBeSetNative() || this.isStrict() && !this.canBeSetStrict() || this.isSynchronized() && !this.canBeSetSynchronized() || this.isTransient() && !this.canBeSetTransient() || this.isVolatile() && !this.canBeSetVolatile()) {
            throw new IllegalStateException(this.toString());
        }
    }

    public String displayString() {
        return Modifier.toString(this.code);
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.displayString());
    }

    boolean writeSource(PrintWriter printWriter) {
        String string = Modifier.toString(this.code);
        if (string.length() == 0) {
            return false;
        }
        printWriter.print(string);
        return true;
    }

    static boolean flagsAreSame(int n, int n2, int n3) {
        return (n2 & n) == (n3 & n);
    }

    static boolean anyFlagsAreDifferent(int n, int n2, int n3) {
        return !MWModifier.flagsAreSame(n, n2, n3);
    }
}

