/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.query.xml;

import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.persistence.eis.interactions.EISInteraction;
import org.eclipse.persistence.eis.interactions.XMLInteraction;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneListIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public final class MWEisInteraction
extends MWModel {
    private volatile String functionName;
    public static final String FUNCTION_NAME_PROPERTY = "funtionName";
    private volatile String inputRecordName;
    public static final String INPUT_RECORD_NAME_PROPERTY = "inputRecordName";
    private volatile String inputRootElementName;
    public static final String INPUT_ROOT_ELEMENT_PROPERTY = "inputRootElementName";
    private List inputArguments;
    public static final String INPUT_ARGUMENTS_LIST = "inputArguments";
    private List outputArguments;
    public static final String OUTPUT_ARGUMENTS_LIST = "outputArguments";
    private List properties;
    public static final String PROPERTIES_LIST = "properties";
    private volatile String inputResultPath;
    public static final String INPUT_RESULT_PATH_PROPERTY = "inputResultPath";
    private volatile String outputResultPath;
    public static final String OUTPUT_RESULT_PATH_PROPERTY = "outputResultPath";

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWEisInteraction.class);
        xMLDescriptor.addDirectMapping("functionName", "function-name/text()");
        xMLDescriptor.addDirectMapping(INPUT_RECORD_NAME_PROPERTY, "input-record-name/text()");
        xMLDescriptor.addDirectMapping(INPUT_ROOT_ELEMENT_PROPERTY, "input-root-element-name/text()");
        xMLDescriptor.addDirectMapping(INPUT_RESULT_PATH_PROPERTY, "input-result-path/text()");
        xMLDescriptor.addDirectMapping(OUTPUT_RESULT_PATH_PROPERTY, "output-result-path/text()");
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping.setAttributeName(INPUT_ARGUMENTS_LIST);
        xMLCompositeCollectionMapping.setReferenceClass(ArgumentPair.class);
        xMLCompositeCollectionMapping.setXPath("input-arguments-list");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping2 = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping2.setAttributeName(OUTPUT_ARGUMENTS_LIST);
        xMLCompositeCollectionMapping2.setReferenceClass(ArgumentPair.class);
        xMLCompositeCollectionMapping2.setXPath("output-arguments-list");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping2);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping3 = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping3.setAttributeName(PROPERTIES_LIST);
        xMLCompositeCollectionMapping3.setReferenceClass(ArgumentPair.class);
        xMLCompositeCollectionMapping3.setXPath(PROPERTIES_LIST);
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping3);
        return xMLDescriptor;
    }

    private MWEisInteraction() {
    }

    public MWEisInteraction(MWModel mWModel) {
        super(mWModel);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.inputArguments = new Vector();
        this.outputArguments = new Vector();
        this.properties = new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        List list2 = this.inputArguments;
        synchronized (list2) {
            list.addAll(this.inputArguments);
        }
        list2 = this.outputArguments;
        synchronized (list2) {
            list.addAll(this.outputArguments);
        }
        list2 = this.properties;
        synchronized (list2) {
            list.addAll(this.properties);
        }
    }

    public EISInteraction runtimeInteraction() {
        ArgumentPair argumentPair;
        if (this.getFunctionName() == null) {
            return null;
        }
        XMLInteraction xMLInteraction = new XMLInteraction();
        xMLInteraction.setFunctionName(this.functionName);
        xMLInteraction.setInputRecordName(this.inputRecordName == null ? "" : this.inputRecordName);
        xMLInteraction.setInputRootElementName(this.inputRootElementName == null ? "" : this.inputRootElementName);
        xMLInteraction.setInputResultPath(this.inputResultPath == null ? "" : this.inputResultPath);
        xMLInteraction.setOutputResultPath(this.outputResultPath == null ? "" : this.outputResultPath);
        ListIterator listIterator = this.inputArguments();
        while (listIterator.hasNext()) {
            argumentPair = (ArgumentPair)listIterator.next();
            xMLInteraction.addArgument(argumentPair.getArgumentName() == null ? "" : argumentPair.getArgumentName(), argumentPair.getArgumentFieldName() == null ? "" : argumentPair.getArgumentFieldName());
        }
        listIterator = this.outputArguments();
        while (listIterator.hasNext()) {
            argumentPair = (ArgumentPair)listIterator.next();
            xMLInteraction.addOutputArgument(argumentPair.getArgumentName() == null ? "" : argumentPair.getArgumentName(), argumentPair.getArgumentFieldName() == null ? "" : argumentPair.getArgumentFieldName());
        }
        listIterator = this.properties();
        while (listIterator.hasNext()) {
            argumentPair = (ArgumentPair)listIterator.next();
            xMLInteraction.setProperty(argumentPair.getArgumentName() == null ? "" : argumentPair.getArgumentName(), (Object)(argumentPair.getArgumentFieldName() == null ? "" : argumentPair.getArgumentFieldName()));
        }
        return xMLInteraction;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String string) {
        if (string.equals("")) {
            string = null;
        }
        String string2 = this.functionName;
        this.functionName = string;
        this.firePropertyChanged(FUNCTION_NAME_PROPERTY, string2, this.functionName);
    }

    public String getInputRecordName() {
        return this.inputRecordName;
    }

    public void setInputRecordName(String string) {
        if (string.equals("")) {
            string = null;
        }
        String string2 = this.inputRecordName;
        this.inputRecordName = string;
        this.firePropertyChanged(INPUT_RECORD_NAME_PROPERTY, string2, this.inputRecordName);
    }

    public String getInputRootElementName() {
        return this.inputRootElementName;
    }

    public void setInputRootElementName(String string) {
        if (string.equals("")) {
            string = null;
        }
        String string2 = this.inputRootElementName;
        this.inputRootElementName = string;
        this.firePropertyChanged(INPUT_ROOT_ELEMENT_PROPERTY, string2, this.inputRootElementName);
    }

    public ListIterator properties() {
        return new CloneListIterator(this.properties);
    }

    public ArgumentPair getProperty(int n) {
        return (ArgumentPair)this.properties.get(n);
    }

    public ArgumentPair addProperty() {
        return this.addProperty("propertyName", "propertyValue");
    }

    public ArgumentPair addProperty(String string, String string2) {
        ArgumentPair argumentPair = new ArgumentPair(this, string, string2);
        this.addProperty(argumentPair);
        return argumentPair;
    }

    public void addProperty(ArgumentPair argumentPair) {
        this.properties.add(argumentPair);
        this.fireItemAdded(PROPERTIES_LIST, this.properties.indexOf(argumentPair), argumentPair);
    }

    public void removeProperty(ArgumentPair argumentPair) {
        int n = this.properties.indexOf(argumentPair);
        this.properties.remove(argumentPair);
        this.fireItemRemoved(PROPERTIES_LIST, n, argumentPair);
    }

    public ListIterator inputArguments() {
        return new CloneListIterator(this.inputArguments);
    }

    public ArgumentPair getInputArgumentPair(int n) {
        return (ArgumentPair)this.inputArguments.get(n);
    }

    public ArgumentPair addInputArgument() {
        return this.addInputArgument("argumentName", "argumentFieldName");
    }

    public ArgumentPair addInputArgument(String string, String string2) {
        ArgumentPair argumentPair = new ArgumentPair(this, string, string2);
        this.addInputArgument(argumentPair);
        return argumentPair;
    }

    public void addInputArgument(ArgumentPair argumentPair) {
        this.inputArguments.add(argumentPair);
        this.fireItemAdded(INPUT_ARGUMENTS_LIST, this.inputArguments.indexOf(argumentPair), argumentPair);
    }

    public void removeInputArgument(ArgumentPair argumentPair) {
        int n = this.inputArguments.indexOf(argumentPair);
        this.inputArguments.remove(argumentPair);
        this.fireItemRemoved(INPUT_ARGUMENTS_LIST, n, argumentPair);
    }

    public ListIterator outputArguments() {
        return new CloneListIterator(this.outputArguments);
    }

    public ArgumentPair getOutputArgumentPair(int n) {
        return (ArgumentPair)this.outputArguments.get(n);
    }

    public ArgumentPair addOutputArgument() {
        return this.addOutputArgument("argumentName", "argumentFieldName");
    }

    public ArgumentPair addOutputArgument(String string, String string2) {
        ArgumentPair argumentPair = new ArgumentPair(this, string, string2);
        this.addOutputArgument(argumentPair);
        return argumentPair;
    }

    public void addOutputArgument(ArgumentPair argumentPair) {
        this.outputArguments.add(argumentPair);
        this.fireItemAdded(OUTPUT_ARGUMENTS_LIST, this.outputArguments.indexOf(argumentPair), argumentPair);
    }

    public void removeOutputArgument(ArgumentPair argumentPair) {
        int n = this.outputArguments.indexOf(argumentPair);
        this.outputArguments.remove(argumentPair);
        this.fireItemRemoved(OUTPUT_ARGUMENTS_LIST, n, argumentPair);
    }

    public String getInputResultPath() {
        return this.inputResultPath;
    }

    public void setInputResultPath(String string) {
        if (string.equals("")) {
            string = null;
        }
        String string2 = this.inputResultPath;
        this.inputResultPath = string;
        this.firePropertyChanged(INPUT_RESULT_PATH_PROPERTY, string2, this.inputResultPath);
    }

    public String getOutputResultPath() {
        return this.outputResultPath;
    }

    public void setOutputResultPath(String string) {
        if (string.equals("")) {
            string = null;
        }
        String string2 = this.outputResultPath;
        this.outputResultPath = string;
        this.firePropertyChanged(OUTPUT_RESULT_PATH_PROPERTY, string2, this.outputResultPath);
    }

    public int inputArgumentsSize() {
        return this.inputArguments.size();
    }

    public int outputArgumentsSize() {
        return this.outputArguments.size();
    }

    public int propertySize() {
        return this.properties.size();
    }

    public boolean isSpecified() {
        return !StringTools.stringIsEmpty(this.functionName);
    }

    public void adjustRuntimeDescriptor(DatabaseQuery databaseQuery) {
        ArgumentPair argumentPair;
        XMLInteraction xMLInteraction = new XMLInteraction();
        xMLInteraction.setFunctionName(this.functionName);
        xMLInteraction.setInputRecordName(this.inputRecordName);
        xMLInteraction.setInputRootElementName(this.inputRootElementName);
        xMLInteraction.setInputResultPath(this.inputResultPath);
        xMLInteraction.setOutputResultPath(this.outputResultPath);
        ListIterator listIterator = this.inputArguments();
        while (listIterator.hasNext()) {
            argumentPair = (ArgumentPair)listIterator.next();
            xMLInteraction.addArgument(argumentPair.getArgumentName(), argumentPair.getArgumentFieldName());
        }
        listIterator = this.outputArguments();
        while (listIterator.hasNext()) {
            argumentPair = (ArgumentPair)listIterator.next();
            xMLInteraction.addOutputArgument(argumentPair.getArgumentName(), argumentPair.getArgumentFieldName());
        }
        listIterator = this.properties();
        while (listIterator.hasNext()) {
            argumentPair = (ArgumentPair)listIterator.next();
            xMLInteraction.setProperty(argumentPair.getArgumentName(), (Object)argumentPair.getArgumentFieldName());
        }
        databaseQuery.setCall((Call)xMLInteraction);
    }

    public static class ArgumentPair
    extends MWModel {
        private volatile String argumentName;
        public static final String ARGUMENT_NAME_PROPERTY = "argumentName";
        private volatile String argumentFieldName;
        public static final String ARGUMENT_FIELD_NAME_PROPERTY = "argumentFieldName";

        public static final XMLDescriptor buildDescriptor() {
            XMLDescriptor xMLDescriptor = new XMLDescriptor();
            xMLDescriptor.setJavaClass(ArgumentPair.class);
            XMLDirectMapping xMLDirectMapping = (XMLDirectMapping)xMLDescriptor.addDirectMapping(ARGUMENT_NAME_PROPERTY, "@name");
            xMLDirectMapping.setNullValue((Object)"");
            XMLDirectMapping xMLDirectMapping2 = (XMLDirectMapping)xMLDescriptor.addDirectMapping(ARGUMENT_FIELD_NAME_PROPERTY, "@field-name");
            xMLDirectMapping2.setNullValue((Object)"");
            return xMLDescriptor;
        }

        private ArgumentPair() {
        }

        ArgumentPair(MWEisInteraction mWEisInteraction, String string, String string2) {
            super(mWEisInteraction);
            this.argumentName = string;
            this.argumentFieldName = string2;
        }

        public String getArgumentName() {
            return this.argumentName;
        }

        public void setArgumentName(String string) {
            if (string.equals("")) {
                string = null;
            }
            String string2 = this.argumentName;
            this.argumentName = string;
            this.firePropertyChanged(ARGUMENT_NAME_PROPERTY, string2, this.argumentName);
        }

        public String getArgumentFieldName() {
            return this.argumentFieldName;
        }

        public void setArgumentFieldName(String string) {
            if (string.equals("")) {
                string = null;
            }
            String string2 = this.argumentFieldName;
            this.argumentFieldName = string;
            this.firePropertyChanged(ARGUMENT_FIELD_NAME_PROPERTY, string2, this.argumentFieldName);
        }

        public void setArgumentPairNames(String string, String string2) {
            this.setArgumentName(string);
            this.setArgumentFieldName(string2);
        }
    }
}

