/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.schema;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.apache.xerces.impl.xs.XSModelGroupImpl;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSObject;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.AbstractParticle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.AbstractSchemaComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.AbstractSchemaModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWAttributeDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWElementDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWModelGroup;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWParticle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.Wildcard;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.XercesTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CompositeIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.SingleElementIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationListIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class ExplicitModelGroup
extends AbstractParticle
implements MWModelGroup {
    private volatile String compositor;
    private List particles;

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(ExplicitModelGroup.class);
        xMLDescriptor.getInheritancePolicy().setParentClass(AbstractParticle.class);
        xMLDescriptor.addDirectMapping("compositor", "@compositor");
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping.setAttributeName("particles");
        xMLCompositeCollectionMapping.setReferenceClass(AbstractSchemaComponent.class);
        xMLCompositeCollectionMapping.setXPath("particles/particle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping);
        return xMLDescriptor;
    }

    private ExplicitModelGroup() {
    }

    ExplicitModelGroup(AbstractSchemaModel abstractSchemaModel) {
        super(abstractSchemaModel);
    }

    protected void initialize() {
        super.initialize();
        this.particles = new Vector();
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.compositor = "sequence";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        List list2 = this.particles;
        synchronized (list2) {
            list.addAll(this.particles);
        }
    }

    ListIterator particles() {
        return this.particles.listIterator();
    }

    public String getCompositor() {
        return this.compositor;
    }

    public boolean containsWildcard() {
        boolean bl = false;
        ListIterator listIterator = this.particles();
        while (listIterator.hasNext() && !bl) {
            MWParticle mWParticle = (MWParticle)listIterator.next();
            if (mWParticle instanceof Wildcard) {
                bl = true;
                continue;
            }
            if (!(mWParticle instanceof MWModelGroup)) continue;
            bl |= ((MWModelGroup)mWParticle).containsWildcard();
        }
        return bl;
    }

    public void addDirectlyOwnedComponentsTo(Collection collection) {
        ListIterator listIterator = this.particles();
        while (listIterator.hasNext()) {
            MWParticle mWParticle = (MWParticle)listIterator.next();
            if (mWParticle instanceof MWElementDeclaration) {
                collection.add(mWParticle);
                continue;
            }
            mWParticle.addDirectlyOwnedComponentsTo(collection);
        }
    }

    public int compareSchemaOrder(MWElementDeclaration mWElementDeclaration, MWElementDeclaration mWElementDeclaration2) {
        MWParticle mWParticle = null;
        MWParticle mWParticle2 = null;
        ListIterator listIterator = this.particles();
        while (listIterator.hasNext()) {
            MWParticle mWParticle3 = (MWParticle)listIterator.next();
            if (mWElementDeclaration.isDescendantOf(mWParticle3)) {
                mWParticle = mWParticle3;
            }
            if (!mWElementDeclaration2.isDescendantOf(mWParticle3)) continue;
            mWParticle2 = mWParticle3;
        }
        if (mWParticle == null || mWParticle2 == null) {
            return 0;
        }
        if (mWParticle == mWParticle2) {
            return mWParticle.compareSchemaOrder(mWElementDeclaration, mWElementDeclaration2);
        }
        if (this.particles.indexOf(mWParticle) < this.particles.indexOf(mWParticle2)) {
            return -1;
        }
        if (this.particles.indexOf(mWParticle) > this.particles.indexOf(mWParticle2)) {
            return 1;
        }
        return 0;
    }

    public boolean isEquivalentTo(XSParticleDecl xSParticleDecl) {
        return xSParticleDecl.getTerm() instanceof XSModelGroup;
    }

    public Iterator structuralComponents() {
        return this.particles();
    }

    public Iterator descriptorContextComponents() {
        return new CompositeIterator(this.descriptorContextComponentIterators());
    }

    private Iterator descriptorContextComponentIterators() {
        return new TransformationIterator(this.particles()){

            protected Object transform(Object object) {
                MWParticle mWParticle = (MWParticle)object;
                if (mWParticle.isDescriptorContextComponent()) {
                    return new SingleElementIterator(mWParticle);
                }
                return mWParticle.descriptorContextComponents();
            }
        };
    }

    public Iterator xpathComponents() {
        return new CompositeIterator(this.xpathComponentIterators());
    }

    private ListIterator xpathComponentIterators() {
        return new TransformationListIterator(this.particles()){

            protected Object transform(Object object) {
                MWParticle mWParticle = (MWParticle)object;
                if (mWParticle instanceof MWElementDeclaration) {
                    return new SingleElementIterator(mWParticle);
                }
                return ((MWParticle)object).xpathComponents();
            }
        };
    }

    public MWAttributeDeclaration nestedAttribute(String string, String string2) {
        ListIterator listIterator = this.particles();
        while (listIterator.hasNext()) {
            MWAttributeDeclaration mWAttributeDeclaration = ((MWParticle)listIterator.next()).nestedAttribute(string, string2);
            if (mWAttributeDeclaration == null) continue;
            return mWAttributeDeclaration;
        }
        return null;
    }

    public MWElementDeclaration nestedElement(String string, String string2) {
        ListIterator listIterator = this.particles();
        while (listIterator.hasNext()) {
            MWElementDeclaration mWElementDeclaration;
            MWParticle mWParticle = (MWParticle)listIterator.next();
            if (!(mWParticle instanceof MWElementDeclaration ? string2.equals((mWElementDeclaration = (MWElementDeclaration)mWParticle).getName()) : (mWElementDeclaration = mWParticle.nestedElement(string, string2)) != null)) continue;
            return mWElementDeclaration;
        }
        return null;
    }

    public int totalElementCount() {
        int n = 0;
        ListIterator listIterator = this.particles();
        while (listIterator.hasNext()) {
            MWParticle mWParticle = (MWParticle)listIterator.next();
            if (mWParticle instanceof MWElementDeclaration) {
                ++n;
                continue;
            }
            n += mWParticle.totalElementCount();
        }
        return n;
    }

    protected void reloadInternal(XSObject xSObject) {
        XSModelGroupImpl xSModelGroupImpl = null;
        if (xSObject instanceof XSParticleDecl) {
            super.reloadInternal(xSObject);
            xSModelGroupImpl = (XSModelGroupImpl)((XSParticleDecl)xSObject).getTerm();
        } else {
            xSModelGroupImpl = (XSModelGroupImpl)xSObject;
        }
        this.reloadCompositor((XSModelGroup)xSModelGroupImpl);
        this.reloadParticles((XSModelGroup)xSModelGroupImpl);
    }

    private void reloadCompositor(XSModelGroup xSModelGroup) {
        this.compositor = xSModelGroup.getCompositor() == 2 ? "choice" : (xSModelGroup.getCompositor() == 1 ? "sequence" : "all");
    }

    private void reloadParticles(XSModelGroup xSModelGroup) {
        Object object;
        MWParticle mWParticle;
        ListIterator listIterator = this.particles();
        ListIterator<XSObject> listIterator2 = XercesTools.listIteratorFromXSObjectList(xSModelGroup.getParticles());
        while (listIterator.hasNext() && listIterator2.hasNext()) {
            mWParticle = (MWParticle)listIterator.next();
            if (mWParticle.isEquivalentTo((XSParticleDecl)(object = (XSParticleDecl)listIterator2.next()))) {
                mWParticle.reload((XSObject)object);
                continue;
            }
            listIterator.remove();
            this.getProject().nodeRemoved(mWParticle);
            MWParticle mWParticle2 = MWParticle.ParticleFactory.newParticle(this, object);
            listIterator.add(mWParticle2);
        }
        while (listIterator.hasNext()) {
            mWParticle = (MWParticle)listIterator.next();
            listIterator.remove();
            this.getProject().nodeRemoved(mWParticle);
        }
        while (listIterator2.hasNext()) {
            mWParticle = (XSParticleDecl)listIterator2.next();
            object = MWParticle.ParticleFactory.newParticle(this, (XSParticleDecl)mWParticle);
            listIterator.add(object);
        }
    }

    public void resolveReferences() {
        super.resolveReferences();
        Iterator iterator = this.particles.iterator();
        while (iterator.hasNext()) {
            ((MWParticle)iterator.next()).resolveReferences();
        }
    }
}

