/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.classloader;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassDescription;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalConstructor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalMethod;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.classloader.CLExternalClassDescription;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.classloader.CLExternalConstructor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.classloader.CLExternalField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.classloader.CLExternalMethod;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

final class CLExternalClass
implements ExternalClass {
    private final Class javaClass;
    private final CLExternalClassDescription classDescription;

    CLExternalClass(Class clazz, CLExternalClassDescription cLExternalClassDescription) {
        this.javaClass = clazz;
        this.classDescription = cLExternalClassDescription;
    }

    public ExternalClassDescription[] getDeclaredClasses() {
        return this.buildClassDescriptionArray(this.javaClass.getDeclaredClasses());
    }

    public ExternalConstructor[] getDeclaredConstructors() {
        return this.buildConstructorArray(this.javaClass.getDeclaredConstructors());
    }

    public ExternalField[] getDeclaredFields() {
        return this.buildFieldArray(this.javaClass.getDeclaredFields());
    }

    public ExternalMethod[] getDeclaredMethods() {
        return this.buildMethodArray(this.javaClass.getDeclaredMethods());
    }

    public ExternalClassDescription getDeclaringClass() {
        return this.classDescriptionFor(this.javaClass.getDeclaringClass());
    }

    public ExternalClassDescription[] getInterfaces() {
        return this.buildClassDescriptionArray(this.javaClass.getInterfaces());
    }

    public int getModifiers() {
        return this.javaClass.getModifiers();
    }

    public String getName() {
        return this.javaClass.getName();
    }

    public ExternalClassDescription getSuperclass() {
        return this.classDescriptionFor(this.javaClass.getSuperclass());
    }

    public boolean isInterface() {
        return this.javaClass.isInterface();
    }

    public boolean isPrimitive() {
        return this.javaClass.isPrimitive();
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.getName());
    }

    ExternalClassDescription classDescriptionFor(Class clazz) {
        if (clazz == null) {
            return null;
        }
        return this.classDescription.classDescriptionFor(clazz);
    }

    private ExternalClassDescription[] buildClassDescriptionArray(Class[] classArray) {
        ExternalClassDescription[] externalClassDescriptionArray = new ExternalClassDescription[classArray.length];
        int n = classArray.length;
        while (n-- > 0) {
            externalClassDescriptionArray[n] = this.classDescriptionFor(classArray[n]);
        }
        return externalClassDescriptionArray;
    }

    private ExternalConstructor[] buildConstructorArray(Constructor[] constructorArray) {
        ExternalConstructor[] externalConstructorArray = new ExternalConstructor[constructorArray.length];
        int n = constructorArray.length;
        while (n-- > 0) {
            externalConstructorArray[n] = new CLExternalConstructor(constructorArray[n], this);
        }
        return externalConstructorArray;
    }

    private ExternalField[] buildFieldArray(Field[] fieldArray) {
        ExternalField[] externalFieldArray = new ExternalField[fieldArray.length];
        int n = fieldArray.length;
        while (n-- > 0) {
            externalFieldArray[n] = new CLExternalField(fieldArray[n], this);
        }
        return externalFieldArray;
    }

    private ExternalMethod[] buildMethodArray(Method[] methodArray) {
        ExternalMethod[] externalMethodArray = new ExternalMethod[methodArray.length];
        int n = methodArray.length;
        while (n-- > 0) {
            externalMethodArray[n] = new CLExternalMethod(methodArray[n], this);
        }
        return externalMethodArray;
    }
}

