/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import java.io.PrintWriter;
import org.eclipse.persistence.tools.workbench.utility.classfile.Attribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.AttributePool;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class ExceptionsAttribute
extends Attribute {
    private short count;
    private short[] exceptionIndexes;

    ExceptionsAttribute(ClassFileDataInputStream classFileDataInputStream, short s, AttributePool attributePool) throws IOException {
        super(classFileDataInputStream, s, attributePool);
    }

    void initializeInfo(ClassFileDataInputStream classFileDataInputStream) throws IOException {
        short s = this.count = classFileDataInputStream.readU2();
        short[] sArray = this.exceptionIndexes = new short[s];
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            sArray[s2] = classFileDataInputStream.readU2();
        }
    }

    void displayInfoStringOn(IndentingPrintWriter indentingPrintWriter) {
        short s = this.count;
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            indentingPrintWriter.println(this.exceptionClassName(s2));
        }
    }

    public String exceptionClassName(short s) {
        return this.constantPool().getClassConstant(this.exceptionIndexes[s]).name();
    }

    public String[] exceptionClassNames() {
        short s = this.count;
        if (s == 0) {
            return EMPTY_STRING_ARRAY;
        }
        String[] stringArray = new String[s];
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            stringArray[s2] = this.exceptionClassName(s2);
        }
        return stringArray;
    }

    public void printThrowsClauseOn(PrintWriter printWriter) {
        short s = this.count;
        if (s == 0) {
            return;
        }
        printWriter.print(" throws ");
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            if (s2 != 0) {
                printWriter.print(", ");
            }
            printWriter.print(this.exceptionClassName(s2));
        }
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public short getCount() {
        return this.count;
    }

    public short[] getExceptionIndexes() {
        return this.exceptionIndexes;
    }

    public short getExceptionIndex(short s) {
        return this.exceptionIndexes[s];
    }

    void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.count);
        stringBuffer.append(" exception(s)");
    }
}

