/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import java.io.PrintWriter;
import org.eclipse.persistence.tools.workbench.utility.classfile.FieldPool;
import org.eclipse.persistence.tools.workbench.utility.classfile.Member;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.descriptor.FieldType;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;

public class Field
extends Member {
    private FieldType fieldDescriptor;
    public static final short ACC_ENUM = 16384;
    public static final int VISIBLE_ACCESS_FLAGS_MASK = 223;

    Field(ClassFileDataInputStream classFileDataInputStream, FieldPool fieldPool) throws IOException {
        super(classFileDataInputStream, fieldPool);
    }

    short visibleAccessFlagsMask() {
        return 223;
    }

    public void printDeclarationOn(PrintWriter printWriter) {
        this.printModifierOn(printWriter);
        this.getFieldDescriptor().printDeclarationOn(printWriter);
        printWriter.print(' ');
        printWriter.print(this.name());
        this.getAttributePool().printFieldInitializationClauseOn(printWriter);
    }

    public String javaTypeName() {
        return this.getFieldDescriptor().javaName();
    }

    public FieldPool getFieldPool() {
        return (FieldPool)this.getPool();
    }

    public Object constantValue() {
        return this.getAttributePool().fieldConstantValue();
    }

    public boolean isEnum() {
        return (this.getAccessFlags() & 0x4000) != 0;
    }

    public boolean isDeclaredField() {
        return !this.isSynthetic();
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
        this.getFieldDescriptor().accept(visitor);
        super.accept(visitor);
    }

    public FieldType getFieldDescriptor() {
        if (this.fieldDescriptor == null) {
            this.fieldDescriptor = FieldType.createFieldType(this.descriptor());
        }
        return this.fieldDescriptor;
    }
}

