/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.events;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.events.ReflectiveChangeListener;
import org.eclipse.persistence.tools.workbench.utility.events.StateChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.StateChangeListener;

class SingleMethodReflectiveChangeListener
extends ReflectiveChangeListener
implements StateChangeListener,
PropertyChangeListener {
    private Method method;
    private boolean methodIsZeroArgument;

    SingleMethodReflectiveChangeListener(Object object, Method method) {
        super(object);
        this.method = method;
        this.methodIsZeroArgument = method.getParameterTypes().length == 0;
    }

    public void stateChanged(StateChangeEvent stateChangeEvent) {
        if (this.methodIsZeroArgument) {
            ClassTools.invokeMethod(this.method, this.target, EMPTY_STATE_CHANGE_EVENT_ARRAY);
        } else {
            ClassTools.invokeMethod(this.method, this.target, new StateChangeEvent[]{stateChangeEvent});
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.methodIsZeroArgument) {
            ClassTools.invokeMethod(this.method, this.target, EMPTY_PROPERTY_CHANGE_EVENT_ARRAY);
        } else {
            ClassTools.invokeMethod(this.method, this.target, new PropertyChangeEvent[]{propertyChangeEvent});
        }
    }
}

