/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.io;

import java.io.Writer;

public class TokenWriter
extends Writer {
    private String delimiters;
    private char escapeCharacter;
    private StringBuffer buffer;
    private char maxDelimiter;
    private char[] delimiterBuffer;
    private final int delimiterBufferSize = 1024;
    public static final String DEFAULT_DELIMITERS = " \t\n\r\f";
    public static final char DEFAULT_ESCAPE_CHARACTER = '\\';

    private TokenWriter(String string, char c, StringBuffer stringBuffer) {
        this.delimiters = string;
        this.escapeCharacter = c;
        this.buffer = stringBuffer;
        this.lock = stringBuffer;
        this.initialize();
    }

    public TokenWriter() {
        this(DEFAULT_DELIMITERS, '\\', new StringBuffer());
    }

    public TokenWriter(int n) {
        this(DEFAULT_DELIMITERS, '\\', new StringBuffer(n));
    }

    public TokenWriter(String string) {
        this(string, '\\', new StringBuffer());
    }

    public TokenWriter(String string, char c) {
        this(string, c, new StringBuffer());
    }

    public TokenWriter(String string, char c, int n) {
        this(string, c, new StringBuffer(n));
    }

    private void initialize() {
        this.calculateMaxDelimiter();
        if (this.charIsDelimiter(this.escapeCharacter)) {
            throw new IllegalArgumentException("The \"escape\" character may not belong to the list of delimiters.");
        }
    }

    private void calculateMaxDelimiter() {
        if (this.delimiters == null) {
            throw new NullPointerException();
        }
        this.maxDelimiter = '\u0000';
        for (int i = 0; i < this.delimiters.length(); ++i) {
            char c = this.delimiters.charAt(i);
            if (this.maxDelimiter >= c) continue;
            this.maxDelimiter = c;
        }
    }

    private boolean charIsDelimiter(int n) {
        return n <= this.maxDelimiter && this.delimiters.indexOf(n) >= 0;
    }

    private boolean charIsTheEscapeCharacter(int n) {
        return n == this.escapeCharacter;
    }

    private boolean charRequiresEscape(int n) {
        return this.charIsTheEscapeCharacter(n) || this.charIsDelimiter(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int n) {
        Object object = this.lock;
        synchronized (object) {
            if (this.charRequiresEscape(n)) {
                this.buffer.append(this.escapeCharacter);
            }
            this.buffer.append((char)n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDelimiter(int n) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.charIsDelimiter(n)) {
                throw new IllegalArgumentException("Not a delimiter: " + n);
            }
            this.buffer.append((char)n);
        }
    }

    private void checkIndices(char[] cArray, int n, int n2) {
        if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] cArray, int n, int n2) {
        Object object = this.lock;
        synchronized (object) {
            this.checkIndices(cArray, n, n2);
            if (n2 == 0) {
                return;
            }
            int n3 = n + n2;
            for (int i = n; i < n3; ++i) {
                this.write(cArray[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDelimiter(char[] cArray, int n, int n2) {
        Object object = this.lock;
        synchronized (object) {
            this.checkIndices(cArray, n, n2);
            if (n2 == 0) {
                return;
            }
            int n3 = n + n2;
            for (int i = n; i < n3; ++i) {
                this.writeDelimiter(cArray[i]);
            }
        }
    }

    public void writeDelimiter(String string) {
        this.writeDelimiter(string, 0, string.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDelimiter(String string, int n, int n2) {
        Object object = this.lock;
        synchronized (object) {
            char[] cArray;
            if (n2 <= this.delimiterBufferSize) {
                if (this.delimiterBuffer == null) {
                    this.delimiterBuffer = new char[this.delimiterBufferSize];
                }
                cArray = this.delimiterBuffer;
            } else {
                cArray = new char[n2];
            }
            string.getChars(n, n + n2, cArray, 0);
            this.writeDelimiter(cArray, 0, n2);
        }
    }

    public String toString() {
        return this.buffer.toString();
    }

    public StringBuffer getBuffer() {
        return this.buffer;
    }

    public void flush() {
    }

    public void close() {
    }
}

