/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.app;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.io.Serializable;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.eclipse.persistence.tools.workbench.framework.app.IconBuilder;
import org.eclipse.persistence.tools.workbench.uitools.swing.CompositeIcon;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class ActiveIconBuilder
implements IconBuilder,
Cloneable,
Serializable {
    private IconBuilder original;
    private boolean active;
    private static final ImageFilter INACTIVE_ICON_FILTER = new GrayFilter(true, 50);
    private static final long serialVersionUID = 1L;

    public ActiveIconBuilder(IconBuilder iconBuilder, boolean bl) {
        if (iconBuilder == null) {
            throw new NullPointerException();
        }
        this.original = iconBuilder;
        this.active = bl;
    }

    public Icon buildIcon() {
        Icon icon = this.original.buildIcon();
        return this.active ? icon : this.buildInactiveIcon(icon);
    }

    protected Icon buildInactiveIcon(Icon icon) {
        if (icon instanceof ImageIcon) {
            return this.buildInactiveImageIcon((ImageIcon)icon);
        }
        if (icon instanceof CompositeIcon) {
            return this.buildInactiveCompositeIcon((CompositeIcon)icon);
        }
        return icon;
    }

    protected Icon buildInactiveImageIcon(ImageIcon imageIcon) {
        Image image = imageIcon.getImage();
        Image image2 = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), INACTIVE_ICON_FILTER));
        return new ImageIcon(image2);
    }

    protected Icon buildInactiveCompositeIcon(CompositeIcon compositeIcon) {
        compositeIcon = (CompositeIcon)compositeIcon.clone();
        int n = compositeIcon.iconCount();
        for (int i = 0; i < n; ++i) {
            compositeIcon.setIcon(i, this.buildInactiveIcon(compositeIcon.getIcon(i)));
        }
        return compositeIcon;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (object instanceof ActiveIconBuilder) {
            return this.equals((ActiveIconBuilder)object);
        }
        return false;
    }

    public boolean equals(ActiveIconBuilder activeIconBuilder) {
        return ((Object)this.original).equals(activeIconBuilder.original) && this.active == activeIconBuilder.active;
    }

    public int hashCode() {
        return ((Object)this.original).hashCode() ^ Boolean.valueOf(this.active).hashCode();
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.original);
    }
}

