/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.app;

import java.io.Serializable;
import javax.swing.Icon;
import org.eclipse.persistence.tools.workbench.framework.app.IconBuilder;
import org.eclipse.persistence.tools.workbench.uitools.swing.CompositeIcon;
import org.eclipse.persistence.tools.workbench.uitools.swing.EmptyIcon;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class CompositeIconBuilder
implements IconBuilder,
Cloneable,
Serializable {
    private IconBuilder original;
    private boolean combine;
    private Icon icon;
    private int gap;
    private int orientation;
    private int alignment;
    private String description;
    private Icon emptyIcon;
    private static final long serialVersionUID = 1L;

    public CompositeIconBuilder(IconBuilder iconBuilder, boolean bl, Icon icon, int n, int n2, int n3, String string) {
        if (iconBuilder == null) {
            throw new NullPointerException();
        }
        this.original = iconBuilder;
        this.combine = bl;
        this.icon = icon;
        this.gap = n;
        this.orientation = n2;
        this.alignment = n3;
        this.description = string;
    }

    public CompositeIconBuilder(IconBuilder iconBuilder, boolean bl, Icon icon) {
        this(iconBuilder, bl, icon, 0, 0, 0, null);
    }

    public Icon buildIcon() {
        Icon icon = this.original.buildIcon();
        Icon icon2 = this.combine ? this.icon : this.getEmptyIcon();
        return this.buildCompositeIcon(icon, icon2);
    }

    protected Icon buildCompositeIcon(Icon icon, Icon icon2) {
        CompositeIcon compositeIcon = new CompositeIcon(icon, this.gap, icon2);
        compositeIcon.setOrientation(this.orientation);
        compositeIcon.setAlignment(this.alignment);
        compositeIcon.setDescription(this.description);
        return compositeIcon;
    }

    protected Icon getEmptyIcon() {
        if (this.emptyIcon == null) {
            this.emptyIcon = this.buildEmptyIcon();
        }
        return this.emptyIcon;
    }

    protected Icon buildEmptyIcon() {
        return new EmptyIcon(this.icon.getIconWidth(), this.icon.getIconHeight());
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (object instanceof CompositeIconBuilder) {
            return this.equals((CompositeIconBuilder)object);
        }
        return false;
    }

    public boolean equals(CompositeIconBuilder compositeIconBuilder) {
        return ((Object)this.original).equals(compositeIconBuilder.original) && this.combine == compositeIconBuilder.combine && (this.icon == null ? compositeIconBuilder.icon == null : this.icon.equals(compositeIconBuilder.icon)) && this.gap == compositeIconBuilder.gap && this.orientation == compositeIconBuilder.orientation && this.alignment == compositeIconBuilder.alignment && (this.description == null ? compositeIconBuilder.description == null : this.description.equals(compositeIconBuilder.description));
    }

    public int hashCode() {
        return ((Object)this.original).hashCode() ^ Boolean.valueOf(this.combine).hashCode() ^ (this.icon == null ? 0 : this.icon.hashCode()) ^ this.gap ^ this.orientation ^ this.alignment ^ (this.description == null ? 0 : this.description.hashCode());
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.original);
    }
}

