/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.help;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.eclipse.persistence.tools.workbench.framework.context.PreferencesContext;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.FileChooserPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingTools;
import org.eclipse.persistence.tools.workbench.uitools.app.BufferedPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.adapters.PreferencePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.utility.string.BidiStringConverter;

final class HelpPreferencesPage
extends AbstractPanel {
    private PropertyValueModel bufferedHostLocalAdapter;

    HelpPreferencesPage(PreferencesContext preferencesContext) {
        super((LayoutManager)new BorderLayout(), preferencesContext);
        this.intializeLayout();
    }

    private void intializeLayout() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = SwingTools.checkBoxIconWidth();
        JPanel jPanel = new JPanel(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.getVerticalScrollBar().setBlockIncrement(20);
        jScrollPane.setBorder(null);
        jScrollPane.setViewportBorder(null);
        this.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JCheckBox jCheckBox = this.buildCheckBox("PREFERENCES.GENERAL.HELP.DISPLAY_WELCOME", this.buildDisplayWelcomeModel());
        this.addHelpTopicId(jCheckBox, this.helpTopicId() + ".welcome");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JLabel jLabel = this.buildLabel("PREFERENCES.GENERAL.HELP.BROWSER_CHOOSER");
        this.addHelpTopicId(jLabel, this.helpTopicId() + ".browser");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        FileChooserPanel fileChooserPanel = new FileChooserPanel(this.getPreferencesContext(), this.buildBrowserHolder(), "PREFERENCES.GENERAL.HELP.BROWSER_CHOOSER", "PREFERENCES.GENERAL.HELP.BROWSER_CHOOSER_BUTTON", 0, true){

            protected boolean labelVisible() {
                return false;
            }
        };
        this.addHelpTopicId(fileChooserPanel, this.helpTopicId() + ".browser");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(1, n, 0, 5);
        jPanel2.add((Component)fileChooserPanel, gridBagConstraints);
        jLabel.setLabelFor(fileChooserPanel);
        JLabel jLabel2 = this.buildLabel("PREFERENCES.GENERAL.HELP.LOCAL");
        this.addHelpTopicId(jLabel2, this.helpTopicId() + ".local");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        FileChooserPanel fileChooserPanel2 = new FileChooserPanel(this.getPreferencesContext(), this.buildLocalFileHolder(), "PREFERENCES.GENERAL.HELP.LOCAL", "PREFERENCES.GENERAL.HELP.LOCAL_BROWSER_CHOOSER_BUTTON", 0){

            protected boolean labelVisible() {
                return false;
            }
        };
        this.addHelpTopicId(fileChooserPanel2, this.helpTopicId() + ".local");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(0, n, 0, 5);
        this.addHelpTopicId(this, this.helpTopicId());
    }

    private ButtonModel buildDisplayWelcomeModel() {
        return new CheckBoxModelAdapter(this.buildBufferedDisplayWelcomeAdapter());
    }

    private PropertyValueModel buildBufferedDisplayWelcomeAdapter() {
        return new BufferedPropertyValueModel(this.buildDisplayWelcomeAdapter(), this.getPreferencesContext().getBufferTrigger());
    }

    private PropertyValueModel buildDisplayWelcomeAdapter() {
        PreferencePropertyValueModel preferencePropertyValueModel = new PreferencePropertyValueModel(this.preferences(), "display welcome", true);
        preferencePropertyValueModel.setConverter(BidiStringConverter.BOOLEAN_CONVERTER);
        return preferencePropertyValueModel;
    }

    private PropertyValueModel buildLocalFileHolder() {
        return new BufferedPropertyValueModel(this.buildLocalFileAdapter(), this.getPreferencesContext().getBufferTrigger());
    }

    private PropertyValueModel buildLocalFileAdapter() {
        return new PreferencePropertyValueModel(this.preferences(), "local file", (Object)"");
    }

    private PropertyValueModel buildBrowserHolder() {
        return new BufferedPropertyValueModel(this.buildBrowserAdapter(), this.getPreferencesContext().getBufferTrigger());
    }

    private PropertyValueModel buildBrowserAdapter() {
        PreferencePropertyValueModel preferencePropertyValueModel = new PreferencePropertyValueModel(this.preferences(), "external web browser");
        preferencePropertyValueModel.setConverter(BidiStringConverter.DEFAULT_INSTANCE);
        return preferencePropertyValueModel;
    }

    public String helpTopicId() {
        return "preferences.general.help";
    }
}

