/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.internal;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.internal.FrameworkNodeManager;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeListener;

final class CloseAllAction
extends AbstractFrameworkAction {
    private FrameworkNodeManager nodeManager;
    private CollectionChangeListener projectNodesListener;
    private WindowListener windowListener;

    CloseAllAction(WorkbenchContext workbenchContext, FrameworkNodeManager frameworkNodeManager) {
        super(workbenchContext);
        this.initialize(frameworkNodeManager);
    }

    protected void initialize() {
        super.initialize();
        this.initializeTextAndMnemonic("file.closeAll");
        this.initializeIcon("file.closeAll");
        this.initializeAccelerator("file.closeAll.ACCELERATOR");
        this.initializeToolTipText("file.closeAll.toolTipText");
    }

    private void initialize(FrameworkNodeManager frameworkNodeManager) {
        this.nodeManager = frameworkNodeManager;
        this.projectNodesListener = this.buildProjectNodesListener();
        frameworkNodeManager.addCollectionChangeListener("projectNodes", this.projectNodesListener);
        this.windowListener = this.buildWorkbenchWindowListener();
        this.currentWindow().addWindowListener(this.windowListener);
        this.updateEnabledState();
    }

    private CollectionChangeListener buildProjectNodesListener() {
        return new CollectionChangeListener(){

            public void itemsAdded(CollectionChangeEvent collectionChangeEvent) {
                CloseAllAction.this.projectNodesChanged();
            }

            public void itemsRemoved(CollectionChangeEvent collectionChangeEvent) {
                CloseAllAction.this.projectNodesChanged();
            }

            public void collectionChanged(CollectionChangeEvent collectionChangeEvent) {
                CloseAllAction.this.projectNodesChanged();
            }
        };
    }

    private WindowListener buildWorkbenchWindowListener() {
        return new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                CloseAllAction.this.workbenchWindowClosed();
            }
        };
    }

    void projectNodesChanged() {
        this.updateEnabledState();
    }

    private void updateEnabledState() {
        this.setEnabled(this.nodeManager.projectNodesSize() > 0);
    }

    protected void execute() {
        this.nodeManager.closeAll(this.getWorkbenchContext());
    }

    void workbenchWindowClosed() {
        this.nodeManager.removeCollectionChangeListener("projectNodes", this.projectNodesListener);
        this.currentWindow().removeWindowListener(this.windowListener);
    }
}

