/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.internal;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.PreferencesContext;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.uitools.app.BufferedPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ReadOnlyCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.adapters.PreferencePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.NumberSpinnerModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.string.BidiStringConverter;

final class GeneralPreferencesPage
extends AbstractPanel {
    private List lafInfos;
    private static final long serialVersionUID = 1L;

    GeneralPreferencesPage(PreferencesContext preferencesContext) {
        super((LayoutManager)new BorderLayout(), preferencesContext);
        this.buildLookAndFeelList();
        this.intializeLayout();
    }

    private void buildLookAndFeelList() {
        this.lafInfos = new ArrayList();
        CollectionTools.addAll((Collection)this.lafInfos, (Object[])UIManager.getInstalledLookAndFeels());
        this.lafInfos.add(new UIManager.LookAndFeelInfo("Oracle", "oracle.bali.ewt.olaf2.OracleLookAndFeel"));
        Collections.sort(this.lafInfos, this.buildLookAndFeelComparator());
    }

    private void intializeLayout() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.getVerticalScrollBar().setBlockIncrement(20);
        jScrollPane.setBorder(null);
        jScrollPane.setViewportBorder(null);
        this.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JCheckBox jCheckBox = this.buildCheckBox("PREFERENCES.GENERAL.DISPLAY_SPLASH_SCREEN", this.buildDisplaySplashScreenModel());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel2.add((Component)jCheckBox, gridBagConstraints);
        JComponent jComponent = this.buildLabeledComboBox("PREFERENCES.GENERAL.LOOK_AND_FEEL", this.buildLookAndFeelComboBoxModel(), this.buildLookAndFeelListCellRenderer());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        jPanel2.add((Component)jComponent, gridBagConstraints);
        JComponent jComponent2 = this.buildRecentFilesSizeSpinner();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        jPanel2.add((Component)jComponent2, gridBagConstraints);
        JComponent jComponent3 = this.buildLabeledTextField("PREFERENCES.GENERAL.HTTP.PROXY.HOST", this.buildProxyHostDocumentAdapter());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        jPanel2.add((Component)jComponent3, gridBagConstraints);
        JComponent jComponent4 = this.buildLabeledTextField("PREFERENCES.GENERAL.HTTP.PROXY.PORT", this.buildProxyPortDocumentAdapter());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        jPanel2.add((Component)jComponent4, gridBagConstraints);
        JComponent jComponent5 = this.buildLabeledTextField("PREFERENCES.GENERAL.NETWORK.CONNECT_TIMEOUT", this.buildNetworkConnectTimeoutDocumentAdapter());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        jPanel2.add((Component)jComponent5, gridBagConstraints);
        JComponent jComponent6 = this.buildLabeledTextField("PREFERENCES.GENERAL.NETWORK.READ_TIMEOUT", this.buildNetworkReadTimeoutDocumentAdapter());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel2.add((Component)jComponent6, gridBagConstraints);
        JCheckBox jCheckBox2 = this.buildCheckBox("PREFERENCES.GENERAL.REOPEN_PROJECTS", this.buildReopenProjectsModel());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel2.add((Component)jCheckBox2, gridBagConstraints);
        this.addHelpTopicId(this, "preferences.general");
    }

    private ButtonModel buildDisplaySplashScreenModel() {
        return new CheckBoxModelAdapter(this.buildBufferedDisplaySplashScreenAdapter());
    }

    private PropertyValueModel buildBufferedDisplaySplashScreenAdapter() {
        return new BufferedPropertyValueModel(this.buildDisplaySplashScreenAdapter(), this.getPreferencesContext().getBufferTrigger());
    }

    private PropertyValueModel buildDisplaySplashScreenAdapter() {
        PreferencePropertyValueModel preferencePropertyValueModel = new PreferencePropertyValueModel(this.preferences(), "display splash screen", true);
        preferencePropertyValueModel.setConverter(BidiStringConverter.BOOLEAN_CONVERTER);
        return preferencePropertyValueModel;
    }

    private ComboBoxModel buildLookAndFeelComboBoxModel() {
        return new ComboBoxModelAdapter(this.buildLookAndFeelCollectionHolder(), this.buildBufferedLookAndFeelAdapter());
    }

    private CollectionValueModel buildLookAndFeelCollectionHolder() {
        return new ReadOnlyCollectionValueModel(this.lafInfos);
    }

    private Comparator buildLookAndFeelComparator() {
        return new Comparator(){

            public int compare(Object object, Object object2) {
                UIManager.LookAndFeelInfo lookAndFeelInfo = (UIManager.LookAndFeelInfo)object;
                UIManager.LookAndFeelInfo lookAndFeelInfo2 = (UIManager.LookAndFeelInfo)object2;
                return Collator.getInstance().compare(lookAndFeelInfo.getName(), lookAndFeelInfo2.getName());
            }
        };
    }

    private PropertyValueModel buildBufferedLookAndFeelAdapter() {
        BufferedPropertyValueModel bufferedPropertyValueModel = new BufferedPropertyValueModel(this.buildLookAndFeelAdapter(), this.getPreferencesContext().getBufferTrigger());
        return new TransformationPropertyValueModel(bufferedPropertyValueModel){

            protected Object reverseTransform(Object object) {
                UIManager.LookAndFeelInfo lookAndFeelInfo = (UIManager.LookAndFeelInfo)object;
                return lookAndFeelInfo.getClassName();
            }

            protected Object transform(Object object) {
                String string = (String)object;
                return GeneralPreferencesPage.this.getLookAndFeelInfo(string);
            }
        };
    }

    private PropertyValueModel buildLookAndFeelAdapter() {
        String string = UIManager.getLookAndFeel().getClass().getName();
        return new PreferencePropertyValueModel(this.preferences(), "look and feel", (Object)string);
    }

    private ListCellRenderer buildLookAndFeelListCellRenderer() {
        return new SimpleListCellRenderer(){
            private static final long serialVersionUID = 1L;

            protected String buildText(Object object) {
                UIManager.LookAndFeelInfo lookAndFeelInfo = (UIManager.LookAndFeelInfo)object;
                return lookAndFeelInfo == null ? null : lookAndFeelInfo.getName();
            }
        };
    }

    private JComponent buildRecentFilesSizeSpinner() {
        JComponent jComponent = this.buildLabeledSpinnerNumber("PREFERENCES.GENERAL.RECENT_FILES_SIZE", this.buildRecentFilesSizeSpinnerModel());
        JSpinner jSpinner = (JSpinner)jComponent.getComponent(1);
        ((JSpinner.DefaultEditor)jSpinner.getEditor()).getTextField().setEditable(false);
        return jComponent;
    }

    private SpinnerNumberModel buildRecentFilesSizeSpinnerModel() {
        return new NumberSpinnerModelAdapter(this.buildBufferedRecentFilesSizeAdapter(), 0, 9, 1, 4);
    }

    private PropertyValueModel buildBufferedRecentFilesSizeAdapter() {
        return new BufferedPropertyValueModel(this.buildRecentFilesSizeAdapter(), this.getPreferencesContext().getBufferTrigger());
    }

    private PropertyValueModel buildRecentFilesSizeAdapter() {
        PreferencePropertyValueModel preferencePropertyValueModel = new PreferencePropertyValueModel(this.preferences(), "recent files max size", 4);
        preferencePropertyValueModel.setConverter(this.buildRecentFilesSizeConverter());
        return preferencePropertyValueModel;
    }

    private BidiStringConverter buildRecentFilesSizeConverter() {
        return new BidiStringConverter(){

            public String convertToString(Object object) {
                return object == null ? null : ((Integer)object).toString();
            }

            public Object convertToObject(String string) {
                if (string == null) {
                    return new Integer(4);
                }
                Integer n = new Integer(string);
                if (n < 0 || n > 9) {
                    return new Integer(4);
                }
                return n;
            }

            public String toString() {
                return "RecentFilesManager-IntegerStringConverter";
            }
        };
    }

    private Document buildProxyHostDocumentAdapter() {
        return new DocumentAdapter(this.buildBufferedProxyHostAdapter());
    }

    private PropertyValueModel buildBufferedProxyHostAdapter() {
        return new BufferedPropertyValueModel(this.buildProxyHostAdapter(), this.getPreferencesContext().getBufferTrigger());
    }

    private PropertyValueModel buildProxyHostAdapter() {
        return new PreferencePropertyValueModel(this.preferences(), "http proxy host", (Object)"");
    }

    private Document buildProxyPortDocumentAdapter() {
        return new DocumentAdapter(this.buildBufferedProxyPortAdapter());
    }

    private PropertyValueModel buildBufferedProxyPortAdapter() {
        return new BufferedPropertyValueModel(this.buildProxyPortAdapter(), this.getPreferencesContext().getBufferTrigger());
    }

    private PropertyValueModel buildProxyPortAdapter() {
        return new PreferencePropertyValueModel(this.preferences(), "http proxy port", (Object)"80");
    }

    private Document buildNetworkConnectTimeoutDocumentAdapter() {
        return new DocumentAdapter(this.buildBufferedNetworkConnectTimeoutAdapter());
    }

    private PropertyValueModel buildBufferedNetworkConnectTimeoutAdapter() {
        return new BufferedPropertyValueModel(this.buildNetworkConnectTimeoutAdapter(), this.getPreferencesContext().getBufferTrigger());
    }

    private PropertyValueModel buildNetworkConnectTimeoutAdapter() {
        return new PreferencePropertyValueModel(this.preferences(), "network connect timeout", (Object)"10");
    }

    private Document buildNetworkReadTimeoutDocumentAdapter() {
        return new DocumentAdapter(this.buildBufferedNetworkReadTimeoutAdapter());
    }

    private PropertyValueModel buildBufferedNetworkReadTimeoutAdapter() {
        return new BufferedPropertyValueModel(this.buildNetworkReadTimeoutAdapter(), this.getPreferencesContext().getBufferTrigger());
    }

    private PropertyValueModel buildNetworkReadTimeoutAdapter() {
        return new PreferencePropertyValueModel(this.preferences(), "network read timeout", (Object)"10");
    }

    private ButtonModel buildReopenProjectsModel() {
        return new CheckBoxModelAdapter(this.buildBufferedReopenProjectsAdapter());
    }

    private PropertyValueModel buildBufferedReopenProjectsAdapter() {
        return new BufferedPropertyValueModel(this.buildReopenProjectsAdapter(), this.getPreferencesContext().getBufferTrigger());
    }

    private PropertyValueModel buildReopenProjectsAdapter() {
        PreferencePropertyValueModel preferencePropertyValueModel = new PreferencePropertyValueModel(this.preferences(), "reopen projects", true);
        preferencePropertyValueModel.setConverter(BidiStringConverter.BOOLEAN_CONVERTER);
        return preferencePropertyValueModel;
    }

    UIManager.LookAndFeelInfo getLookAndFeelInfo(String string) {
        for (UIManager.LookAndFeelInfo lookAndFeelInfo : this.lafInfos) {
            if (!lookAndFeelInfo.getClassName().equals(string)) continue;
            return lookAndFeelInfo;
        }
        return null;
    }
}

