/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.resources;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.KeyStroke;
import org.eclipse.persistence.tools.workbench.framework.resources.AcceleratorRepository;
import org.eclipse.persistence.tools.workbench.framework.resources.MissingAcceleratorException;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class DefaultAcceleratorRepository
implements AcceleratorRepository {
    private ResourceBundle resourceBundle;

    public DefaultAcceleratorRepository(String string) {
        this.initialize(string);
    }

    public DefaultAcceleratorRepository(Class clazz) {
        this(clazz.getName());
    }

    protected void initialize(String string) {
        this.resourceBundle = ResourceBundle.getBundle(string);
    }

    public boolean hasAccelerator(String string) {
        return string == null || CollectionTools.contains(this.resourceBundle.getKeys(), (Object)string);
    }

    public KeyStroke getAccelerator(String string) {
        return string == null ? null : KeyStroke.getKeyStroke(this.getString(string));
    }

    protected String getString(String string) {
        try {
            return this.resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            if (missingResourceException.getKey().equals(string)) {
                throw new MissingAcceleratorException("Missing accelerator: " + string, string);
            }
            throw missingResourceException;
        }
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.resourceBundle.getClass().getName());
    }
}

