/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.resources;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.eclipse.persistence.tools.workbench.framework.resources.IconRepository;
import org.eclipse.persistence.tools.workbench.framework.resources.IconResourceFileNameMap;
import org.eclipse.persistence.tools.workbench.framework.resources.MissingIconException;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class DefaultIconRepository
implements IconRepository {
    private IconResourceFileNameMap resourceFileNames;
    private final Map cache;

    public DefaultIconRepository() {
        this(IconResourceFileNameMap.NULL_INSTANCE);
    }

    public DefaultIconRepository(IconResourceFileNameMap iconResourceFileNameMap) {
        if (iconResourceFileNameMap == null) {
            throw new NullPointerException();
        }
        this.resourceFileNames = iconResourceFileNameMap;
        this.cache = new HashMap();
    }

    public boolean hasIcon(String string) {
        return string == null || this.cache.containsKey(string) || this.canLoadIcon(string);
    }

    public synchronized Icon getIcon(String string) {
        if (string == null) {
            return null;
        }
        Icon icon = (Icon)this.cache.get(string);
        if (icon != null) {
            return icon;
        }
        icon = this.loadIcon(string);
        this.cache.put(string, icon);
        return icon;
    }

    protected Icon loadIcon(String string) {
        String string2 = this.getResourceFileNames().getResourceFileName(string);
        URL uRL = this.getClass().getClassLoader().getResource(string2);
        if (uRL == null) {
            throw new MissingIconException("Missing icon file: " + string + " => " + string2, string);
        }
        return new ImageIcon(uRL);
    }

    protected boolean canLoadIcon(String string) {
        if (!this.getResourceFileNames().hasResourceFileName(string)) {
            return false;
        }
        String string2 = this.getResourceFileNames().getResourceFileName(string);
        return this.getClass().getClassLoader().getResource(string2) != null;
    }

    protected IconResourceFileNameMap getResourceFileNames() {
        return this.resourceFileNames;
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this);
    }
}

