/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.resources;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.persistence.tools.workbench.framework.resources.MissingMnemonicException;
import org.eclipse.persistence.tools.workbench.framework.resources.MnemonicRepository;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class DefaultMnemonicRepository
implements MnemonicRepository {
    private ResourceBundle resourceBundle;

    public DefaultMnemonicRepository(String string) {
        this.initialize(string);
    }

    public DefaultMnemonicRepository(Class clazz) {
        this(clazz.getName());
    }

    protected void initialize(String string) {
        this.resourceBundle = ResourceBundle.getBundle(string);
    }

    public boolean hasMnemonic(String string) {
        return string == null || CollectionTools.contains(this.resourceBundle.getKeys(), (Object)string);
    }

    public int getMnemonic(String string) {
        if (string == null) {
            return -1;
        }
        String string2 = this.getString(string);
        int n = string2.indexOf(38);
        if (n == -1 || n == string2.length() - 1) {
            return -1;
        }
        return Character.toUpperCase(string2.charAt(n + 1));
    }

    public int getMnemonicIndex(String string) {
        return this.getString(string).indexOf(38);
    }

    protected String getString(String string) {
        try {
            return this.resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            if (missingResourceException.getKey().equals(string)) {
                throw new MissingMnemonicException("Missing mnemonic: " + string, string);
            }
            throw missingResourceException;
        }
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.resourceBundle.getClass().getName());
    }
}

