/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.resources;

import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.eclipse.persistence.tools.workbench.framework.resources.AcceleratorRepository;
import org.eclipse.persistence.tools.workbench.framework.resources.DefaultAcceleratorRepository;
import org.eclipse.persistence.tools.workbench.framework.resources.DefaultIconRepository;
import org.eclipse.persistence.tools.workbench.framework.resources.DefaultMnemonicRepository;
import org.eclipse.persistence.tools.workbench.framework.resources.DefaultStringRepository;
import org.eclipse.persistence.tools.workbench.framework.resources.IconRepository;
import org.eclipse.persistence.tools.workbench.framework.resources.IconResourceFileNameMap;
import org.eclipse.persistence.tools.workbench.framework.resources.MnemonicRepository;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.resources.StringRepository;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class DefaultResourceRepository
implements ResourceRepository {
    private StringRepository stringRepository;
    private MnemonicRepository mnemonicRepository;
    private AcceleratorRepository acceleratorRepository;
    private IconRepository iconRepository;

    public DefaultResourceRepository(Class clazz) {
        this(clazz, null);
    }

    public DefaultResourceRepository(IconResourceFileNameMap iconResourceFileNameMap) {
        this(null, iconResourceFileNameMap);
    }

    public DefaultResourceRepository(Class clazz, IconResourceFileNameMap iconResourceFileNameMap) {
        this.stringRepository = this.buildStringRepository(clazz);
        this.mnemonicRepository = this.buildMnemonicRepository(clazz);
        this.acceleratorRepository = this.buildAcceleratorRepository(clazz);
        this.iconRepository = this.buildIconRepository(iconResourceFileNameMap);
    }

    protected StringRepository buildStringRepository(Class clazz) {
        return clazz == null ? StringRepository.NULL_INSTANCE : new DefaultStringRepository(clazz);
    }

    protected MnemonicRepository buildMnemonicRepository(Class clazz) {
        return clazz == null ? MnemonicRepository.NULL_INSTANCE : new DefaultMnemonicRepository(clazz);
    }

    protected AcceleratorRepository buildAcceleratorRepository(Class clazz) {
        return clazz == null ? AcceleratorRepository.NULL_INSTANCE : new DefaultAcceleratorRepository(clazz);
    }

    protected IconRepository buildIconRepository(IconResourceFileNameMap iconResourceFileNameMap) {
        return iconResourceFileNameMap == null ? IconRepository.NULL_INSTANCE : new DefaultIconRepository(iconResourceFileNameMap);
    }

    public boolean hasString(String string) {
        return this.stringRepository.hasString(string);
    }

    public String getString(String string) {
        return this.stringRepository.getString(string);
    }

    public String getString(String string, Object object) {
        return this.stringRepository.getString(string, object);
    }

    public String getString(String string, Object object, Object object2) {
        return this.stringRepository.getString(string, object, object2);
    }

    public String getString(String string, Object object, Object object2, Object object3) {
        return this.stringRepository.getString(string, object, object2, object3);
    }

    public String getString(String string, Object[] objectArray) {
        return this.stringRepository.getString(string, objectArray);
    }

    public boolean hasMnemonic(String string) {
        return this.mnemonicRepository.hasMnemonic(string);
    }

    public int getMnemonic(String string) {
        return this.mnemonicRepository.getMnemonic(string);
    }

    public int getMnemonicIndex(String string) {
        return this.mnemonicRepository.getMnemonicIndex(string);
    }

    public boolean hasAccelerator(String string) {
        return this.acceleratorRepository.hasAccelerator(string);
    }

    public KeyStroke getAccelerator(String string) {
        return this.acceleratorRepository.getAccelerator(string);
    }

    public boolean hasIcon(String string) {
        return this.iconRepository.hasIcon(string);
    }

    public Icon getIcon(String string) {
        return this.iconRepository.getIcon(string);
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this);
    }
}

