/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.ui.chooser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.DisplayableStringConverter;
import org.eclipse.persistence.tools.workbench.uitools.FilteringListPanel;
import org.eclipse.persistence.tools.workbench.uitools.app.TreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.DisplayableListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public class NodeChooserDialog
extends AbstractDialog {
    private ApplicationNode[] nodes;
    private FilteringListPanel filteringPanel;
    private JList pathListBox;
    private static final Object[] EMPTY_LIST = new Object[0];

    public static NodeChooserDialog createDialog(ApplicationNode[] applicationNodeArray, WorkbenchContext workbenchContext) {
        Window window = workbenchContext.getCurrentWindow();
        if (window instanceof Dialog) {
            return new NodeChooserDialog(applicationNodeArray, workbenchContext, (Dialog)window);
        }
        return new NodeChooserDialog(applicationNodeArray, workbenchContext);
    }

    private static String title(ApplicationContext applicationContext) {
        return applicationContext.getResourceRepository().getString("NODE_CHOOSER_DIALOG.TITLE");
    }

    private NodeChooserDialog(ApplicationNode[] applicationNodeArray, WorkbenchContext workbenchContext) {
        super(workbenchContext, NodeChooserDialog.title(workbenchContext.getApplicationContext()));
        this.initialize(applicationNodeArray);
    }

    private NodeChooserDialog(ApplicationNode[] applicationNodeArray, WorkbenchContext workbenchContext, Dialog dialog) {
        super(workbenchContext, NodeChooserDialog.title(workbenchContext.getApplicationContext()), dialog);
        this.initialize(applicationNodeArray);
    }

    private void initialize(ApplicationNode[] applicationNodeArray) {
        this.nodes = applicationNodeArray;
        Arrays.sort(this.nodes);
    }

    protected Component buildMainPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.filteringPanel = new FilteringListPanel(this.nodes, null, DisplayableStringConverter.instance());
        this.configureLabel(this.filteringPanel.getTextFieldLabel(), "NODE_CHOOSER_DIALOG.TEXT_FIELD_LABEL");
        this.configureLabel(this.filteringPanel.getListBoxLabel(), "NODE_CHOOSER_DIALOG.NODE_LIST_BOX_LABEL");
        this.filteringPanel.setListBoxCellRenderer(new DisplayableListCellRenderer());
        this.filteringPanel.getListBox().getSelectionModel().addListSelectionListener(this.buildNodeListSelectionListener());
        this.filteringPanel.getListBox().addMouseListener(this.buildDoubleClickMouseListener());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 3.0;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.filteringPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel();
        this.configureLabel(jLabel, "NODE_CHOOSER_DIALOG.PATH_LIST_BOX_LABEL");
        jLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        jPanel2.add((Component)jLabel, "First");
        this.pathListBox = SwingComponentFactory.buildList();
        this.pathListBox.setDoubleBuffered(true);
        this.pathListBox.setCellRenderer(new DisplayableListCellRenderer());
        this.pathListBox.getSelectionModel().setSelectionMode(0);
        jLabel.setLabelFor(this.pathListBox);
        jPanel2.add((Component)new JScrollPane(this.pathListBox), "Center");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 20;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        return jPanel;
    }

    private MouseListener buildDoubleClickMouseListener() {
        return new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    NodeChooserDialog.this.clickOK();
                }
            }
        };
    }

    private void configureLabel(JLabel jLabel, String string) {
        jLabel.setText(this.resourceRepository().getString(string));
        jLabel.setDisplayedMnemonic(this.resourceRepository().getMnemonic(string));
    }

    private ListSelectionListener buildNodeListSelectionListener() {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    NodeChooserDialog.this.nodeSelectionChanged(listSelectionEvent);
                }
            }
        };
    }

    protected Action buildOKAction() {
        Action action = super.buildOKAction();
        action.setEnabled(false);
        return action;
    }

    protected String helpTopicId() {
        return "dialog.nodeChooser";
    }

    protected Component initialFocusComponent() {
        return this.filteringPanel.getTextField();
    }

    protected void prepareToShow() {
        this.setSize(350, 566);
        this.setLocationRelativeTo(this.getParent());
    }

    protected void clickOK() {
        super.clickOK();
    }

    void nodeSelectionChanged(ListSelectionEvent listSelectionEvent) {
        ApplicationNode applicationNode = (ApplicationNode)this.filteringPanel.getSelection();
        if (applicationNode == null) {
            this.pathListBox.setListData(EMPTY_LIST);
        } else {
            this.pathListBox.setListData(this.reversePathFor(applicationNode));
        }
        this.getOKAction().setEnabled(applicationNode != null);
    }

    private Object[] reversePathFor(ApplicationNode applicationNode) {
        TreeNodeValueModel[] treeNodeValueModelArray = applicationNode.path();
        Object[] objectArray = new Object[treeNodeValueModelArray.length - 1];
        System.arraycopy(treeNodeValueModelArray, 0, objectArray, 0, objectArray.length);
        return CollectionTools.reverse((Object[])objectArray);
    }

    public ApplicationNode selection() {
        if (!this.wasConfirmed()) {
            throw new IllegalStateException();
        }
        return (ApplicationNode)this.filteringPanel.getSelection();
    }
}

