/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.ui.dialog;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.TextAreaDialog;
import org.eclipse.persistence.tools.workbench.utility.iterators.SingleElementIterator;

public class ExceptionDialog
extends AbstractDialog {
    private String message;
    private Throwable exception;

    public ExceptionDialog(String string, Throwable throwable, WorkbenchContext workbenchContext, String string2) {
        super(workbenchContext, string2);
        this.message = string;
        this.exception = throwable;
    }

    public ExceptionDialog(String string, Throwable throwable, WorkbenchContext workbenchContext, Dialog dialog, String string2) {
        super(workbenchContext, string2, dialog);
        this.message = string;
        this.exception = throwable;
    }

    protected Component buildMainPanel() {
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        JLabel jLabel = new JLabel();
        jLabel.setText(this.message);
        jLabel.setIcon(this.resourceRepository().getIcon("warning"));
        jLabel.setHorizontalAlignment(0);
        jPanel.add(jLabel);
        JLabel jLabel2 = new JLabel(this.exception.getClass().getName(), 0);
        jPanel.add(jLabel2);
        return jPanel;
    }

    protected String helpTopicId() {
        return "dialog.unexpectedError";
    }

    protected Iterator buildCustomActions() {
        Action action = this.buildStackTraceAction();
        return new SingleElementIterator((Object)action);
    }

    private Action buildStackTraceAction() {
        return new AbstractAction(this.buildStackTraceText()){

            public void actionPerformed(ActionEvent actionEvent) {
                ExceptionDialog.this.displayStackTrace();
            }
        };
    }

    protected String buildStackTraceText() {
        return this.resourceRepository().getString("STACK_TRACE");
    }

    protected void displayStackTrace() {
        TextAreaDialog textAreaDialog = new TextAreaDialog(this.exception, this.helpTopicId(), this.getWorkbenchContext(), (Dialog)this);
        textAreaDialog.setTitle(this.buildStackTraceText());
        textAreaDialog.show();
    }
}

