/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.uitools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import org.eclipse.persistence.tools.workbench.framework.resources.DefaultResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.uitools.UIToolsResourceBundle;
import org.eclipse.persistence.tools.workbench.utility.io.FileTools;

public class FileChooser
extends JFileChooser {
    boolean convertToRelativePath;
    private File rootFile;
    private boolean dialogIsVisible;

    public FileChooser() {
        this((File)null, (File)null);
    }

    public FileChooser(File file) {
        this(file, (File)null);
    }

    public FileChooser(File file, File file2) {
        super(file);
        this.rootFile = file2;
        this.convertToRelativePath = this.rootFile != null;
    }

    protected JDialog createDialog(Component component) throws HeadlessException {
        JDialog jDialog = super.createDialog(component);
        if (this.rootFile != null) {
            this.addRelativeCheckBoxTo(jDialog.getContentPane());
        }
        return jDialog;
    }

    private void addRelativeCheckBoxTo(Container container) {
        DefaultResourceRepository defaultResourceRepository = new DefaultResourceRepository(UIToolsResourceBundle.class);
        JCheckBox jCheckBox = new JCheckBox(defaultResourceRepository.getString("FILECHOOSER_MAKE_RELATIVE_CHECKBOX", this.rootFile.getPath()));
        jCheckBox.setSelected(this.convertToRelativePath);
        jCheckBox.setMnemonic(defaultResourceRepository.getMnemonic("FILECHOOSER_MAKE_RELATIVE_CHECKBOX"));
        jCheckBox.setDisplayedMnemonicIndex(defaultResourceRepository.getMnemonicIndex("FILECHOOSER_MAKE_RELATIVE_CHECKBOX"));
        jCheckBox.addActionListener(this.buildActionListener());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        jPanel.add((Component)jCheckBox, "Before");
        container.add((Component)jPanel, "Last");
    }

    private ActionListener buildActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileChooser.this.convertToRelativePath = ((JCheckBox)actionEvent.getSource()).isSelected();
            }
        };
    }

    public int showDialog(Component component, String string) throws HeadlessException {
        this.dialogIsVisible = true;
        int n = super.showDialog(component, string);
        this.dialogIsVisible = false;
        return n;
    }

    public File getSelectedFile() {
        File file = super.getSelectedFile();
        file = this.checkForDuplicateEntry(file);
        return this.convertToRelativeFile(file);
    }

    public File[] getSelectedFiles() {
        File[] fileArray = super.getSelectedFiles();
        if (fileArray.length == 1) {
            fileArray[0] = this.checkForDuplicateEntry(fileArray[0]);
        }
        return this.convertToRelativeFiles(fileArray);
    }

    private File checkForDuplicateEntry(File file) {
        if (this.getFileSelectionMode() == 2 || this.getFileSelectionMode() == 1) {
            File file2 = this.getCurrentDirectory();
            if (file != null && file.isAbsolute() && !file.exists()) {
                file = file2;
            }
        }
        return file;
    }

    public void setSelectedFile(File file) {
        super.setSelectedFile(this.convertToAbsoluteFile(file));
    }

    public void setSelectedFiles(File[] fileArray) {
        super.setSelectedFiles(this.convertToAbsoluteFiles(fileArray));
    }

    private File[] convertToRelativeFiles(File[] fileArray) {
        int n = fileArray.length;
        while (n-- > 0) {
            fileArray[n] = this.convertToRelativeFile(fileArray[n]);
        }
        return fileArray;
    }

    private File convertToRelativeFile(File file) {
        if (this.dialogIsVisible) {
            return file;
        }
        if (file == null) {
            return file;
        }
        if (this.convertToRelativePath) {
            file = new File(file.getPath());
            return FileTools.convertToRelativeFile((File)file, (File)this.rootFile);
        }
        return file;
    }

    private File[] convertToAbsoluteFiles(File[] fileArray) {
        if (fileArray == null) {
            return fileArray;
        }
        int n = fileArray.length;
        while (n-- > 0) {
            fileArray[n] = this.convertToAbsoluteFile(fileArray[n]);
        }
        return fileArray;
    }

    private File convertToAbsoluteFile(File file) {
        if (this.dialogIsVisible) {
            return file;
        }
        if (file == null) {
            return file;
        }
        if (this.convertToRelativePath) {
            return FileTools.convertToAbsoluteFile((File)file, (File)this.rootFile);
        }
        return file;
    }
}

