/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappings;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.prefs.Preferences;
import org.eclipse.persistence.tools.workbench.framework.resources.DefaultStringRepository;
import org.eclipse.persistence.tools.workbench.framework.resources.StringRepository;
import org.eclipse.persistence.tools.workbench.mappings.MappingsBundle;
import org.eclipse.persistence.tools.workbench.mappingsio.ProjectIOManager;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;

public class Generator {
    private Adapter adapter;
    private StringRepository stringRepository;

    public Generator(Adapter adapter) {
        this.adapter = adapter;
        this.stringRepository = new DefaultStringRepository(MappingsBundle.class);
    }

    protected void execute(String[] stringArray) {
        int n = 0;
        PrintStream printStream = null;
        if (stringArray.length < 2 || stringArray.length > 3) {
            System.err.println(this.stringRepository.getString("help", this.adapter.getClass().getName()));
            System.exit(1);
        }
        if (stringArray.length == 3) {
            try {
                printStream = new PrintStream(new FileOutputStream(stringArray[2]));
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
                printStream = System.err;
                n = 1;
            }
        } else {
            printStream = System.err;
        }
        n = this.execute(stringArray[0], stringArray[1], printStream);
        System.exit(n);
    }

    public int execute(String string, String string2, PrintStream printStream) {
        int n = 0;
        File file = new File(string);
        File file2 = new File(string2);
        try {
            MWProject mWProject = new ProjectIOManager().read(file, Preferences.userNodeForPackage(this.getClass()));
            mWProject.validateBranch();
            if (mWProject.hasBranchProblems()) {
                printStream.print(this.stringRepository.getString("generatingMight"));
            }
            this.adapter.export(mWProject, file2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(printStream);
            n = 1;
        }
        if (n == 0) {
            System.out.println(this.stringRepository.getString("EOJ"));
        } else {
            System.out.println(this.stringRepository.getString("generationError"));
        }
        return n;
    }

    public int execute(String string, String string2) {
        return this.execute(string, string2, System.err);
    }

    public static interface Adapter {
        public void export(MWProject var1, File var2);
    }
}

