/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractEnablableFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.AbstractApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.InterfaceDescriptorCreationException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsplugin.NewClassNameDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.MappingsApplicationNode;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.FilteringIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class CreateNewClassAction
extends AbstractEnablableFrameworkAction {
    CreateNewClassAction(WorkbenchContext workbenchContext) {
        super(workbenchContext);
    }

    protected void initialize() {
        this.initializeTextAndMnemonic("CREATE_NEW_CLASS_ACTION");
        this.initializeAccelerator("CREATE_NEW_CLASS_ACTION.accelerator");
        this.initializeToolTipText("CREATE_NEW_CLASS_ACTION.toolTipText");
        this.initializeIcon("descriptor.new");
    }

    protected void execute() {
        this.promptToCreateNewClass(this.selectedNodes()[0]);
    }

    private void promptToCreateNewClass(ApplicationNode applicationNode) {
        MWDescriptor mWDescriptor;
        MWProject mWProject = (MWProject)applicationNode.getProjectRoot().getValue();
        NewClassNameDialog newClassNameDialog = this.buildNewClassNameDialog(mWProject, applicationNode);
        newClassNameDialog.setTitle(this.resourceRepository().getString("ADD_CLASS_DIALOG_TITLE"));
        newClassNameDialog.setVisible(true);
        if (newClassNameDialog.wasCanceled()) {
            return;
        }
        String string = newClassNameDialog.className();
        this.navigatorSelectionModel().pushExpansionState();
        MWClass mWClass = mWProject.getClassRepository().typeNamed(string);
        mWClass.addZeroArgumentConstructor();
        try {
            mWDescriptor = mWProject.addDescriptorForType(mWClass);
        }
        catch (InterfaceDescriptorCreationException interfaceDescriptorCreationException) {
            throw new RuntimeException(interfaceDescriptorCreationException);
        }
        ((AbstractApplicationNode)applicationNode.getProjectRoot()).selectDescendantNodeForValue((Node)mWDescriptor, this.navigatorSelectionModel());
        this.navigatorSelectionModel().popAndRestoreExpansionState();
    }

    private NewClassNameDialog buildNewClassNameDialog(MWProject mWProject, ApplicationNode applicationNode) {
        return new NewClassNameDialog(this.buildPackageNames(mWProject), this.buildPackageName(applicationNode), mWProject, this.getWorkbenchContext());
    }

    private Collection buildPackageNames(MWProject mWProject) {
        FilteringIterator filteringIterator = new FilteringIterator(mWProject.packageNames()){

            protected boolean accept(Object object) {
                return ((String)object).length() > 0;
            }
        };
        return CollectionTools.collection((Iterator)filteringIterator);
    }

    private String buildPackageName(ApplicationNode applicationNode) {
        return ((MappingsApplicationNode)applicationNode).candidatePackageName();
    }

    protected boolean shouldBeEnabled(ApplicationNode applicationNode) {
        return false;
    }

    protected void updateEnabledState() {
        this.setEnabled(this.selectedNodes().length == 1);
    }
}

