/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db;

import java.awt.Frame;
import java.util.Collection;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractEnablableFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.WaitDialog;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWDatabase;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db.DatabaseNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db.TableImporterDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.ProjectNode;

final class AddOrRefreshTablesAction
extends AbstractEnablableFrameworkAction {
    AddOrRefreshTablesAction(WorkbenchContext workbenchContext) {
        super(workbenchContext);
    }

    protected void initialize() {
        super.initialize();
        this.initializeIcon("table.addFromDatabase");
        this.initializeTextAndMnemonic("ADD_OR_REFRESH_TABLES_ACTION");
        this.initializeToolTipText("ADD_OR_REFRESH_TABLES_ACTION.toolTipText");
    }

    protected void execute() {
        ApplicationNode[] applicationNodeArray = this.selectedProjectNodes();
        for (int i = 0; i < applicationNodeArray.length; ++i) {
            this.execute((ProjectNode)applicationNodeArray[i]);
        }
    }

    protected void execute(ProjectNode projectNode) {
        MWDatabase mWDatabase = projectNode.getProject().getDatabase();
        TableImporterDialog tableImporterDialog = new TableImporterDialog(this.getWorkbenchContext(), mWDatabase);
        tableImporterDialog.show();
        if (tableImporterDialog.wasCanceled()) {
            return;
        }
        this.startTableImporter(mWDatabase, tableImporterDialog.importsTablesFullyQualified(), tableImporterDialog.selectedTables());
    }

    protected boolean shouldBeEnabled(ApplicationNode applicationNode) {
        return ((DatabaseNode)applicationNode).getDatabase().isConnected();
    }

    protected String[] enabledPropertyNames() {
        return new String[]{"connected"};
    }

    private void startTableImporter(MWDatabase mWDatabase, boolean bl, Collection collection) {
        Thread thread = new Thread((Runnable)new TableImporter(mWDatabase, bl, collection), "Database Table Importer");
        thread.setPriority(5);
        thread.start();
    }

    private class TableImporter
    implements Runnable {
        private MWDatabase database;
        private boolean importsTablesFullyQualified;
        private Collection selectedTables;

        TableImporter(MWDatabase mWDatabase, boolean bl, Collection collection) {
            this.database = mWDatabase;
            this.importsTablesFullyQualified = bl;
            this.selectedTables = collection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            WaitDialog waitDialog = this.buildWaitDialog();
            AbstractFrameworkAction.launchLater(waitDialog);
            this.database.getValidator().pause();
            try {
                if (this.importsTablesFullyQualified) {
                    this.database.importQualifiedTablesFor(this.selectedTables);
                } else {
                    this.database.importUnqualifiedTablesFor(this.selectedTables);
                }
            }
            finally {
                this.database.getValidator().resume();
                waitDialog.dispose();
            }
        }

        private WaitDialog buildWaitDialog() {
            return new WaitDialog((Frame)this.workbenchContext().getCurrentWindow(), this.resourceRepository().getIcon("database.large"), this.resourceRepository().getString("TABLE_IMPORTATION_DIALOG.TITLE"), this.resourceRepository().getString("TABLE_IMPORTATION_MESSAGE"));
        }

        private WorkbenchContext workbenchContext() {
            return AddOrRefreshTablesAction.this.getWorkbenchContext();
        }

        private ResourceRepository resourceRepository() {
            return AddOrRefreshTablesAction.this.resourceRepository();
        }
    }
}

