/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWReference;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.generation.MWDescriptorGenerator;
import org.eclipse.persistence.tools.workbench.mappingsmodel.generation.MWRelationshipHolder;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational.MWRelationalProject;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db.DescriptorGenerationDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db.RelationshipGenerationDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.relational.RelationalProjectNode;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

final class DescriptorGenerationCoordinator {
    private WorkbenchContext context;

    DescriptorGenerationCoordinator(WorkbenchContext workbenchContext) {
        this.initialize(workbenchContext);
    }

    private void initialize(WorkbenchContext workbenchContext) {
        this.context = workbenchContext;
    }

    private Vector calculatePossibleRelationships(Collection collection) {
        Vector<MWRelationshipHolder> vector = new Vector<MWRelationshipHolder>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = ((MWTable)iterator.next()).references();
            while (iterator2.hasNext()) {
                MWReference mWReference = (MWReference)iterator2.next();
                if (!mWReference.isForeignKeyReference() || !collection.contains(mWReference.getTargetTable())) continue;
                vector.add(new MWRelationshipHolder(mWReference, false));
                vector.add(new MWRelationshipHolder(mWReference, true));
            }
        }
        return vector;
    }

    private boolean checkForProjectSave(RelationalProjectNode relationalProjectNode) {
        if (relationalProjectNode.isDirty()) {
            return this.promptToSaveProject(relationalProjectNode);
        }
        return true;
    }

    void generateClassDescriptorsForAllTables(RelationalProjectNode relationalProjectNode) {
        this.generateClassDescriptorsForTables(relationalProjectNode, CollectionTools.collection((Iterator)relationalProjectNode.getProject().getDatabase().tables()));
    }

    void generateClassDescriptorsForSelectedTables(RelationalProjectNode relationalProjectNode, Collection collection) {
        this.generateClassDescriptorsForTables(relationalProjectNode, collection);
    }

    private void generateClassDescriptorsForTables(RelationalProjectNode relationalProjectNode, Collection collection) {
        this.generateDescriptorsForTables(relationalProjectNode, collection);
    }

    private void generateDescriptorsForTables(RelationalProjectNode relationalProjectNode, Collection collection) {
        Object object;
        if (!this.checkForProjectSave(relationalProjectNode)) {
            return;
        }
        DescriptorGenerationDialog descriptorGenerationDialog = new DescriptorGenerationDialog((MWRelationalProject)relationalProjectNode.getProject(), this.context);
        descriptorGenerationDialog.show();
        if (descriptorGenerationDialog.wasCanceled()) {
            return;
        }
        Vector vector = new Vector();
        Collection collection2 = new Vector();
        boolean bl = false;
        if (!vector.isEmpty()) {
            object = new RelationshipGenerationDialog(vector, this.context);
            ((AbstractDialog)object).show();
            if (((AbstractDialog)object).wasCanceled()) {
                return;
            }
            collection2 = ((RelationshipGenerationDialog)object).getRelationshipsToCreate();
            bl = ((RelationshipGenerationDialog)object).getGenerateBidirectionalRelationships();
        }
        object = new MWDescriptorGenerator();
        object.setProject((MWRelationalProject)relationalProjectNode.getProject());
        object.setTables(collection);
        object.setPackageName(descriptorGenerationDialog.getPackageName());
        object.setGenerateMethodAccessors(descriptorGenerationDialog.getGenerateAccessors());
        object.setGenerateBidirectionalRelationships(bl);
        object.setRelationshipsToCreate(collection2);
        object.generateClassesAndDescriptors();
        String string = "generateClassesAndDescriptors";
        JOptionPane.showMessageDialog(this.context.getCurrentWindow(), this.resourceRepository().getString(string + ".message"), this.resourceRepository().getString(string + ".title"), 1);
    }

    private boolean promptToSaveProject(RelationalProjectNode relationalProjectNode) {
        int n = JOptionPane.showConfirmDialog(this.context.getCurrentWindow(), this.resourceRepository().getString("autoGeneratingClassAndDescriptor.message"), this.resourceRepository().getString("saveProject.title"), 1, 1);
        if (n == 0) {
            if (relationalProjectNode.save(null, this.context)) {
                return true;
            }
            JOptionPane.showMessageDialog(this.context.getCurrentWindow(), this.resourceRepository().getString("saveProjectError.message"), this.resourceRepository().getString("unableToCreateClassesAndDescriptors.title"), 1);
            return false;
        }
        return n != 2 && n != -1;
    }

    private ResourceRepository resourceRepository() {
        return this.context.getApplicationContext().getResourceRepository();
    }
}

