/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db;

import java.sql.SQLException;
import javax.swing.JOptionPane;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractEnablableFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWDatabase;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWLoginSpec;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db.DatabaseNode;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

final class LogInAction
extends AbstractEnablableFrameworkAction {
    LogInAction(WorkbenchContext workbenchContext) {
        super(workbenchContext);
    }

    protected void initialize() {
        super.initialize();
        this.initializeText("DATABASE_LOG_IN");
        this.initializeMnemonic("DATABASE_LOG_IN");
        this.initializeToolTipText("DATABASE_LOG_IN.toolTipText");
        this.initializeIcon("login");
    }

    protected String[] enabledPropertyNames() {
        return new String[]{"connected"};
    }

    protected boolean shouldBeEnabled(ApplicationNode applicationNode) {
        return !((MWDatabase)((DatabaseNode)applicationNode).getValue()).isConnected();
    }

    protected void execute(ApplicationNode applicationNode) {
        MWDatabase mWDatabase = (MWDatabase)applicationNode.getValue();
        if (!this.ableToLogin(mWDatabase)) {
            return;
        }
        try {
            mWDatabase.login();
        }
        catch (SQLException sQLException) {
            String string = sQLException.getMessage();
            StringBuffer stringBuffer = new StringBuffer(50);
            stringBuffer.append(string.substring(string.lastIndexOf(93) + 1));
            stringBuffer.append(StringTools.CR);
            stringBuffer.append(this.resourceRepository().getString("USER_NAME_OR_PASSWORD_COULD_BE_INVALID_MESSAGE"));
            JOptionPane.showMessageDialog(this.getWorkbenchContext().getCurrentWindow(), stringBuffer.toString(), this.resourceRepository().getString("ERROR_LOGGING_IN_TO_DATABASE.title"), 0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string = this.resourceRepository().getString("JDBC_DRIVER_ON_CLASSPATH.message");
            JOptionPane.showMessageDialog(this.getWorkbenchContext().getCurrentWindow(), this.resourceRepository().getString("DATABASE_DRIVER_NOT_FOUND.message", new Object[]{classNotFoundException.getMessage(), string, StringTools.CR}), this.resourceRepository().getString("ERROR_LOGGING_IN_TO_DATABASE.title"), 0);
        }
    }

    private boolean ableToLogin(MWDatabase mWDatabase) {
        MWLoginSpec mWLoginSpec;
        if (mWDatabase.isConnected()) {
            this.showErrorDialog(this.resourceRepository().getString("ALREADY_CONNECTED.message"));
        }
        if ((mWLoginSpec = mWDatabase.getDevelopmentLoginSpec()) == null) {
            this.showErrorDialog(this.resourceRepository().getString("YOU_MUST_DEFINE_A_DEVELOPMENT_LOGIN.message"));
            return false;
        }
        String string = mWLoginSpec.getDriverClassName();
        if (string == null || string.equals("")) {
            this.showErrorDialog(this.resourceRepository().getString("NO_DATABASE_DRIVER_SPECIFIED.message"));
            return false;
        }
        String string2 = mWLoginSpec.getURL();
        if (string2 == null || string2.equals("")) {
            this.showErrorDialog(this.resourceRepository().getString("NO_URL_SPECIFIED.message"));
            return false;
        }
        return true;
    }

    private void showErrorDialog(String string) {
        JOptionPane.showMessageDialog(this.getWorkbenchContext().getCurrentWindow(), string, this.resourceRepository().getString("ERROR_LOGGING_IN_TO_DATABASE.title"), 0);
    }
}

