/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import java.util.Vector;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorLockingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.RadioButtonModelAdapter;

public abstract class AbstractLockingPolicyPropertiesPage
extends ScrollablePropertiesPage {
    private PropertyValueModel lockingPolicyHolder;
    private PropertyValueModel lockingPolicyTypeHolder;

    public AbstractLockingPolicyPropertiesPage(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(propertyValueModel, workbenchContextHolder);
    }

    protected void initialize(PropertyValueModel propertyValueModel) {
        super.initialize(propertyValueModel);
        this.lockingPolicyHolder = this.buildLockingPolicyHolder();
        this.lockingPolicyTypeHolder = this.buildLockingPolicyTypeValueHolder();
    }

    private PropertyValueModel buildLockingPolicyHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder()){

            protected Object getValueFromSubject() {
                return ((MWMappingDescriptor)this.subject).getLockingPolicy();
            }
        };
    }

    private PropertyValueModel buildLockingPolicyTypeValueHolder() {
        return new PropertyAspectAdapter(this.buildLockingPolicyHolder(), "lockingType"){

            protected Object getValueFromSubject() {
                return ((MWDescriptorLockingPolicy)this.subject).getLockingType();
            }

            protected void setValueOnSubject(Object object) {
                ((MWDescriptorLockingPolicy)this.subject).setLockingType((String)object);
            }
        };
    }

    protected PropertyValueModel getLockingPolicyHolder() {
        return this.lockingPolicyHolder;
    }

    protected PropertyValueModel getLockingPolicyTypeHolder() {
        return this.lockingPolicyTypeHolder;
    }

    protected JRadioButton buildUseNoneButton() {
        return this.buildRadioButton("LOCKING_POLICY_NO_LOCKING", new RadioButtonModelAdapter(this.getLockingPolicyTypeHolder(), "None"));
    }

    protected JRadioButton buildUseOptimisticButton() {
        return this.buildRadioButton("LOCKING_POLICY_OPTIMISTIC_LOCKING", new RadioButtonModelAdapter(this.getLockingPolicyTypeHolder(), "Optimistic Locking"));
    }

    protected JRadioButton buildUsePessimisticButton() {
        return this.buildRadioButton("LOCKING_POLICY_PESSIMISTIC_LOCKING", new RadioButtonModelAdapter(this.getLockingPolicyTypeHolder(), "Pessimistic Locking"));
    }

    protected JPanel buildPessimisticLockingPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JCheckBox jCheckBox = this.buildWaitForLockCheckBox();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jCheckBox, gridBagConstraints);
        return jPanel;
    }

    private PropertyValueModel buildTransactionalPolicyHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder()){

            protected Object getValueFromSubject() {
                return ((MWMappingDescriptor)this.subject).getTransactionalPolicy();
            }
        };
    }

    private JCheckBox buildWaitForLockCheckBox() {
        return this.buildCheckBox("LOCKING_POLICY_WAIT_LOCK", this.buildWaitForLockCheckBoxModel());
    }

    private ButtonModel buildWaitForLockCheckBoxModel() {
        return new CheckBoxModelAdapter(this.buildWaitForLockModel());
    }

    private PropertyValueModel buildWaitForLockModel() {
        return new PropertyAspectAdapter(this.getLockingPolicyHolder(), "waitForLock"){

            protected Object getValueFromSubject() {
                return ((MWDescriptorLockingPolicy)this.subject).shouldWaitForLock();
            }

            protected void setValueOnSubject(Object object) {
                ((MWDescriptorLockingPolicy)this.subject).setWaitForLock(((Boolean)object).booleanValue());
            }
        };
    }

    protected ComponentEnabler buildPessimisticLockingPanelEnabler(Component[] componentArray) {
        TransformationPropertyValueModel transformationPropertyValueModel = new TransformationPropertyValueModel(this.getLockingPolicyTypeHolder()){

            protected Object transform(Object object) {
                return "Pessimistic Locking".equals(object);
            }
        };
        return new ComponentEnabler((ValueModel)transformationPropertyValueModel, componentArray);
    }

    protected Collection collectComponents(Container container) {
        Vector<Component> vector = new Vector<Component>();
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            vector.add(componentArray[i]);
            if (!(componentArray[i] instanceof Container)) continue;
            vector.addAll(this.collectComponents((Container)componentArray[i]));
        }
        return vector;
    }

    protected Component[] collectComponentsAsArray(Container container) {
        Collection collection = this.collectComponents(container);
        return collection.toArray(new Component[collection.size()]);
    }
}

