/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Vector;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWError;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.StatusDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.DescriptorCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.CellRendererAdapter;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

abstract class AbstractMapInheritedAttributesAction
extends AbstractFrameworkAction {
    AbstractMapInheritedAttributesAction(WorkbenchContext workbenchContext) {
        super(workbenchContext);
    }

    protected final void execute() {
        Collection collection = CollectionTools.collection((Object[])this.selectedNodes());
        Vector<StatusDialog.Status> vector = new Vector<StatusDialog.Status>();
        for (ApplicationNode applicationNode : collection) {
            MWMappingDescriptor mWMappingDescriptor = (MWMappingDescriptor)applicationNode.getValue();
            try {
                this.execute(mWMappingDescriptor);
            }
            catch (ClassNotFoundException classNotFoundException) {
                MWError mWError = new MWError("MAP_INHERITED_ATTRIBUTES_ERROR", (Object)classNotFoundException.getLocalizedMessage());
                LinkedHashMap<MWError, MWError> linkedHashMap = new LinkedHashMap<MWError, MWError>();
                linkedHashMap.put(mWError, mWError);
                StatusDialog.Status status = StatusDialog.createStatus((Object)mWMappingDescriptor, linkedHashMap);
                vector.add(status);
            }
        }
        if (!vector.isEmpty()) {
            this.showProblems(vector);
        }
    }

    protected abstract void execute(MWMappingDescriptor var1) throws ClassNotFoundException;

    private void showProblems(Vector vector) {
        StatusDialog statusDialog = new StatusDialog(this.getWorkbenchContext(), (Collection)vector, "MAP_INHERITED_ATTRIBUTES_STATUS_DIALOG_TITLE", "dialog.mapInheritedAttributes"){

            protected CellRendererAdapter buildNodeRenderer(Object object) {
                if (object instanceof MWDescriptor) {
                    return new DescriptorCellRendererAdapter(this.resourceRepository());
                }
                return super.buildNodeRenderer(object);
            }
        };
        statusDialog.setVisible(true);
    }
}

