/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWInterfaceAliasDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWTransactionalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.AdvancedPolicyChooser;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.DescriptorNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.MappingDescriptorNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.relational.TableDescriptorNode;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ReadOnlyListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.AbstractCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.CellRendererAdapter;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;
import org.eclipse.persistence.tools.workbench.utility.iterators.FilteringIterator;

public class AdvancedPolicyAction
extends AbstractFrameworkAction {
    public AdvancedPolicyAction(WorkbenchContext workbenchContext) {
        super(workbenchContext);
        this.initializeRepositoryResources();
    }

    private void initializeRepositoryResources() {
        this.initializeTextAndMnemonic("ADVANCED_PROPERTIES_MENU_ITEM");
        this.initializeToolTipText("ADVANCED_PROPERTIES_MENU_ITEM.tooltip");
        this.initializeIcon("descriptor.advancedProperties");
    }

    protected String getResourceString(String string) {
        return this.resourceRepository().getString(string);
    }

    private List buildApplicableAdvancedPolicyHolderList() {
        ArrayList<AdvancedPolicyHolder> arrayList = new ArrayList<AdvancedPolicyHolder>();
        if (this.supportsMappingDescriptorPolicies()) {
            arrayList.add(new AfterLoadingPolicyHolder());
            arrayList.add(new CopyingPolicyHolder());
            arrayList.add(new InheritencePolicyHolder());
            arrayList.add(new InstantiationPolicyHolder());
        }
        if (this.supportsEventsPolicy()) {
            arrayList.add(new EventsPolicyHolder());
        }
        if (this.supportsInterfaceAliasPolicy()) {
            arrayList.add(new InterfaceAliasPolicyHolder());
        }
        if (this.supportsTransactionalDescriptorProperties()) {
            arrayList.add(new ReturningPolicyHolder());
        }
        if (this.supportsTableDescriptorProperties()) {
            arrayList.add(new MultiTableInfoPolicyHolder());
        }
        return arrayList;
    }

    private boolean supportsEventsPolicy() {
        ApplicationNode[] applicationNodeArray = this.selectedNodes();
        for (int i = 0; i < applicationNodeArray.length; ++i) {
            if (((DescriptorNode)applicationNodeArray[i]).supportsEventsPolicy()) continue;
            return false;
        }
        return true;
    }

    private boolean supportsInterfaceAliasPolicy() {
        ApplicationNode[] applicationNodeArray = this.selectedNodes();
        for (int i = 0; i < applicationNodeArray.length; ++i) {
            if (((DescriptorNode)applicationNodeArray[i]).supportsInterfaceAliasPolicy()) continue;
            return false;
        }
        return true;
    }

    private boolean supportsMappingDescriptorPolicies() {
        return true;
    }

    private boolean supportsTransactionalDescriptorProperties() {
        ApplicationNode[] applicationNodeArray = this.selectedNodes();
        for (int i = 0; i < applicationNodeArray.length; ++i) {
            if (((DescriptorNode)applicationNodeArray[i]).supportsTransactionalDescriptorProperties()) continue;
            return false;
        }
        return true;
    }

    private boolean supportsTableDescriptorProperties() {
        ApplicationNode[] applicationNodeArray = this.selectedNodes();
        for (int i = 0; i < applicationNodeArray.length; ++i) {
            if (((DescriptorNode)applicationNodeArray[i]).isTableDescriptor()) continue;
            return false;
        }
        return true;
    }

    protected void execute() {
        List list = this.buildApplicableAdvancedPolicyHolderList();
        ListValueModel listValueModel = this.buildAdvancedPolicyListModel(list);
        Iterator iterator = this.buildSelectedItems(list.iterator());
        ObjectListSelectionModel objectListSelectionModel = this.buildSelectionModel(listValueModel, iterator);
        AdvancedPolicyChooser advancedPolicyChooser = new AdvancedPolicyChooser(this.getWorkbenchContext(), listValueModel, objectListSelectionModel, this.buildAdvancedPropertiesCellRenderer());
        advancedPolicyChooser.setVisible(true);
        if (advancedPolicyChooser.wasCanceled()) {
            return;
        }
        List<Object> list2 = Arrays.asList(objectListSelectionModel.getSelectedValues());
        for (AdvancedPolicyHolder advancedPolicyHolder : list2) {
            if (advancedPolicyHolder.initialSelectionState()) continue;
            advancedPolicyHolder.addToSelectedNodes();
        }
        for (AdvancedPolicyHolder advancedPolicyHolder : list) {
            if (list2.contains(advancedPolicyHolder) || !advancedPolicyHolder.initialSelectionState()) continue;
            advancedPolicyHolder.removeFromSelectedNodes();
        }
    }

    private ObjectListSelectionModel buildSelectionModel(ListValueModel listValueModel, Iterator iterator) {
        ListModelAdapter listModelAdapter = new ListModelAdapter(listValueModel);
        listModelAdapter.addListDataListener(new HackableListDataListener());
        ObjectListSelectionModel objectListSelectionModel = new ObjectListSelectionModel(listModelAdapter);
        objectListSelectionModel.setSelectedValues(iterator);
        return objectListSelectionModel;
    }

    private Iterator buildSelectedItems(Iterator iterator) {
        Filter filter = new Filter(){

            public boolean accept(Object object) {
                return ((AdvancedPolicyHolder)object).initialSelectionState();
            }
        };
        return new FilteringIterator(iterator, filter);
    }

    protected ListValueModel buildAdvancedPolicyListModel(List list) {
        return new SortedListValueModelAdapter(new ReadOnlyListValueModel(list), this.buildAdvancedPolicyComparator());
    }

    private CellRendererAdapter buildAdvancedPropertiesCellRenderer() {
        return new AbstractCellRendererAdapter(){

            public String buildText(Object object) {
                return ((AdvancedPolicyHolder)object).displayString();
            }
        };
    }

    private Comparator buildAdvancedPolicyComparator() {
        return new Comparator(){

            public int compare(Object object, Object object2) {
                return Collator.getInstance().compare(((AdvancedPolicyHolder)object).displayString(), ((AdvancedPolicyHolder)object2).displayString());
            }
        };
    }

    private class ReturningPolicyHolder
    implements AdvancedPolicyHolder {
        private ReturningPolicyHolder() {
        }

        public void addToSelectedNodes() {
            ApplicationNode[] applicationNodeArray = AdvancedPolicyAction.this.selectedNodes();
            for (int i = 0; i < applicationNodeArray.length; ++i) {
                MappingDescriptorNode mappingDescriptorNode = (MappingDescriptorNode)applicationNodeArray[i];
                MWTransactionalDescriptor mWTransactionalDescriptor = (MWTransactionalDescriptor)mappingDescriptorNode.getDescriptor();
                if (mWTransactionalDescriptor.getReturningPolicy().isActive()) continue;
                JOptionPane.showMessageDialog(AdvancedPolicyAction.this.getWorkbenchContext().getCurrentWindow(), AdvancedPolicyAction.this.getResourceString("NATIVE_RETURNING_NOT_SUPPORTED_ON_PLATFORM"), AdvancedPolicyAction.this.getResourceString("NATIVE_RETURNING_NOT_SUPPORTED_ON_PLATFORM_TITLE"), 1);
                mWTransactionalDescriptor.addReturningPolicy();
            }
        }

        public boolean initialSelectionState() {
            boolean bl = true;
            ApplicationNode[] applicationNodeArray = AdvancedPolicyAction.this.selectedNodes();
            for (int i = 0; i < applicationNodeArray.length; ++i) {
                MappingDescriptorNode mappingDescriptorNode = (MappingDescriptorNode)applicationNodeArray[i];
                bl &= ((MWTransactionalDescriptor)mappingDescriptorNode.getDescriptor()).getReturningPolicy().isActive();
            }
            return bl;
        }

        public void removeFromSelectedNodes() {
            ApplicationNode[] applicationNodeArray = AdvancedPolicyAction.this.selectedNodes();
            for (int i = 0; i < applicationNodeArray.length; ++i) {
                MappingDescriptorNode mappingDescriptorNode = (MappingDescriptorNode)applicationNodeArray[i];
                MWTransactionalDescriptor mWTransactionalDescriptor = (MWTransactionalDescriptor)mappingDescriptorNode.getDescriptor();
                if (!mWTransactionalDescriptor.getReturningPolicy().isActive()) continue;
                mWTransactionalDescriptor.removeReturningPolicy();
            }
        }

        public String displayString() {
            return AdvancedPolicyAction.this.getResourceString("RETURNING_ACTION");
        }
    }

    private class MultiTableInfoPolicyHolder
    implements AdvancedPolicyHolder {
        private MultiTableInfoPolicyHolder() {
        }

        public void addToSelectedNodes() {
            ApplicationNode[] applicationNodeArray = AdvancedPolicyAction.this.selectedNodes();
            for (int i = 0; i < applicationNodeArray.length; ++i) {
                MappingDescriptorNode mappingDescriptorNode = (MappingDescriptorNode)applicationNodeArray[i];
                MWTableDescriptor mWTableDescriptor = (MWTableDescriptor)mappingDescriptorNode.getDescriptor();
                if (mWTableDescriptor.getMultiTableInfoPolicy().isActive()) continue;
                mWTableDescriptor.addMultiTableInfoPolicy();
            }
        }

        public boolean initialSelectionState() {
            boolean bl = true;
            ApplicationNode[] applicationNodeArray = AdvancedPolicyAction.this.selectedNodes();
            for (int i = 0; i < applicationNodeArray.length; ++i) {
                TableDescriptorNode tableDescriptorNode = (TableDescriptorNode)applicationNodeArray[i];
                bl &= ((MWTableDescriptor)tableDescriptorNode.getDescriptor()).getMultiTableInfoPolicy().isActive();
            }
            return bl;
        }

        public void removeFromSelectedNodes() {
            ApplicationNode[] applicationNodeArray = AdvancedPolicyAction.this.selectedNodes();
            for (int i = 0; i < applicationNodeArray.length; ++i) {
                MappingDescriptorNode mappingDescriptorNode = (MappingDescriptorNode)applicationNodeArray[i];
                MWTableDescriptor mWTableDescriptor = (MWTableDescriptor)mappingDescriptorNode.getDescriptor();
                if (!mWTableDescriptor.getMultiTableInfoPolicy().isActive()) continue;
                mWTableDescriptor.removeMultiTableInfoPolicy();
            }
        }

        public String displayString() {
            return AdvancedPolicyAction.this.getResourceString("MULTI_TABLE_INFO_ACTION");
        }
    }

    private class InterfaceAliasPolicyHolder
    implements AdvancedPolicyHolder {
        private InterfaceAliasPolicyHolder() {
        }

        public void addToSelectedNodes() {
            ApplicationNode[] applicationNodeArray = AdvancedPolicyAction.this.selectedNodes();
            for (int i = 0; i < applicationNodeArray.length; ++i) {
                MappingDescriptorNode mappingDescriptorNode = (MappingDescriptorNode)applicationNodeArray[i];
                MWInterfaceAliasDescriptor mWInterfaceAliasDescriptor = (MWInterfaceAliasDescriptor)mappingDescriptorNode.getDescriptor();
                if (mWInterfaceAliasDescriptor.getInterfaceAliasPolicy().isActive()) continue;
                mWInterfaceAliasDescriptor.addInterfaceAliasPolicy();
            }
        }

        public boolean initialSelectionState() {
            boolean bl = true;
            ApplicationNode[] applicationNodeArray = AdvancedPolicyAction.this.selectedNodes();
            for (int i = 0; i < applicationNodeArray.length; ++i) {
                MappingDescriptorNode mappingDescriptorNode = (MappingDescriptorNode)applicationNodeArray[i];
                bl &= ((MWInterfaceAliasDescriptor)mappingDescriptorNode.getDescriptor()).getInterfaceAliasPolicy().isActive();
            }
            return bl;
        }

        public void removeFromSelectedNodes() {
            ApplicationNode[] applicationNodeArray = AdvancedPolicyAction.this.selectedNodes();
            for (int i = 0; i < applicationNodeArray.length; ++i) {
                MappingDescriptorNode mappingDescriptorNode = (MappingDescriptorNode)applicationNodeArray[i];
                MWInterfaceAliasDescriptor mWInterfaceAliasDescriptor = (MWInterfaceAliasDescriptor)mappingDescriptorNode.getDescriptor();
                if (!mWInterfaceAliasDescriptor.getInterfaceAliasPolicy().isActive()) continue;
                mWInterfaceAliasDescriptor.removeInterfaceAliasPolicy();
            }
        }

        public String displayString() {
            return AdvancedPolicyAction.this.getResourceString("INTERFACE_ALIAS_ACTION");
        }
    }

    public class EventsPolicyHolder
    implements AdvancedPolicyHolder {
        public void addToSelectedNodes() {
            ApplicationNode[] applicationNodeArray = AdvancedPolicyAction.this.selectedNodes();
            for (int i = 0; i < applicationNodeArray.length; ++i) {
                MappingDescriptorNode mappingDescriptorNode = (MappingDescriptorNode)applicationNodeArray[i];
                MWMappingDescriptor mWMappingDescriptor = mappingDescriptorNode.getMappingDescriptor();
                if (mWMappingDescriptor.getEventsPolicy().isActive()) continue;
                mWMappingDescriptor.addEventsPolicy();
            }
        }

        public void removeFromSelectedNodes() {
            ApplicationNode[] applicationNodeArray = AdvancedPolicyAction.this.selectedNodes();
            for (int i = 0; i < applicationNodeArray.length; ++i) {
                MappingDescriptorNode mappingDescriptorNode = (MappingDescriptorNode)applicationNodeArray[i];
                MWMappingDescriptor mWMappingDescriptor = mappingDescriptorNode.getMappingDescriptor();
                if (!mWMappingDescriptor.getEventsPolicy().isActive()) continue;
                mWMappingDescriptor.removeEventsPolicy();
            }
        }

        public boolean initialSelectionState() {
            ApplicationNode[] applicationNodeArray = AdvancedPolicyAction.this.selectedNodes();
            boolean bl = true;
            for (int i = 0; i < applicationNodeArray.length; ++i) {
                MappingDescriptorNode mappingDescriptorNode = (MappingDescriptorNode)applicationNodeArray[i];
                MWMappingDescriptor mWMappingDescriptor = mappingDescriptorNode.getMappingDescriptor();
                bl &= mWMappingDescriptor.getEventsPolicy().isActive();
            }
            return bl;
        }

        public String displayString() {
            return AdvancedPolicyAction.this.getResourceString("EVENTS_POLICY_MAPPING_DESCRIPTOR_ACTION");
        }
    }

    private class InstantiationPolicyHolder
    implements AdvancedPolicyHolder {
        private InstantiationPolicyHolder() {
        }

        public void addToSelectedNodes() {
            ApplicationNode[] applicationNodeArray = AdvancedPolicyAction.this.selectedNodes();
            for (int i = 0; i < applicationNodeArray.length; ++i) {
                MappingDescriptorNode mappingDescriptorNode = (MappingDescriptorNode)applicationNodeArray[i];
                MWMappingDescriptor mWMappingDescriptor = mappingDescriptorNode.getMappingDescriptor();
                if (mWMappingDescriptor.getInstantiationPolicy().isActive()) continue;
                mWMappingDescriptor.addInstantiationPolicy();
            }
        }

        public void removeFromSelectedNodes() {
            ApplicationNode[] applicationNodeArray = AdvancedPolicyAction.this.selectedNodes();
            for (int i = 0; i < applicationNodeArray.length; ++i) {
                MappingDescriptorNode mappingDescriptorNode = (MappingDescriptorNode)applicationNodeArray[i];
                MWMappingDescriptor mWMappingDescriptor = mappingDescriptorNode.getMappingDescriptor();
                if (!mWMappingDescriptor.getInstantiationPolicy().isActive()) continue;
                mWMappingDescriptor.removeInstantiationPolicy();
            }
        }

        public boolean initialSelectionState() {
            ApplicationNode[] applicationNodeArray = AdvancedPolicyAction.this.selectedNodes();
            boolean bl = true;
            for (int i = 0; i < applicationNodeArray.length; ++i) {
                MappingDescriptorNode mappingDescriptorNode = (MappingDescriptorNode)applicationNodeArray[i];
                MWMappingDescriptor mWMappingDescriptor = mappingDescriptorNode.getMappingDescriptor();
                bl &= mWMappingDescriptor.getInstantiationPolicy().isActive();
            }
            return bl;
        }

        public String displayString() {
            return AdvancedPolicyAction.this.getResourceString("INSTANTIATION_POLICY_MAPPING_DESCRIPTOR_ACTION");
        }
    }

    private class InheritencePolicyHolder
    implements AdvancedPolicyHolder {
        private InheritencePolicyHolder() {
        }

        public void addToSelectedNodes() {
            ApplicationNode[] applicationNodeArray = AdvancedPolicyAction.this.selectedNodes();
            for (int i = 0; i < applicationNodeArray.length; ++i) {
                MappingDescriptorNode mappingDescriptorNode = (MappingDescriptorNode)applicationNodeArray[i];
                MWMappingDescriptor mWMappingDescriptor = mappingDescriptorNode.getMappingDescriptor();
                if (mWMappingDescriptor.getInheritancePolicy().isActive()) continue;
                mWMappingDescriptor.addInheritancePolicy();
            }
        }

        public void removeFromSelectedNodes() {
            ApplicationNode[] applicationNodeArray = AdvancedPolicyAction.this.selectedNodes();
            for (int i = 0; i < applicationNodeArray.length; ++i) {
                MappingDescriptorNode mappingDescriptorNode = (MappingDescriptorNode)applicationNodeArray[i];
                MWMappingDescriptor mWMappingDescriptor = mappingDescriptorNode.getMappingDescriptor();
                if (!mWMappingDescriptor.getInheritancePolicy().isActive()) continue;
                mWMappingDescriptor.removeInheritancePolicy();
            }
        }

        public boolean initialSelectionState() {
            ApplicationNode[] applicationNodeArray = AdvancedPolicyAction.this.selectedNodes();
            boolean bl = true;
            for (int i = 0; i < applicationNodeArray.length; ++i) {
                MappingDescriptorNode mappingDescriptorNode = (MappingDescriptorNode)applicationNodeArray[i];
                MWMappingDescriptor mWMappingDescriptor = mappingDescriptorNode.getMappingDescriptor();
                bl &= mWMappingDescriptor.getInheritancePolicy().isActive();
            }
            return bl;
        }

        public String displayString() {
            return AdvancedPolicyAction.this.getResourceString("INHERITANCE_POLICY_MAPPING_DESCRIPTOR_ACTION");
        }
    }

    private class AfterLoadingPolicyHolder
    implements AdvancedPolicyHolder {
        private AfterLoadingPolicyHolder() {
        }

        public void addToSelectedNodes() {
            ApplicationNode[] applicationNodeArray = AdvancedPolicyAction.this.selectedNodes();
            for (int i = 0; i < applicationNodeArray.length; ++i) {
                MappingDescriptorNode mappingDescriptorNode = (MappingDescriptorNode)applicationNodeArray[i];
                MWMappingDescriptor mWMappingDescriptor = mappingDescriptorNode.getMappingDescriptor();
                if (mWMappingDescriptor.getAfterLoadingPolicy().isActive()) continue;
                mWMappingDescriptor.addAfterLoadingPolicy();
            }
        }

        public void removeFromSelectedNodes() {
            ApplicationNode[] applicationNodeArray = AdvancedPolicyAction.this.selectedNodes();
            for (int i = 0; i < applicationNodeArray.length; ++i) {
                MappingDescriptorNode mappingDescriptorNode = (MappingDescriptorNode)applicationNodeArray[i];
                MWMappingDescriptor mWMappingDescriptor = mappingDescriptorNode.getMappingDescriptor();
                if (!mWMappingDescriptor.getAfterLoadingPolicy().isActive()) continue;
                mWMappingDescriptor.removeAfterLoadingPolicy();
            }
        }

        public boolean initialSelectionState() {
            ApplicationNode[] applicationNodeArray = AdvancedPolicyAction.this.selectedNodes();
            boolean bl = true;
            for (int i = 0; i < applicationNodeArray.length; ++i) {
                MappingDescriptorNode mappingDescriptorNode = (MappingDescriptorNode)applicationNodeArray[i];
                MWMappingDescriptor mWMappingDescriptor = mappingDescriptorNode.getMappingDescriptor();
                bl &= mWMappingDescriptor.getAfterLoadingPolicy().isActive();
            }
            return bl;
        }

        public String displayString() {
            return AdvancedPolicyAction.this.getResourceString("AFTER_LOAD_POLICY_MAPPING_DESCRIPTOR_ACTION");
        }
    }

    private class CopyingPolicyHolder
    implements AdvancedPolicyHolder {
        private CopyingPolicyHolder() {
        }

        public void addToSelectedNodes() {
            ApplicationNode[] applicationNodeArray = AdvancedPolicyAction.this.selectedNodes();
            for (int i = 0; i < applicationNodeArray.length; ++i) {
                MappingDescriptorNode mappingDescriptorNode = (MappingDescriptorNode)applicationNodeArray[i];
                MWMappingDescriptor mWMappingDescriptor = mappingDescriptorNode.getMappingDescriptor();
                if (mWMappingDescriptor.getCopyPolicy().isActive()) continue;
                mWMappingDescriptor.addCopyPolicy();
            }
        }

        public void removeFromSelectedNodes() {
            ApplicationNode[] applicationNodeArray = AdvancedPolicyAction.this.selectedNodes();
            for (int i = 0; i < applicationNodeArray.length; ++i) {
                MappingDescriptorNode mappingDescriptorNode = (MappingDescriptorNode)applicationNodeArray[i];
                MWMappingDescriptor mWMappingDescriptor = mappingDescriptorNode.getMappingDescriptor();
                if (!mWMappingDescriptor.getCopyPolicy().isActive()) continue;
                mWMappingDescriptor.removeCopyPolicy();
            }
        }

        public boolean initialSelectionState() {
            ApplicationNode[] applicationNodeArray = AdvancedPolicyAction.this.selectedNodes();
            boolean bl = true;
            for (int i = 0; i < applicationNodeArray.length; ++i) {
                MappingDescriptorNode mappingDescriptorNode = (MappingDescriptorNode)applicationNodeArray[i];
                MWMappingDescriptor mWMappingDescriptor = mappingDescriptorNode.getMappingDescriptor();
                bl &= mWMappingDescriptor.getCopyPolicy().isActive();
            }
            return bl;
        }

        public String displayString() {
            return AdvancedPolicyAction.this.getResourceString("COPY_POLICY_MAPPING_DESCRIPTOR_ACTION");
        }
    }

    private class HackableListDataListener
    implements ListDataListener {
        private HackableListDataListener() {
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
        }
    }

    protected static interface AdvancedPolicyHolder {
        public void addToSelectedNodes();

        public void removeFromSelectedNodes();

        public boolean initialSelectionState();

        public String displayString();
    }
}

