/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.Vector;
import javax.swing.Icon;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.resources.StringRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.DescriptorCreationFailureContainer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.DescriptorCreationFailureEvent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.StatusDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.UiDescriptorBundle;
import org.eclipse.persistence.tools.workbench.uitools.cell.AbstractCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.CellRendererAdapter;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public class DescriptorCreationFailuresDialog
extends StatusDialog {
    private final DescriptorCreationFailureContainer failures;

    public DescriptorCreationFailuresDialog(DescriptorCreationFailureContainer descriptorCreationFailureContainer, WorkbenchContext workbenchContext) {
        super(workbenchContext.buildExpandedResourceRepositoryContext(UiDescriptorBundle.class), DescriptorCreationFailuresDialog.buildStatus(descriptorCreationFailureContainer), "ERROR_CREATING_DESCRIPTORS_TITLE", "XML_PROJECTS_DONT_SUPPORT_INTERFACE_DESCRIPTORS_MESSAGE", "dialog.descriptorsNotCreated");
        this.failures = descriptorCreationFailureContainer;
    }

    private static Collection buildStatus(DescriptorCreationFailureContainer descriptorCreationFailureContainer) {
        SortedSet sortedSet = CollectionTools.sortedSet((Iterator)descriptorCreationFailureContainer.failureEvents(), (Comparator)new Comparator(){

            public int compare(Object object, Object object2) {
                DescriptorCreationFailureEvent descriptorCreationFailureEvent = (DescriptorCreationFailureEvent)object;
                DescriptorCreationFailureEvent descriptorCreationFailureEvent2 = (DescriptorCreationFailureEvent)object2;
                return descriptorCreationFailureEvent.getClassName().compareTo(descriptorCreationFailureEvent2.getClassName());
            }
        });
        Vector<StatusDialog.Status> vector = new Vector<StatusDialog.Status>(sortedSet.size());
        for (DescriptorCreationFailureEvent descriptorCreationFailureEvent : sortedSet) {
            Error error = new Error(descriptorCreationFailureEvent);
            StatusDialog.Status status = StatusDialog.createStatus((Object)descriptorCreationFailureEvent.getClassName(), Collections.singletonList(error));
            vector.add(status);
        }
        return vector;
    }

    protected CellRendererAdapter buildNodeRenderer(Object object) {
        if (object instanceof String) {
            return new ClassNameCellRendererAdapter();
        }
        if (object instanceof Error) {
            return new ErrorCellRendererAdapter();
        }
        return super.buildNodeRenderer(object);
    }

    protected boolean preConfirm() {
        Iterator iterator = this.failures.failureEvents();
        while (iterator.hasNext()) {
            DescriptorCreationFailureEvent descriptorCreationFailureEvent = (DescriptorCreationFailureEvent)iterator.next();
            Object object = descriptorCreationFailureEvent.getSource();
            if (!(object instanceof MWDescriptor)) continue;
            ((MWDescriptor)object).getProject().removeDescriptor((MWDescriptor)object);
        }
        return super.preConfirm();
    }

    private class ErrorCellRendererAdapter
    extends AbstractCellRendererAdapter {
        private ErrorCellRendererAdapter() {
        }

        public Icon buildIcon(Object object) {
            return DescriptorCreationFailuresDialog.this.resourceRepository().getIcon("error");
        }

        public String buildText(Object object) {
            return ((Error)object).getErrorMessage(DescriptorCreationFailuresDialog.this.resourceRepository());
        }
    }

    private static class Error {
        private String errorMessage;
        private final DescriptorCreationFailureEvent event;

        Error(DescriptorCreationFailureEvent descriptorCreationFailureEvent) {
            this.event = descriptorCreationFailureEvent;
        }

        private String buildErrorMessage(StringRepository stringRepository) {
            return stringRepository.getString(this.event.getResourceStringKey());
        }

        public String getErrorMessage(StringRepository stringRepository) {
            if (this.errorMessage == null) {
                this.errorMessage = this.buildErrorMessage(stringRepository);
            }
            return this.errorMessage;
        }
    }

    protected class ClassNameCellRendererAdapter
    extends AbstractCellRendererAdapter {
        protected ClassNameCellRendererAdapter() {
        }

        public Icon buildIcon(Object object) {
            return DescriptorCreationFailuresDialog.this.resourceRepository().getIcon("class.public");
        }

        public String buildText(Object object) {
            String string = (String)object;
            if (string.indexOf(".") == -1) {
                return string + " " + DescriptorCreationFailuresDialog.this.resourceRepository().getString("DEFAULT_PACKAGE");
            }
            return ClassTools.shortNameForClassNamed((String)string) + " (" + ClassTools.packageNameForClassNamed((String)string) + ")";
        }
    }
}

