/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethodParameter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.ClassCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ClassChooserTools;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.ZeroArgConstructorPreference;
import org.eclipse.persistence.tools.workbench.uitools.app.ListAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValuePropertyPropertyValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ColumnAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.NumberSpinnerModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.TableModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableTableCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.SpinnerTableCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.TableCellEditorAdapter;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.Model;

final class MethodParametersPanel
extends AbstractPanel {
    private PropertyValueModel methodHolder;
    private ObjectListSelectionModel rowSelectionModel;
    private ListValueModel paramatersHolder;
    private JButton removeParameterButton;

    WorkbenchContext workbenchContext() {
        return this.getWorkbenchContext();
    }

    MethodParametersPanel(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(workbenchContextHolder);
        this.methodHolder = propertyValueModel;
        this.initialize();
        this.initializeLayout();
    }

    private void initialize() {
        this.paramatersHolder = this.buildParametersAdapter();
        this.rowSelectionModel = this.buildRowSelectionModel();
    }

    private ObjectListSelectionModel buildRowSelectionModel() {
        ObjectListSelectionModel objectListSelectionModel = new ObjectListSelectionModel(new ListModelAdapter(this.paramatersHolder));
        objectListSelectionModel.addListSelectionListener(this.buildRowSelectionListener());
        return objectListSelectionModel;
    }

    private ListSelectionListener buildRowSelectionListener() {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    MethodParametersPanel.this.removeParameterButton.setEnabled(MethodParametersPanel.this.rowSelectionModel.getSelectedValue() != null);
                }
            }
        };
    }

    private ListValueModel buildParametersAdapter() {
        return new ListAspectAdapter(this.methodHolder, "methodParameters"){

            protected ListIterator getValueFromSubject() {
                return ((MWMethod)this.subject).methodParameters();
            }

            protected int sizeFromSubject() {
                return ((MWMethod)this.subject).methodParametersSize();
            }
        };
    }

    MWMethod getMethod() {
        return (MWMethod)this.methodHolder.getValue();
    }

    private MWClass getMWClass() {
        return (MWClass)this.getMethod().getMWParent();
    }

    private Iterator selectedParameters() {
        return CollectionTools.iterator((Object[])this.rowSelectionModel.getSelectedValues());
    }

    protected void initializeLayout() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        MethodParametersPanel methodParametersPanel = this;
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 5, 0));
        JButton jButton = this.buildButton("ADD_PARAMETER");
        jButton.addActionListener(new AddParameterAction());
        jButton.setEnabled(false);
        this.methodHolder.addPropertyChangeListener("value", this.buildMethodListener(jButton));
        jPanel.add(jButton);
        this.removeParameterButton = this.buildButton("REMOVE_PARAMETER");
        this.removeParameterButton.addActionListener(new RemoveParameterAction());
        this.removeParameterButton.setEnabled(false);
        jPanel.add(this.removeParameterButton);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        methodParametersPanel.add((Component)jPanel, gridBagConstraints);
        JTable jTable = this.buildParametersTable();
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.getViewport().setBackground(jTable.getBackground());
        jScrollPane.getViewport().setPreferredSize(new Dimension(40, 30));
        jTable.addPropertyChangeListener("enabled", new PropertyChangeHandler(jScrollPane));
        this.methodHolder.addPropertyChangeListener("value", this.buildMethodListener(jTable));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        methodParametersPanel.add((Component)jScrollPane, gridBagConstraints);
    }

    private JTable buildParametersTable() {
        JTable jTable = SwingComponentFactory.buildTable(this.buildParametersTableModel(), this.rowSelectionModel);
        int n = 20;
        TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(this.buildTypeRenderer());
        tableColumn = jTable.getColumnModel().getColumn(1);
        SpinnerTableCellRenderer spinnerTableCellRenderer = this.buildNumberSpinnerRenderer();
        tableColumn.setCellRenderer(spinnerTableCellRenderer);
        tableColumn.setCellEditor(new TableCellEditorAdapter(this.buildNumberSpinnerRenderer()));
        n = Math.max(n, spinnerTableCellRenderer.getPreferredHeight());
        jTable.setRowHeight(n);
        return jTable;
    }

    private SpinnerTableCellRenderer buildNumberSpinnerRenderer() {
        return new SpinnerTableCellRenderer(new NumberSpinnerModelAdapter((PropertyValueModel)new SimplePropertyValueModel(), new Integer(0), null, new Integer(1), new Integer(0)));
    }

    private TableCellRenderer buildTypeRenderer() {
        return new AdaptableTableCellRenderer(new ClassCellRendererAdapter(this.resourceRepository()));
    }

    private TableModel buildParametersTableModel() {
        return new TableModelAdapter(this.paramatersHolder, this.buildParametersTableColumnAdapter());
    }

    private ColumnAdapter buildParametersTableColumnAdapter() {
        return new ParametersColumnAdapter(this.resourceRepository());
    }

    private void optionallyAddZeroArgumentConstructor() {
        ZeroArgConstructorPreference.optionallyAddZeroArgumentConstructor(this.getMWClass(), this.getWorkbenchContext());
    }

    protected void removeSelectedMethodParameters() {
        this.getMethod().removeMethodParameters(this.selectedParameters());
    }

    private PropertyChangeListener buildMethodListener(final Component component) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                component.setEnabled(MethodParametersPanel.this.getMethod() != null);
            }
        };
    }

    private static class ParametersColumnAdapter
    implements ColumnAdapter {
        private ResourceRepository resourceRepository;
        public static final int COLUMN_COUNT = 2;
        public static final int TYPE_COLUMN = 0;
        public static final int DIMENSIONALITY_COLUMN = 1;
        private static final String[] COLUMN_NAME_KEYS = new String[]{"TYPE_COLUMN_HEADER", "DIMENSIONALITY_COLUMN_HEADER"};

        private ParametersColumnAdapter(ResourceRepository resourceRepository) {
            this.resourceRepository = resourceRepository;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            return this.resourceRepository.getString(COLUMN_NAME_KEYS[n]);
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return Object.class;
                }
                case 1: {
                    return Integer.class;
                }
            }
            return Object.class;
        }

        public boolean isColumnEditable(int n) {
            return n != 0;
        }

        public PropertyValueModel[] cellModels(Object object) {
            MWMethodParameter mWMethodParameter = (MWMethodParameter)object;
            PropertyValueModel[] propertyValueModelArray = new PropertyValueModel[]{this.buildTypeAdapter(mWMethodParameter), this.buildDimensionalityAdapter(mWMethodParameter)};
            return propertyValueModelArray;
        }

        private PropertyValueModel buildTypeAdapter(MWMethodParameter mWMethodParameter) {
            PropertyAspectAdapter propertyAspectAdapter = new PropertyAspectAdapter("type", (Model)mWMethodParameter){

                protected Object getValueFromSubject() {
                    return ((MWMethodParameter)this.subject).getType();
                }

                protected void setValueOnSubject(Object object) {
                    ((MWMethodParameter)this.subject).setType((MWClass)object);
                }
            };
            return new ValuePropertyPropertyValueModelAdapter((PropertyValueModel)propertyAspectAdapter, "name");
        }

        private PropertyValueModel buildDimensionalityAdapter(MWMethodParameter mWMethodParameter) {
            return new PropertyAspectAdapter("dimensionality", (Model)mWMethodParameter){

                protected Object getValueFromSubject() {
                    return new Integer(((MWMethodParameter)this.subject).getDimensionality());
                }

                protected void setValueOnSubject(Object object) {
                    ((MWMethodParameter)this.subject).setDimensionality(((Integer)object).intValue());
                }
            };
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private final JScrollPane scrollPane;

        private PropertyChangeHandler(JScrollPane jScrollPane) {
            this.scrollPane = jScrollPane;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JTable jTable = (JTable)this.scrollPane.getViewport().getView();
            if (jTable.isEnabled()) {
                this.scrollPane.getViewport().setBackground(jTable.getBackground());
            } else {
                this.scrollPane.getViewport().setBackground(UIManager.getColor("control"));
            }
        }
    }

    private class RemoveParameterAction
    implements ActionListener {
        private RemoveParameterAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MethodParametersPanel.this.removeSelectedMethodParameters();
        }
    }

    private class AddParameterAction
    implements ActionListener {
        private AddParameterAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MWClass mWClass = ClassChooserTools.promptForType(MethodParametersPanel.this.getMethod().getRepository(), ClassChooserTools.buildDeclarableNonVoidFilter(), MethodParametersPanel.this.workbenchContext());
            if (mWClass == null) {
                return;
            }
            if (MethodParametersPanel.this.getMethod().isZeroArgumentConstructor()) {
                MethodParametersPanel.this.getMethod().addMethodParameter(mWClass);
                MethodParametersPanel.this.optionallyAddZeroArgumentConstructor();
            } else if (mWClass.isVoid()) {
                JOptionPane.showMessageDialog(MethodParametersPanel.this.currentWindow(), MethodParametersPanel.this.resourceRepository().getString("METHOD_PARAMETER_TYPE_VOID_WARNING.message"), MethodParametersPanel.this.resourceRepository().getString("METHOD_PARAMETER_TYPE_VOID_WARNING.title"), 2);
            } else {
                MethodParametersPanel.this.getMethod().addMethodParameter(mWClass);
            }
        }
    }
}

