/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AccessibleTitledPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWDataField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWReturningPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWReturningPolicyInsertFieldReturnOnlyFlag;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValuePropertyPropertyValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ColumnAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.TableModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.CheckBoxTableCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleTableCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.TableCellEditorAdapter;
import org.eclipse.persistence.tools.workbench.utility.Model;

public abstract class ReturningInsertFieldsPanel
extends AbstractSubjectPanel {
    private TableModel tableModel;
    private ListValueModel sortedFieldsAdapter;
    private ObjectListSelectionModel rowSelectionModel;
    private Action removeAction;

    protected ReturningInsertFieldsPanel(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super((ValueModel)propertyValueModel, workbenchContextHolder);
    }

    protected void initializeLayout() {
        this.sortedFieldsAdapter = this.buildSortedInsertFieldReturnOnlyFlagsAdapter();
        this.tableModel = this.buildTableModel();
        this.rowSelectionModel = this.buildRowSelectionModel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = this.buildButtonPanel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)jPanel, gridBagConstraints);
        JComponent jComponent = this.buildInsertPanel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)jComponent, gridBagConstraints);
    }

    private JComponent buildInsertPanel() {
        JTable jTable = this.buildTable();
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.getViewport().setBackground(jTable.getBackground());
        return jScrollPane;
    }

    private JTable buildTable() {
        JTable jTable = SwingComponentFactory.buildTable(this.tableModel, this.rowSelectionModel);
        int n = 20;
        TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
        TableCellRenderer tableCellRenderer = this.buildFieldColumnCellRenderer();
        tableColumn.setCellRenderer(tableCellRenderer);
        tableColumn = jTable.getColumnModel().getColumn(1);
        CheckBoxTableCellRenderer checkBoxTableCellRenderer = new CheckBoxTableCellRenderer();
        tableColumn.setCellRenderer(checkBoxTableCellRenderer);
        tableColumn.setCellEditor(new TableCellEditorAdapter(new CheckBoxTableCellRenderer()));
        n = Math.max(n, checkBoxTableCellRenderer.getPreferredHeight());
        jTable.setRowHeight(n);
        return jTable;
    }

    protected TableCellRenderer buildFieldColumnCellRenderer() {
        return new SimpleTableCellRenderer(){

            protected String buildText(Object object) {
                return object == null ? null : ((MWDataField)object).fieldName();
            }
        };
    }

    private ObjectListSelectionModel buildRowSelectionModel() {
        ObjectListSelectionModel objectListSelectionModel = new ObjectListSelectionModel(new ListModelAdapter(this.sortedFieldsAdapter));
        objectListSelectionModel.addListSelectionListener(this.buildRowSelectionListener());
        objectListSelectionModel.setSelectionMode(2);
        return objectListSelectionModel;
    }

    private ListSelectionListener buildRowSelectionListener() {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    ReturningInsertFieldsPanel.this.rowSelectionChanged();
                }
            }
        };
    }

    private void rowSelectionChanged() {
        Object[] objectArray = this.rowSelectionModel.getSelectedValues();
        boolean bl = objectArray.length > 0;
        this.removeAction.setEnabled(bl);
    }

    private TableModel buildTableModel() {
        return new TableModelAdapter(this.sortedFieldsAdapter, this.buildInsertColumnAdapter());
    }

    private ColumnAdapter buildInsertColumnAdapter() {
        return new InsertFieldColumnAdapter(this.resourceRepository());
    }

    private ListValueModel buildSortedInsertFieldReturnOnlyFlagsAdapter() {
        return new SortedListValueModelAdapter(this.buildColumnNameAdapter());
    }

    private ListValueModel buildColumnNameAdapter() {
        return new ItemPropertyListValueModelAdapter(this.buildInsertFieldReturnOnlyFlagsAdapter(), "name");
    }

    private CollectionValueModel buildInsertFieldReturnOnlyFlagsAdapter() {
        return new CollectionAspectAdapter(this.getSubjectHolder(), "insertFieldReturnOnlyFlags"){

            protected Iterator getValueFromSubject() {
                return ((MWReturningPolicy)this.subject).insertFieldReturnOnlyFlags();
            }

            protected int sizeFromSubject() {
                return ((MWReturningPolicy)this.subject).insertFieldReturnOnlyFlagsSize();
            }
        };
    }

    protected MWReturningPolicy returningPolicy() {
        return (MWReturningPolicy)this.getSubjectHolder().getValue();
    }

    private JPanel buildButtonPanel() {
        AccessibleTitledPanel accessibleTitledPanel = new AccessibleTitledPanel(new GridLayout(1, 0, 5, 0));
        accessibleTitledPanel.add(this.buildAddButton());
        accessibleTitledPanel.add(this.buildRemoveButton());
        return accessibleTitledPanel;
    }

    private JButton buildAddButton() {
        return new JButton(this.buildAddAction());
    }

    private Action buildAddAction() {
        final AbstractFrameworkAction abstractFrameworkAction = new AbstractFrameworkAction(this.getApplicationContext()){

            protected void initialize() {
                this.initializeText("ADD_BUTTON");
                this.initializeMnemonic("ADD_BUTTON");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ReturningInsertFieldsPanel.this.addField();
            }
        };
        abstractFrameworkAction.setEnabled(true);
        this.getSubjectHolder().addPropertyChangeListener("value", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                abstractFrameworkAction.setEnabled(ReturningInsertFieldsPanel.this.returningPolicy() != null);
            }
        });
        return abstractFrameworkAction;
    }

    protected abstract void addField();

    private JButton buildRemoveButton() {
        return new JButton(this.buildRemoveAction());
    }

    private Action buildRemoveAction() {
        this.removeAction = new AbstractFrameworkAction(this.getApplicationContext()){

            protected void initialize() {
                this.initializeText("REMOVE_BUTTON");
                this.initializeMnemonic("REMOVE_BUTTON");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ReturningInsertFieldsPanel.this.removeField();
            }
        };
        this.removeAction.setEnabled(false);
        return this.removeAction;
    }

    private void removeField() {
        Object[] objectArray = this.selectedFields();
        int n = objectArray.length;
        while (--n >= 0) {
            this.returningPolicy().removeInsertFieldReturnOnlyFlag((MWReturningPolicyInsertFieldReturnOnlyFlag)objectArray[n]);
        }
    }

    private Object[] selectedFields() {
        return this.rowSelectionModel.getSelectedValues();
    }

    private static class InsertFieldColumnAdapter
    implements ColumnAdapter {
        private ResourceRepository resourceRepository;
        public static final int COLUMN_COUNT = 2;
        public static final int INSERT_FIELD_COLUMN = 0;
        public static final int RETURN_ONLY_COLUMN = 1;
        private final String[] COLUMN_NAME_KEYS = new String[]{"RETURNING_POLICY_INSERT_COLUMN_HEADER", "RETURNING_POLICY_RETURN_ONLY_COLUMN_HEADER"};
        private static final String[] EMPTY_STRING_ARRAY = new String[0];

        protected InsertFieldColumnAdapter(ResourceRepository resourceRepository) {
            this.resourceRepository = resourceRepository;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            return this.resourceRepository.getString(this.COLUMN_NAME_KEYS[n]);
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return Object.class;
                }
                case 1: {
                    return Object.class;
                }
            }
            return Object.class;
        }

        public boolean isColumnEditable(int n) {
            switch (n) {
                case 0: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
            return false;
        }

        public PropertyValueModel[] cellModels(Object object) {
            MWReturningPolicyInsertFieldReturnOnlyFlag mWReturningPolicyInsertFieldReturnOnlyFlag = (MWReturningPolicyInsertFieldReturnOnlyFlag)object;
            PropertyValueModel[] propertyValueModelArray = new PropertyValueModel[]{this.buildInsertFieldAdapter(mWReturningPolicyInsertFieldReturnOnlyFlag), this.buildReturnOnlyAdapter(mWReturningPolicyInsertFieldReturnOnlyFlag)};
            return propertyValueModelArray;
        }

        private PropertyValueModel buildInsertFieldAdapter(MWReturningPolicyInsertFieldReturnOnlyFlag mWReturningPolicyInsertFieldReturnOnlyFlag) {
            PropertyAspectAdapter propertyAspectAdapter = new PropertyAspectAdapter(EMPTY_STRING_ARRAY, (Model)mWReturningPolicyInsertFieldReturnOnlyFlag){

                protected Object getValueFromSubject() {
                    return ((MWReturningPolicyInsertFieldReturnOnlyFlag)this.subject).getField();
                }
            };
            return new ValuePropertyPropertyValueModelAdapter((PropertyValueModel)propertyAspectAdapter, "fieldName");
        }

        private PropertyValueModel buildReturnOnlyAdapter(MWReturningPolicyInsertFieldReturnOnlyFlag mWReturningPolicyInsertFieldReturnOnlyFlag) {
            return new PropertyAspectAdapter("returnOnly", (Model)mWReturningPolicyInsertFieldReturnOnlyFlag){

                protected Object getValueFromSubject() {
                    return ((MWReturningPolicyInsertFieldReturnOnlyFlag)this.subject).isReturnOnly();
                }

                protected void setValueOnSubject(Object object) {
                    ((MWReturningPolicyInsertFieldReturnOnlyFlag)this.subject).setReturnOnly(((Boolean)object).booleanValue());
                }
            };
        }
    }
}

