/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AccessibleTitledPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWDataField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWReturningPolicy;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ColumnAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.TableModelAdapter;
import org.eclipse.persistence.tools.workbench.utility.Model;

public abstract class ReturningUpdateFieldsPanel
extends AbstractSubjectPanel {
    private TableModel tableModel;
    private ListValueModel sortedFieldsAdapter;
    private ObjectListSelectionModel rowSelectionModel;
    private AbstractFrameworkAction removeAction;
    static final String[] EMPTY_STRING_ARRAY = new String[0];

    protected ReturningUpdateFieldsPanel(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super((ValueModel)propertyValueModel, workbenchContextHolder);
    }

    protected void initializeLayout() {
        this.sortedFieldsAdapter = this.buildSortedUpdateFieldsHolder();
        this.tableModel = this.buildTableModel();
        this.rowSelectionModel = this.buildRowSelectionModel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = this.buildButtonPanel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)jPanel, gridBagConstraints);
        JComponent jComponent = this.buildUpdatePanel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)jComponent, gridBagConstraints);
    }

    private JComponent buildUpdatePanel() {
        JTable jTable = this.buildTable();
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.getViewport().setBackground(jTable.getBackground());
        return jScrollPane;
    }

    private JTable buildTable() {
        JTable jTable = SwingComponentFactory.buildTable(this.tableModel, this.rowSelectionModel);
        int n = 20;
        jTable.setRowHeight(n);
        return jTable;
    }

    private ObjectListSelectionModel buildRowSelectionModel() {
        ObjectListSelectionModel objectListSelectionModel = new ObjectListSelectionModel(new ListModelAdapter(this.sortedFieldsAdapter));
        objectListSelectionModel.addListSelectionListener(this.buildRowSelectionListener());
        objectListSelectionModel.setSelectionMode(2);
        return objectListSelectionModel;
    }

    private ListSelectionListener buildRowSelectionListener() {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    ReturningUpdateFieldsPanel.this.rowSelectionChanged();
                }
            }
        };
    }

    private void rowSelectionChanged() {
        Object[] objectArray = this.rowSelectionModel.getSelectedValues();
        boolean bl = objectArray.length > 0;
        this.removeAction.setEnabled(bl);
    }

    private TableModel buildTableModel() {
        return new TableModelAdapter(this.sortedFieldsAdapter, this.buildUpdateColumnAdapter());
    }

    private ColumnAdapter buildUpdateColumnAdapter() {
        return new UpdateFieldColumnAdapter(this.resourceRepository());
    }

    private ListValueModel buildSortedUpdateFieldsHolder() {
        return new SortedListValueModelAdapter(this.buildDatabaseFieldNameAdapter());
    }

    private ListValueModel buildDatabaseFieldNameAdapter() {
        return new ItemPropertyListValueModelAdapter(this.buildUpdateFieldsAdapter(), "qualifiedName");
    }

    private CollectionValueModel buildUpdateFieldsAdapter() {
        return new CollectionAspectAdapter(this.getSubjectHolder(), "updateFields"){

            protected Iterator getValueFromSubject() {
                return ((MWReturningPolicy)this.subject).updateFields();
            }

            protected int sizeFromSubject() {
                return ((MWReturningPolicy)this.subject).updateFieldsSize();
            }
        };
    }

    protected MWReturningPolicy returningPolicy() {
        return (MWReturningPolicy)this.getSubjectHolder().getValue();
    }

    private JPanel buildButtonPanel() {
        AccessibleTitledPanel accessibleTitledPanel = new AccessibleTitledPanel(new GridLayout(1, 0, 5, 0));
        accessibleTitledPanel.add(this.buildAddButton());
        accessibleTitledPanel.add(this.buildRemoveButton());
        return accessibleTitledPanel;
    }

    private JButton buildAddButton() {
        return new JButton(this.buildAddAction());
    }

    protected String addButtonKey() {
        return "ADD_BUTTON";
    }

    protected String removeButtonKey() {
        return "REMOVE_BUTTON";
    }

    private Action buildAddAction() {
        final AbstractFrameworkAction abstractFrameworkAction = new AbstractFrameworkAction(this.getApplicationContext()){

            public void actionPerformed(ActionEvent actionEvent) {
                ReturningUpdateFieldsPanel.this.addField();
            }
        };
        abstractFrameworkAction.setText(this.resourceRepository().getString(this.addButtonKey()));
        abstractFrameworkAction.setMnemonic(this.resourceRepository().getMnemonic(this.addButtonKey()));
        abstractFrameworkAction.setEnabled(true);
        this.getSubjectHolder().addPropertyChangeListener("value", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                abstractFrameworkAction.setEnabled(ReturningUpdateFieldsPanel.this.returningPolicy() != null);
            }
        });
        return abstractFrameworkAction;
    }

    protected abstract void addField();

    private JButton buildRemoveButton() {
        return new JButton(this.buildRemoveAction());
    }

    private Action buildRemoveAction() {
        this.removeAction = new AbstractFrameworkAction(this.getApplicationContext()){

            public void actionPerformed(ActionEvent actionEvent) {
                ReturningUpdateFieldsPanel.this.removeField();
            }
        };
        this.removeAction.setText(this.resourceRepository().getString(this.removeButtonKey()));
        this.removeAction.setMnemonic(this.resourceRepository().getMnemonic(this.removeButtonKey()));
        this.removeAction.setEnabled(false);
        return this.removeAction;
    }

    private void removeField() {
        Object[] objectArray = this.selectedFields();
        int n = objectArray.length;
        while (--n >= 0) {
            this.returningPolicy().removeUpdateField((MWDataField)objectArray[n]);
        }
    }

    private Object[] selectedFields() {
        return this.rowSelectionModel.getSelectedValues();
    }

    private static class UpdateFieldColumnAdapter
    implements ColumnAdapter {
        private ResourceRepository resourceRepository;
        public static final int COLUMN_COUNT = 1;
        public static final int UPDATE_FIELD_COLUMN = 0;
        private final String[] COLUMN_NAME_KEYS = new String[]{"RETURNING_POLICY_UPDATE_COLUMN_HEADER"};

        protected UpdateFieldColumnAdapter(ResourceRepository resourceRepository) {
            this.resourceRepository = resourceRepository;
        }

        public int getColumnCount() {
            return 1;
        }

        public String getColumnName(int n) {
            return this.resourceRepository.getString(this.COLUMN_NAME_KEYS[n]);
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return Object.class;
                }
            }
            return Object.class;
        }

        public boolean isColumnEditable(int n) {
            return false;
        }

        public PropertyValueModel[] cellModels(Object object) {
            PropertyValueModel[] propertyValueModelArray = new PropertyValueModel[]{this.buildUpdateFieldAdapter((MWDataField)object)};
            return propertyValueModelArray;
        }

        private PropertyValueModel buildUpdateFieldAdapter(MWDataField mWDataField) {
            return new PropertyAspectAdapter("fieldName", (Model)mWDataField){

                protected Object getValueFromSubject() {
                    return ((MWDataField)this.subject).fieldName();
                }
            };
        }
    }
}

