/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.relational;

import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWError;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.StatusDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.DescriptorCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.ProjectCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.relational.TableGenerator;
import org.eclipse.persistence.tools.workbench.uitools.LabelArea;
import org.eclipse.persistence.tools.workbench.uitools.cell.CellRendererAdapter;

abstract class AbstractGenerateTablesFromDescriptorsAction
extends AbstractFrameworkAction {
    AbstractGenerateTablesFromDescriptorsAction(WorkbenchContext workbenchContext) {
        super(workbenchContext);
    }

    protected void generateTablesFromDescriptors(Collection collection) {
        ApplicationNode applicationNode = this.selectedNodes()[0];
        MWProject mWProject = (MWProject)applicationNode.getProjectRoot().getValue();
        boolean bl = mWProject.isDirtyBranch();
        int n = this.notifyClassDefinitionMayChange(bl);
        if (n == 2 || n == -1) {
            return;
        }
        if (!bl && n == 1) {
            return;
        }
        if (n == 0 && bl) {
            applicationNode.save(null, this.getWorkbenchContext());
        }
        TableGenerator tableGenerator = new TableGenerator(this.getWorkbenchContext());
        StatusDialog.Status status = tableGenerator.generateTablesFromDescriptors(collection);
        this.showResult(status);
    }

    private int notifyClassDefinitionMayChange(boolean bl) {
        String string = bl ? "AUTO_GENERATING_TABLE_DEFINITIONS_STATUS_MESSAGE_SAVE" : "AUTO_GENERATING_TABLE_DEFINITIONS_STATUS_MESSAGE";
        LabelArea labelArea = new LabelArea(this.resourceRepository().getString(string));
        return JOptionPane.showConfirmDialog(this.currentWindow(), labelArea, this.application().getShortProductName(), bl ? 1 : 0, 1);
    }

    private void showResult(StatusDialog.Status status) {
        StatusDialog statusDialog = new StatusDialog(this.getWorkbenchContext(), Collections.singletonList(status), "AUTO_GENERATING_TABLE_DEFINITIONS_STATUS_DIALOG_TITLE"){

            protected CellRendererAdapter buildNodeRenderer(Object object) {
                if (object instanceof MWProject) {
                    return new ProjectCellRendererAdapter(this.resourceRepository());
                }
                if (object instanceof MWDescriptor) {
                    return new DescriptorCellRendererAdapter(this.resourceRepository());
                }
                if (object instanceof MWError) {
                    return new StatusDialog.MWErrorCellRendererAdapter(){

                        public Icon buildIcon(Object object) {
                            MWError mWError = (MWError)object;
                            if (mWError.getErrorId().endsWith("ASSUMPTION")) {
                                return this.resourceRepository().getIcon("ignore");
                            }
                            if (mWError.getErrorId().endsWith("URGENT")) {
                                return this.resourceRepository().getIcon("urgent");
                            }
                            return super.buildIcon(object);
                        }
                    };
                }
                return super.buildNodeRenderer(object);
            }
        };
        statusDialog.setVisible(true);
    }
}

