/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.relational;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemoveListPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemovePanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalPrimaryKeyPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational.RelationalMappingComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;

final class TableDescriptorPrimaryKeysPanel
extends AbstractPanel {
    private ValueModel relationalDescriptorHolder;

    TableDescriptorPrimaryKeysPanel(ValueModel valueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(workbenchContextHolder);
        this.relationalDescriptorHolder = valueModel;
        this.initializeLayout();
    }

    private void initializeLayout() {
        this.setBorder(BorderFactory.createCompoundBorder(this.buildTitledBorder("PRIMARY_KEYS_PANEL.TITLE"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        AddRemoveListPanel addRemoveListPanel = this.buildPrimaryKeysList();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)addRemoveListPanel, gridBagConstraints);
        this.addPaneForAlignment(addRemoveListPanel);
        this.addHelpTopicId(this, this.helpTopicId());
    }

    private AddRemoveListPanel buildPrimaryKeysList() {
        AddRemoveListPanel addRemoveListPanel = new AddRemoveListPanel(this.getApplicationContext(), this.buildPrimaryKeysAddRemoveAdapter(), this.buildSortedPrimaryKeysHolder(), 3, "PRIMARY_KEYS_PANEL.TITLE", RelationalMappingComponentFactory.buildColumnNodeSelector(this.getWorkbenchContextHolder())){

            protected String addButtonKey() {
                return "PRIMARY_KEYS_PANEL_ADD_BUTTON";
            }

            protected String removeButtonKey() {
                return "PRIMARY_KEYS_PANEL_REMOVE_BUTTON";
            }
        };
        addRemoveListPanel.setBorder(SwingComponentFactory.buildStandardEmptyBorder());
        addRemoveListPanel.setCellRenderer(this.buildPrimaryKeysListCellRenderer());
        return addRemoveListPanel;
    }

    private AddRemovePanel.Adapter buildPrimaryKeysAddRemoveAdapter() {
        return new AddRemovePanel.Adapter(){

            public void addNewItem(ObjectListSelectionModel objectListSelectionModel) {
                objectListSelectionModel.setSelectedValues(TableDescriptorPrimaryKeysPanel.this.addPrimaryKeys());
            }

            public void removeSelectedItems(ObjectListSelectionModel objectListSelectionModel) {
                TableDescriptorPrimaryKeysPanel.this.removePrimaryKeys(objectListSelectionModel.getSelectedValues());
            }
        };
    }

    private Object[] addPrimaryKeys() {
        Object[] objectArray = new PrimaryKeyDialog(this.getWorkbenchContext()).promptForPrimaryKeys();
        for (int i = 0; i < objectArray.length; ++i) {
            this.relationalDescriptor().primaryKeyPolicy().addPrimaryKey((MWColumn)objectArray[i]);
        }
        return objectArray;
    }

    private void removePrimaryKeys(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            this.relationalDescriptor().primaryKeyPolicy().removePrimaryKey((MWColumn)objectArray[i]);
        }
    }

    private ListValueModel buildSortedPrimaryKeysHolder() {
        return new SortedListValueModelAdapter(this.buildNamedPrimaryKeysHolder());
    }

    private ListValueModel buildNamedPrimaryKeysHolder() {
        return new ItemPropertyListValueModelAdapter(this.buildPrimaryKeysHolder(), "qualifiedName");
    }

    private CollectionValueModel buildPrimaryKeysHolder() {
        return new CollectionAspectAdapter(this.buildPrimaryKeyPolicyHolder(), "primaryKeys"){

            protected Iterator getValueFromSubject() {
                return ((MWRelationalPrimaryKeyPolicy)this.subject).primaryKeys();
            }

            protected int sizeFromSubject() {
                return ((MWRelationalPrimaryKeyPolicy)this.subject).primaryKeysSize();
            }
        };
    }

    private ValueModel buildPrimaryKeyPolicyHolder() {
        return new PropertyAspectAdapter(this.relationalDescriptorHolder){

            protected Object getValueFromSubject() {
                return ((MWTableDescriptor)this.subject).primaryKeyPolicy();
            }
        };
    }

    private ListCellRenderer buildPrimaryKeysListCellRenderer() {
        return new SimpleListCellRenderer(){

            protected String buildText(Object object) {
                return ((MWColumn)object).displayString();
            }
        };
    }

    private MWTableDescriptor relationalDescriptor() {
        return (MWTableDescriptor)this.relationalDescriptorHolder.getValue();
    }

    public String helpTopicId() {
        return "descriptor.descriptorInfo.primaryKeys";
    }

    private class PrimaryKeyDialog
    extends AbstractDialog {
        private ListModel primaryKeysModel;
        private ObjectListSelectionModel primaryKeysSelectionModel;

        private PrimaryKeyDialog(WorkbenchContext workbenchContext) {
            super(workbenchContext);
        }

        protected void initialize() {
            super.initialize();
            this.primaryKeysModel = this.buildPrimaryKeyListAdapter();
            this.primaryKeysSelectionModel = this.buildPrimaryKeysSelectionModel();
            this.setTitle(TableDescriptorPrimaryKeysPanel.this.resourceRepository().getString("PRIMARY_KEYS_DIALOG.TITLE"));
            this.getOKAction().setEnabled(false);
        }

        private ListModel buildPrimaryKeyListAdapter() {
            return new ListModelAdapter(this.buildSortedPrimaryKeysHolder());
        }

        private ListValueModel buildSortedPrimaryKeysHolder() {
            return new SortedListValueModelAdapter(this.buildPrimaryKeysHolder());
        }

        private CollectionValueModel buildPrimaryKeysHolder() {
            return new CollectionAspectAdapter(TableDescriptorPrimaryKeysPanel.this.relationalDescriptorHolder){

                protected Iterator getValueFromSubject() {
                    return ((MWTableDescriptor)this.subject).primaryKeyChoices();
                }
            };
        }

        private ObjectListSelectionModel buildPrimaryKeysSelectionModel() {
            ObjectListSelectionModel objectListSelectionModel = new ObjectListSelectionModel(this.primaryKeysModel);
            objectListSelectionModel.addListSelectionListener(this.buildSelectionListener());
            return objectListSelectionModel;
        }

        private ListSelectionListener buildSelectionListener() {
            return new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!listSelectionEvent.getValueIsAdjusting()) {
                        PrimaryKeyDialog.this.selectionChanged();
                    }
                }
            };
        }

        private void selectionChanged() {
            this.getOKAction().setEnabled(!this.primaryKeysSelectionModel.isSelectionEmpty());
        }

        protected Component buildMainPanel() {
            JList jList = SwingComponentFactory.buildList(this.primaryKeysModel);
            jList.setSelectionModel(this.primaryKeysSelectionModel);
            jList.setSelectionMode(2);
            jList.setCellRenderer(this.buildListCellRenderer());
            jList.addMouseListener(this.buildListMouseListener());
            return new JScrollPane(jList);
        }

        private ListCellRenderer buildListCellRenderer() {
            return new SimpleListCellRenderer(){

                protected String buildText(Object object) {
                    return ((MWColumn)object).getName();
                }
            };
        }

        protected MouseListener buildListMouseListener() {
            return new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        PrimaryKeyDialog.this.clickOK();
                    }
                }
            };
        }

        protected String helpTopicId() {
            return TableDescriptorPrimaryKeysPanel.this.helpTopicId();
        }

        private Object[] promptForPrimaryKeys() {
            this.show();
            if (this.wasConfirmed()) {
                return this.primaryKeysSelectionModel.getSelectedValues();
            }
            return new Object[0];
        }
    }
}

