/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JRadioButton;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWObjectTypeConverter;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWTypeConversionConverter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.ObjectTypeConverterPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.TypeConversionConverterPanel;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.FilteringPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.RadioButtonModelAdapter;

public final class ConverterPanel
extends AbstractPanel {
    private PropertyValueModel converterHolder;
    private PropertyValueModel converterTypeHolder;

    public ConverterPanel(PropertyValueModel propertyValueModel, ConverterSetter converterSetter, WorkbenchContextHolder workbenchContextHolder) {
        super(workbenchContextHolder);
        this.initialize(propertyValueModel, converterSetter);
        this.initializeLayout();
    }

    private void initialize(PropertyValueModel propertyValueModel, ConverterSetter converterSetter) {
        this.converterHolder = propertyValueModel;
        this.converterTypeHolder = this.buildConverterTypeHolder(propertyValueModel, converterSetter);
    }

    private PropertyValueModel buildConverterTypeHolder(PropertyValueModel propertyValueModel, final ConverterSetter converterSetter) {
        return new PropertyAspectAdapter(propertyValueModel, converterSetter.converterTypePropertyString()){

            protected Object getValueFromSubject() {
                return converterSetter.getType();
            }

            protected void setValueOnSubject(Object object) {
                String string = (String)object;
                if (string.equals("no-converter")) {
                    if (!converterSetter.getType().equals("no-converter")) {
                        converterSetter.setNullConverter();
                    }
                } else if (string.equals("object-type-converter")) {
                    if (!converterSetter.getType().equals("object-type-converter")) {
                        converterSetter.setObjectTypeConverter();
                    }
                } else if (string.equals("serialized-object-converter")) {
                    if (!converterSetter.getType().equals("serialized-object-converter")) {
                        converterSetter.setSerializedObjectConverter();
                    }
                } else if (string.equals("type-conversion-converter") && !converterSetter.getType().equals("type-conversion-converter")) {
                    converterSetter.setTypeConversionConverter();
                }
            }
        };
    }

    private void initializeLayout() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JRadioButton jRadioButton = this.buildNoConverterRadioButton();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 10, 0, 5);
        this.add((Component)jRadioButton, gridBagConstraints);
        JRadioButton jRadioButton2 = this.buildSerializedObjectConverterRadioButton();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 10, 0, 5);
        this.add((Component)jRadioButton2, gridBagConstraints);
        JRadioButton jRadioButton3 = this.buildTypeConversionConverterRadioButton();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 10, 0, 5);
        this.add((Component)jRadioButton3, gridBagConstraints);
        AbstractPanel abstractPanel = this.buildTypeConversionConverterPanel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 36, 0, 5);
        this.add((Component)abstractPanel, gridBagConstraints);
        this.addPaneForAlignment(abstractPanel);
        JRadioButton jRadioButton4 = this.buildObjectTypeConverterRadioButton();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(8, 10, 0, 5);
        this.add((Component)jRadioButton4, gridBagConstraints);
        AbstractPanel abstractPanel2 = this.buildObjectTypeConverterPanel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 36, 5, 5);
        this.add((Component)abstractPanel2, gridBagConstraints);
        this.addPaneForAlignment(abstractPanel2);
        this.addHelpTopicId(this, this.helpTopicId());
    }

    private JRadioButton buildNoConverterRadioButton() {
        return this.buildRadioButton("NO_CONVERTER_RADIO_BUTTON", this.buildConverterRadioButtonModelAdapter("no-converter", true));
    }

    private JRadioButton buildSerializedObjectConverterRadioButton() {
        JRadioButton jRadioButton = this.buildRadioButton("SERIALIZED_OBJECT_CONVERTER_RADIO_BUTTON", this.buildConverterRadioButtonModelAdapter("serialized-object-converter", false));
        this.addHelpTopicId(jRadioButton, this.helpTopicId() + ".serialized");
        return jRadioButton;
    }

    private JRadioButton buildTypeConversionConverterRadioButton() {
        JRadioButton jRadioButton = this.buildRadioButton("TYPE_CONVERSION_CONVERTER_RADIO_BUTTON", this.buildConverterRadioButtonModelAdapter("type-conversion-converter", false));
        this.addHelpTopicId(jRadioButton, this.helpTopicId() + ".typeConverter");
        return jRadioButton;
    }

    private AbstractPanel buildTypeConversionConverterPanel() {
        TypeConversionConverterPanel typeConversionConverterPanel = new TypeConversionConverterPanel(this.buildTypeConversionConverterHolder(), this.getWorkbenchContextHolder());
        this.buildTypeConversionConverterPanelEnabler(typeConversionConverterPanel);
        return typeConversionConverterPanel;
    }

    private PropertyValueModel buildTypeConversionConverterHolder() {
        return new FilteringPropertyValueModel(this.converterHolder){

            protected boolean accept(Object object) {
                return object instanceof MWTypeConversionConverter;
            }
        };
    }

    private ComponentEnabler buildTypeConversionConverterPanelEnabler(AbstractPanel abstractPanel) {
        return new ComponentEnabler(this.buildIsTypeConversionConverterHolder(), abstractPanel);
    }

    private ValueModel buildIsTypeConversionConverterHolder() {
        return new PropertyAspectAdapter(this.converterHolder){

            protected Object getValueFromSubject() {
                return new Boolean(this.subject instanceof MWTypeConversionConverter);
            }
        };
    }

    private JRadioButton buildObjectTypeConverterRadioButton() {
        JRadioButton jRadioButton = this.buildRadioButton("OBJECT_TYPE_CONVERTER_RADIO_BUTTON", this.buildConverterRadioButtonModelAdapter("object-type-converter", false));
        this.addHelpTopicId(jRadioButton, this.helpTopicId() + ".objectType");
        return jRadioButton;
    }

    private AbstractPanel buildObjectTypeConverterPanel() {
        ObjectTypeConverterPanel objectTypeConverterPanel = new ObjectTypeConverterPanel(this.buildObjectTypeConverterHolder(), this.getWorkbenchContextHolder());
        this.buildObjectTypeConverterPanelEnabler(objectTypeConverterPanel);
        return objectTypeConverterPanel;
    }

    private PropertyValueModel buildObjectTypeConverterHolder() {
        return new FilteringPropertyValueModel(this.converterHolder){

            protected boolean accept(Object object) {
                return object instanceof MWObjectTypeConverter;
            }
        };
    }

    private ComponentEnabler buildObjectTypeConverterPanelEnabler(AbstractPanel abstractPanel) {
        return new ComponentEnabler(this.buildIsObjectTypeConverterHolder(), abstractPanel);
    }

    private ValueModel buildIsObjectTypeConverterHolder() {
        return new PropertyAspectAdapter(this.converterHolder){

            protected Object getValueFromSubject() {
                return new Boolean(this.subject instanceof MWObjectTypeConverter);
            }
        };
    }

    private RadioButtonModelAdapter buildConverterRadioButtonModelAdapter(String string, boolean bl) {
        return new RadioButtonModelAdapter(this.converterTypeHolder, string, bl);
    }

    protected String helpTopicId() {
        return "mapping.converter";
    }

    public static interface ConverterSetter {
        public String getType();

        public void setNullConverter();

        public void setObjectTypeConverter();

        public void setSerializedObjectConverter();

        public void setTypeConversionConverter();

        public String converterTypePropertyString();
    }
}

