/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.GroupBox;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWIndirectableContainerMapping;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.RadioButtonModelAdapter;

public final class IndirectableContainerMappingPanel
extends AbstractSubjectPanel {
    public IndirectableContainerMappingPanel(ValueModel valueModel, ApplicationContext applicationContext) {
        super((LayoutManager)new BorderLayout(10, 0), valueModel, applicationContext);
    }

    private JComponent buildIndirectionPane() {
        JPanel jPanel = new JPanel(new BorderLayout(10, 0));
        PropertyValueModel propertyValueModel = this.buildIndirectionTypeBooleanHolder();
        JRadioButton jRadioButton = this.buildRadioButton("INDIRECTABLE_COLLECTION_VALUE_HOLDER_RADIO_BUTTON", this.buildValueHolderRadioButtonAdapter(propertyValueModel));
        JRadioButton jRadioButton2 = this.buildRadioButton("INDIRECTABLE_COLLECTION_TRANSPARENT_RADIO_BUTTON", this.buildTransparentRadioButtonAdapter(propertyValueModel));
        jPanel.add((Component)jRadioButton, "Before");
        jPanel.add((Component)jRadioButton2, "Center");
        new ComponentEnabler((ValueModel)this.buildIndirectionTypeEnablerHolder(), jPanel.getComponents());
        return jPanel;
    }

    private PropertyValueModel buildIndirectionTypeBooleanHolder() {
        return new TransformationPropertyValueModel(this.buildIndirectionTypeHolder()){

            protected Object transform(Object object) {
                if ("value-holder-indirection".equals(object)) {
                    return Boolean.TRUE;
                }
                if ("transparentIndirection".equals(object)) {
                    return Boolean.FALSE;
                }
                return null;
            }
        };
    }

    private PropertyValueModel buildIndirectionTypeEnablerHolder() {
        return new TransformationPropertyValueModel(this.buildIndirectionTypeHolder()){

            protected Object transform(Object object) {
                return !"no-indirection".equals(object);
            }
        };
    }

    private PropertyValueModel buildIndirectionTypeHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "indirection"){

            protected Object getValueFromSubject() {
                MWIndirectableContainerMapping mWIndirectableContainerMapping = (MWIndirectableContainerMapping)this.subject;
                if (mWIndirectableContainerMapping.usesValueHolderIndirection()) {
                    return "value-holder-indirection";
                }
                if (mWIndirectableContainerMapping.usesTransparentIndirection()) {
                    return "transparentIndirection";
                }
                return "no-indirection";
            }

            protected void setValueOnSubject(Object object) {
                MWIndirectableContainerMapping mWIndirectableContainerMapping = (MWIndirectableContainerMapping)this.subject;
                if (Boolean.TRUE.equals(object)) {
                    mWIndirectableContainerMapping.setUseValueHolderIndirection();
                } else {
                    mWIndirectableContainerMapping.setUseTransparentIndirection();
                }
            }
        };
    }

    private ButtonModel buildTransparentRadioButtonAdapter(PropertyValueModel propertyValueModel) {
        return new RadioButtonModelAdapter(propertyValueModel, Boolean.FALSE);
    }

    private ButtonModel buildUseIndirectionCheckBoxAdapter() {
        return new CheckBoxModelAdapter(this.buildUseIndirectionHolder());
    }

    private PropertyValueModel buildUseIndirectionHolder() {
        PropertyAspectAdapter propertyAspectAdapter = new PropertyAspectAdapter(this.getSubjectHolder(), "indirection"){

            protected Object getValueFromSubject() {
                MWIndirectableContainerMapping mWIndirectableContainerMapping = (MWIndirectableContainerMapping)this.subject;
                if (mWIndirectableContainerMapping.usesValueHolderIndirection()) {
                    return "indirection";
                }
                if (mWIndirectableContainerMapping.usesTransparentIndirection()) {
                    return "transparentIndirection";
                }
                return "no-indirection";
            }

            protected void setValueOnSubject(Object object) {
                MWIndirectableContainerMapping mWIndirectableContainerMapping = (MWIndirectableContainerMapping)this.subject;
                if (Boolean.TRUE.equals(object) && mWIndirectableContainerMapping.usesNoIndirection()) {
                    mWIndirectableContainerMapping.setUseValueHolderIndirection();
                } else if (Boolean.FALSE.equals(object) && !mWIndirectableContainerMapping.usesNoIndirection()) {
                    mWIndirectableContainerMapping.setUseNoIndirection();
                }
            }
        };
        return new TransformationPropertyValueModel(propertyAspectAdapter){

            protected Object transform(Object object) {
                return !"no-indirection".equals(object);
            }
        };
    }

    private ButtonModel buildValueHolderRadioButtonAdapter(PropertyValueModel propertyValueModel) {
        return new RadioButtonModelAdapter(propertyValueModel, Boolean.TRUE);
    }

    protected void initializeLayout() {
        JCheckBox jCheckBox = this.buildCheckBox("INDIRECTABLE_COLLECTION_USE_INDIRECTION_CHECK_BOX", this.buildUseIndirectionCheckBoxAdapter());
        GroupBox groupBox = new GroupBox(jCheckBox, this.buildIndirectionPane());
        this.add((Component)groupBox, "Center");
        this.addHelpTopicId(this, "mapping.indirection");
    }
}

