/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Icon;
import org.eclipse.persistence.tools.workbench.framework.app.ActiveIconBuilder;
import org.eclipse.persistence.tools.workbench.framework.app.CompositeIconBuilder;
import org.eclipse.persistence.tools.workbench.framework.app.GroupContainerDescription;
import org.eclipse.persistence.tools.workbench.framework.app.IconBuilder;
import org.eclipse.persistence.tools.workbench.framework.app.SelectionActionsPolicy;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.resources.DefaultIconRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWDatabase;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsplugin.MappingsPluginIconResourceFileNameMap;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.MappingsApplicationNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.MappingDescriptorNode;
import org.eclipse.persistence.tools.workbench.uitools.app.TreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.utility.iterators.SingleElementIterator;

public abstract class MappingNode
extends MappingsApplicationNode {
    private PropertyChangeListener attributeNameListener;
    private PropertyChangeListener attributeTypeDeclarationListener;
    private SelectionActionsPolicy mappingNodeTypePolicy;
    protected static final String[] MAPPING_DISPLAY_STRING_PROPERTY_NAMES = new String[]{"name"};
    private static final Icon INHERITED_ICON = new DefaultIconRepository(new MappingsPluginIconResourceFileNameMap()).getIcon("inherited");

    protected MappingNode(MWModel mWModel, ApplicationContext applicationContext, SelectionActionsPolicy selectionActionsPolicy, MappingDescriptorNode mappingDescriptorNode) {
        super(mWModel, (TreeNodeValueModel)mappingDescriptorNode, mappingDescriptorNode.getPlugin(), applicationContext);
        this.mappingNodeTypePolicy = selectionActionsPolicy;
    }

    protected MappingNode(MWModel mWModel, SelectionActionsPolicy selectionActionsPolicy, MappingDescriptorNode mappingDescriptorNode) {
        this(mWModel, mappingDescriptorNode.getApplicationContext(), selectionActionsPolicy, mappingDescriptorNode);
    }

    protected void initialize() {
        super.initialize();
        this.attributeNameListener = this.buildAttributeNameListener();
        this.attributeTypeDeclarationListener = this.buildAttributeTypeDeclarationListener();
    }

    private PropertyChangeListener buildAttributeNameListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                MappingNode.this.attributeNameChanged();
            }

            public String toString() {
                return "attribute name listener";
            }
        };
    }

    private PropertyChangeListener buildAttributeTypeDeclarationListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                MappingNode.this.attributeTypeDeclarationChanged();
            }

            public String toString() {
                return "attribute type declaration listener";
            }
        };
    }

    protected void engageValue() {
        super.engageValue();
        this.descriptor().addPropertyChangeListener("active", this.getValueIconListener());
        this.descriptor().addPropertyChangeListener("active", this.getValuePropertiesPageTitleIconListener());
        this.instanceVariable().addPropertyChangeListener("name", this.attributeNameListener);
        this.instanceVariable().addPropertyChangeListener("declaration", this.attributeTypeDeclarationListener);
    }

    protected void disengageValue() {
        this.instanceVariable().removePropertyChangeListener("declaration", this.attributeTypeDeclarationListener);
        this.instanceVariable().removePropertyChangeListener("name", this.attributeNameListener);
        this.descriptor().removePropertyChangeListener("active", this.getValuePropertiesPageTitleIconListener());
        this.descriptor().removePropertyChangeListener("active", this.getValueIconListener());
        super.disengageValue();
    }

    protected String[] displayStringPropertyNames() {
        return MAPPING_DISPLAY_STRING_PROPERTY_NAMES;
    }

    protected IconBuilder buildIconBuilder() {
        CompositeIconBuilder compositeIconBuilder = new CompositeIconBuilder(super.buildIconBuilder(), this.mappingIsInherited(), INHERITED_ICON, -3, 0, 0, null);
        return new ActiveIconBuilder(compositeIconBuilder, this.descriptor().isActive());
    }

    protected String buildPropertiesPageTitleText() {
        return this.getMapping().nameWithShortType();
    }

    public GroupContainerDescription buildMenuDescription(WorkbenchContext workbenchContext) {
        WorkbenchContext workbenchContext2 = this.buildLocalWorkbenchContext(workbenchContext);
        GroupContainerDescription groupContainerDescription = this.mappingNodeTypePolicy.buildMenuDescription(workbenchContext2);
        groupContainerDescription.add(this.buildOracleHelpMenuGroup(workbenchContext2));
        return groupContainerDescription;
    }

    public GroupContainerDescription buildToolBarDescription(WorkbenchContext workbenchContext) {
        return this.mappingNodeTypePolicy.buildToolBarDescription(this.buildLocalWorkbenchContext(workbenchContext));
    }

    public String candidatePackageName() {
        return this.getDescriptorNode().candidatePackageName();
    }

    public boolean isAutoMappable() {
        return false;
    }

    public Iterator descriptors() {
        return new SingleElementIterator((Object)this.descriptor());
    }

    public void addDescriptorsTo(Collection collection) {
        collection.add(this.descriptor());
    }

    public MWMapping getMapping() {
        return (MWMapping)this.getValue();
    }

    public MWClassAttribute instanceVariable() {
        return this.getMapping().getInstanceVariable();
    }

    public MappingDescriptorNode getDescriptorNode() {
        return (MappingDescriptorNode)this.getParent();
    }

    public MWMappingDescriptor descriptor() {
        return this.getDescriptorNode().getMappingDescriptor();
    }

    public boolean mappingIsInherited() {
        return this.getMapping().isInherited();
    }

    public boolean isMapped() {
        return true;
    }

    public boolean isUnmapped() {
        return !this.isMapped();
    }

    public MWDatabase database() {
        return this.descriptor().getDatabase();
    }

    protected void attributeNameChanged() {
        if (this.isMapped()) {
            this.getMapping().setName(this.instanceVariable().getName());
        }
    }

    protected void attributeTypeDeclarationChanged() {
        this.propertiesPageTitleTextChanged();
    }

    void remove() {
        MWMapping mWMapping = this.getMapping();
        this.descriptor().removeMapping(mWMapping);
        this.removeInstanceVariable();
    }

    void removeInstanceVariable() {
        MWClassAttribute mWClassAttribute = this.instanceVariable();
        if (this.mappingIsInherited()) {
            this.descriptor().removeInheritedAttribute(mWClassAttribute);
        } else if (mWClassAttribute.isEjb20Attribute()) {
            mWClassAttribute.getDeclaringType().removeEjb20Attribute(mWClassAttribute);
        } else {
            mWClassAttribute.getDeclaringType().removeAttribute(mWClassAttribute);
        }
    }
}

