/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.relational;

import java.util.Iterator;
import javax.swing.ListCellRenderer;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooser;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooserDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWDatabase;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.TableCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.relational.RelationalProjectNode;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ExtendedListValueModelWrapper;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.chooser.ListChooser;
import org.eclipse.persistence.tools.workbench.uitools.chooser.NodeSelector;

public class RelationalProjectComponentFactory
extends SwingComponentFactory {
    public static ListChooser buildTableChooser(PropertyValueModel propertyValueModel, PropertyValueModel propertyValueModel2, DefaultListChooserDialog.Builder builder, WorkbenchContextHolder workbenchContextHolder) {
        DefaultListChooser defaultListChooser = new DefaultListChooser(new ComboBoxModelAdapter(RelationalProjectComponentFactory.buildExtendedTablesHolder(propertyValueModel), propertyValueModel2), workbenchContextHolder, RelationalProjectComponentFactory.buildTableNodeSelector(workbenchContextHolder), builder);
        defaultListChooser.setRenderer(RelationalProjectComponentFactory.buildMWTableListCellRenderer(workbenchContextHolder.getWorkbenchContext().getApplicationContext().getResourceRepository()));
        return defaultListChooser;
    }

    private static ValueModel buildDatabaseAdapter(PropertyValueModel propertyValueModel) {
        return new TransformationPropertyValueModel(propertyValueModel){

            protected Object transform(Object object) {
                return object == null ? null : ((MWModel)object).getDatabase();
            }

            protected Object reverseTransform(Object object) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static ListValueModel buildExtendedTablesHolder(PropertyValueModel propertyValueModel) {
        return new ExtendedListValueModelWrapper(RelationalProjectComponentFactory.buildSortedTablesHolder(RelationalProjectComponentFactory.buildDatabaseAdapter(propertyValueModel)));
    }

    private static ListValueModel buildSortedTablesHolder(ValueModel valueModel) {
        return new SortedListValueModelAdapter(RelationalProjectComponentFactory.buildTableNameAdapter(valueModel));
    }

    private static ListValueModel buildTableNameAdapter(ValueModel valueModel) {
        return new ItemPropertyListValueModelAdapter(RelationalProjectComponentFactory.buildTablesAdapter(valueModel), "qualifiedName");
    }

    private static CollectionValueModel buildTablesAdapter(ValueModel valueModel) {
        return new CollectionAspectAdapter(valueModel, "tables"){

            protected Iterator getValueFromSubject() {
                return ((MWDatabase)this.subject).tables();
            }

            protected int sizeFromSubject() {
                return ((MWDatabase)this.subject).tablesSize();
            }
        };
    }

    private static ListCellRenderer buildMWTableListCellRenderer(ResourceRepository resourceRepository) {
        return new AdaptableListCellRenderer(new TableCellRendererAdapter(resourceRepository));
    }

    public static NodeSelector buildTableNodeSelector(final WorkbenchContextHolder workbenchContextHolder) {
        return new NodeSelector(){

            public void selectNodeFor(Object object) {
                RelationalProjectNode relationalProjectNode = (RelationalProjectNode)workbenchContextHolder.getWorkbenchContext().getNavigatorSelectionModel().getSelectedProjectNodes()[0];
                relationalProjectNode.selectTableNodeFor((MWTable)object, workbenchContextHolder.getWorkbenchContext().getNavigatorSelectionModel());
            }
        };
    }
}

