/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.relational;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.FileChooser;
import org.eclipse.persistence.tools.workbench.framework.uitools.RegexpDocument;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational.MWRelationalProject;
import org.eclipse.persistence.tools.workbench.mappingsplugin.MappingsPlugin;
import org.eclipse.persistence.tools.workbench.uitools.CancelException;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;

final class TableCreatorSourceGenerationCoordinator {
    private WorkbenchContext context;

    TableCreatorSourceGenerationCoordinator(WorkbenchContext workbenchContext) {
        this.initialize(workbenchContext);
    }

    private void initialize(WorkbenchContext workbenchContext) {
        this.context = workbenchContext;
    }

    private ResourceRepository resourceRepository() {
        return this.context.getApplicationContext().getResourceRepository();
    }

    void exportTableCreatorSource(MWRelationalProject mWRelationalProject) {
        try {
            this.validateTableCreatorClassName(mWRelationalProject);
            this.validateTableCreatorSourceRootDirectory(mWRelationalProject);
            this.validateProjectProblems(mWRelationalProject);
            this.validateOverwriteFile(mWRelationalProject);
        }
        catch (CancelException cancelException) {
            return;
        }
        try {
            mWRelationalProject.exportTableCreatorSource();
        }
        catch (RuntimeException runtimeException) {
            return;
        }
        this.showSuccessDialog((MWProject)mWRelationalProject);
    }

    private void validateTableCreatorClassName(MWRelationalProject mWRelationalProject) {
        String string = mWRelationalProject.getTableCreatorSourceClassName();
        if (!string.equals("") && !string.endsWith(".")) {
            return;
        }
        TableCreatorClassNameDialog tableCreatorClassNameDialog = new TableCreatorClassNameDialog(this.context, this.buildTableCreatorClassNameHolder(string), (MWProject)mWRelationalProject);
        tableCreatorClassNameDialog.show();
        if (tableCreatorClassNameDialog.wasCanceled()) {
            throw new CancelException();
        }
        mWRelationalProject.setTableCreatorSourceClassName(tableCreatorClassNameDialog.getTableCreatorClassName());
    }

    private PropertyValueModel buildTableCreatorClassNameHolder(String string) {
        return new SimplePropertyValueModel(string);
    }

    private void validateTableCreatorSourceRootDirectory(MWRelationalProject mWRelationalProject) {
        if (mWRelationalProject.getTableCreatorSourceDirectoryName().equals("")) {
            this.promptForTableCreatorSourceRootDirectory(mWRelationalProject);
        }
        if (mWRelationalProject.absoluteTableCreatorSourceDirectory().isFile()) {
            this.promptForNonFileTableCreatorSourceRootDirectory(mWRelationalProject);
        }
        if (!mWRelationalProject.absoluteTableCreatorSourceDirectory().exists()) {
            this.promptToCreateTableCreatorSourceRootDirectory(mWRelationalProject);
        }
    }

    private void validateProjectProblems(MWRelationalProject mWRelationalProject) {
    }

    private void validateOverwriteFile(MWRelationalProject mWRelationalProject) {
        File file = mWRelationalProject.tableCreatorSourceFile();
        String string = file.getAbsolutePath();
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!file.exists()) {
            return;
        }
        int n = JOptionPane.showConfirmDialog(this.context.getCurrentWindow(), this.resourceRepository().getString("TABLE_CREATOR_FILE_EXISTS_DIALOG.message", new Object[]{string}), this.resourceRepository().getString("TABLE_CREATOR_FILE_EXISTS_DIALOG.title"), 0, 3);
        if (n != 0) {
            throw new CancelException();
        }
    }

    private void promptForTableCreatorSourceRootDirectory(MWRelationalProject mWRelationalProject) {
        String string = this.resourceRepository().getString("TABLE_CREATOR_SOURCE_ROOT_DIRECTORY_DIALOG_NO_DIRECTORY_CHOSEN.message");
        this.promptForDirectory(mWRelationalProject, string);
    }

    private void promptForNonFileTableCreatorSourceRootDirectory(MWRelationalProject mWRelationalProject) {
        String string = this.resourceRepository().getString("TABLE_CREATOR_SOURCE_ROOT_DIRECTORY_DIALOG_CHOSEN_DIRECTORY_IS_A_FILE.message", new Object[]{mWRelationalProject.absoluteTableCreatorSourceDirectory()});
        this.promptForDirectory(mWRelationalProject, string);
    }

    private void promptForValidTableCreatorSourceRootDirectory(MWRelationalProject mWRelationalProject) {
        String string = this.resourceRepository().getString("TABLE_CREATOR_SOURCE_ROOT_DIRECTORY_DIALOG_CHOSEN_DIRECTORY_IS_INVALID.message", new Object[]{mWRelationalProject.absoluteTableCreatorSourceDirectory()});
        this.promptForDirectory(mWRelationalProject, string);
    }

    private void promptForCreatableTableCreatorSourceRootDirectory(MWRelationalProject mWRelationalProject) {
        String string = this.resourceRepository().getString("TABLE_CREATOR_SOURCE_ROOT_DIRECTORY_DIALOG_CHOSEN_DIRECTORY_COULD_NOT_BE_CREATED.message", new Object[]{mWRelationalProject.absoluteTableCreatorSourceDirectory()});
        this.promptForDirectory(mWRelationalProject, string);
    }

    private Preferences preferences() {
        return this.context.getApplicationContext().getPreferences();
    }

    private void promptForDirectory(MWRelationalProject mWRelationalProject, String string) {
        File file = MappingsPlugin.buildExportDirectory((MWProject)mWRelationalProject, mWRelationalProject.getTableCreatorSourceDirectoryName(), this.preferences());
        FileChooser fileChooser = new FileChooser(file, mWRelationalProject.getSaveDirectory());
        fileChooser.setDialogTitle(this.resourceRepository().getString("TABLE_CREATOR_SOURCE_ROOT_DIRECTORY_DIALOG.title", mWRelationalProject.getName()));
        fileChooser.setFileSelectionMode(1);
        fileChooser.setApproveButtonText(this.resourceRepository().getString("TABLE_CREATOR_SOURCE_ROOT_DIRECTORY_DIALOG_SELECT_BUTTON"));
        fileChooser.setApproveButtonMnemonic(this.resourceRepository().getMnemonic("TABLE_CREATOR_SOURCE_ROOT_DIRECTORY_DIALOG_SELECT_BUTTON"));
        int n = fileChooser.showOpenDialog(this.context.getCurrentWindow());
        if (n == 1) {
            throw new CancelException();
        }
        File file2 = ((JFileChooser)fileChooser).getSelectedFile();
        mWRelationalProject.setTableCreatorSourceDirectoryName(file2.getPath());
        if (file2 != null && file2.isAbsolute() && !file2.equals(mWRelationalProject.getSaveDirectory())) {
            this.preferences().put("export location", file2.getPath());
        }
    }

    private void promptToCreateTableCreatorSourceRootDirectory(MWRelationalProject mWRelationalProject) {
        File file;
        try {
            file = mWRelationalProject.absoluteTableCreatorSourceDirectory().getCanonicalFile();
        }
        catch (IOException iOException) {
            this.promptForValidTableCreatorSourceRootDirectory(mWRelationalProject);
            return;
        }
        int n = JOptionPane.showConfirmDialog(this.context.getCurrentWindow(), this.resourceRepository().getString("CREATE_TABLE_CREATOR_SOURCE_ROOT_DIRECTORY_DIALOG.message", new Object[]{file}), this.resourceRepository().getString("CREATE_TABLE_CREATOR_SOURCE_ROOT_DIRECTORY_DIALOG.title"), 2, 3);
        if (n == 2) {
            throw new CancelException();
        }
        if (!mWRelationalProject.absoluteTableCreatorSourceDirectory().mkdirs()) {
            this.promptForCreatableTableCreatorSourceRootDirectory(mWRelationalProject);
        }
    }

    private void showSuccessDialog(MWProject mWProject) {
        JOptionPane.showMessageDialog(this.context.getCurrentWindow(), this.resourceRepository().getString("GENERATE_TABLE_CREATOR_SOURCE_SUCCESS_DIALOG.message"), this.resourceRepository().getString("GENERATE_TABLE_CREATOR_SOURCE_SUCCESS_DIALOG.title", mWProject.getName()), 1);
    }

    private class TableCreatorClassNameDialog
    extends AbstractDialog {
        private JTextField tableCreatorClassNameTextField;
        private PropertyValueModel tableCreatorClassNameHolder;
        private static final long serialVersionUID = 1L;

        private TableCreatorClassNameDialog(WorkbenchContext workbenchContext, PropertyValueModel propertyValueModel, MWProject mWProject) {
            super(workbenchContext);
            this.tableCreatorClassNameHolder = propertyValueModel;
            this.initialize(mWProject);
        }

        protected void initialize(MWProject mWProject) {
            super.initialize();
            this.setTitle(this.resourceRepository().getString("TABLE_CREATOR_CLASS_NAME_DIALOG.title", mWProject.getName()));
            this.getOKAction().setEnabled(false);
        }

        protected String helpTopicId() {
            return "dialog.tableCreatorClassName";
        }

        protected Component buildMainPanel() {
            JPanel jPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            JLabel jLabel = new JLabel();
            jLabel.setText(this.resourceRepository().getString("TABLE_CREATOR_CLASS_NAME_DIALOG.message"));
            jLabel.setDisplayedMnemonic(this.resourceRepository().getMnemonic("TABLE_CREATOR_CLASS_NAME_DIALOG.message"));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.insets = new Insets(5, 5, 0, 5);
            jPanel.add((Component)jLabel, gridBagConstraints);
            this.tableCreatorClassNameTextField = this.buildTableCreatorClassNameTextField();
            jLabel.setLabelFor(this.tableCreatorClassNameTextField);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            jPanel.add((Component)this.tableCreatorClassNameTextField, gridBagConstraints);
            return jPanel;
        }

        private JTextField buildTableCreatorClassNameTextField() {
            JTextField jTextField = new JTextField();
            jTextField.setDocument(this.buildTableCreatorClassNameDocumentAdapter());
            return jTextField;
        }

        private Document buildTableCreatorClassNameDocumentAdapter() {
            DocumentAdapter documentAdapter = new DocumentAdapter(this.tableCreatorClassNameHolder, new RegexpDocument(3));
            documentAdapter.addDocumentListener(this.buildTableCreatorClassNameDocumentListener());
            return documentAdapter;
        }

        protected Component initialFocusComponent() {
            return this.tableCreatorClassNameTextField;
        }

        String getTableCreatorClassName() {
            return (String)this.tableCreatorClassNameHolder.getValue();
        }

        private DocumentListener buildTableCreatorClassNameDocumentListener() {
            return new DocumentListener(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    TableCreatorClassNameDialog.this.tableCreatorClassNameChanged();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    TableCreatorClassNameDialog.this.tableCreatorClassNameChanged();
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    TableCreatorClassNameDialog.this.tableCreatorClassNameChanged();
                }
            };
        }

        void tableCreatorClassNameChanged() {
            String string = this.getTableCreatorClassName();
            this.getOKAction().setEnabled(!string.equals("") && !string.endsWith("."));
        }
    }
}

