/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.TopLinkOption;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWLockingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWAbstractQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWAbstractReadQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWReadQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalQuery;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.NumberSpinnerModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.RadioButtonModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public abstract class QueryAdvancedOptionsDialog
extends AbstractDialog {
    private MWQuery query;
    private ButtonModel cacheQueryResultsButtonModel;
    private ButtonModel exclusiveConnectionButtonModel;
    private ComboBoxModel lockingComboBoxModel;
    private ComboBoxModel distinctStateComboBoxModel;
    private SpinnerNumberModel queryTimeoutSpinnerNumberModel;
    private ButtonModel maximumRowCheckBoxModel;
    private ButtonModel firstResultCheckBoxModel;
    private JSpinner maximumRowsSpinner;
    private SpinnerNumberModel maximumRowsSpinnerNumberModel;
    private JSpinner firstResultSpinner;
    private SpinnerNumberModel firstResultSpinnerNumberModel;
    private ButtonModel prepareCheckBoxModel;
    private ButtonModel maintainCacheCheckBoxModel;
    private ButtonModel useWrapperPolicyCheckBoxModel;
    private ButtonModel refreshRemoteIdentityMapCheckBoxModel;
    private boolean refreshIdentityMapResult;

    public QueryAdvancedOptionsDialog(MWQuery mWQuery, WorkbenchContext workbenchContext) {
        super(workbenchContext);
        this.query = mWQuery;
    }

    protected void initialize() {
        super.initialize();
        this.setTitle(this.resourceRepository().getString("ADVANCED_QUERY_OPTIONS_DIALOG.title"));
    }

    protected String helpTopicId() {
        return "dialog.advancedQueryOptions";
    }

    protected JCheckBox buildCacheQueryResultsCheckBox() {
        this.cacheQueryResultsButtonModel = this.buildCacheQueryResultsButtonModel();
        JCheckBox jCheckBox = SwingComponentFactory.buildCheckBox("CACHE_QUERY_RESULTS_CHECK_BOX", this.cacheQueryResultsButtonModel, this.resourceRepository());
        this.helpManager().addTopicID(jCheckBox, this.helpTopicId() + ".cacheQuery");
        jCheckBox.setSelected(this.query.isCacheQueryResults());
        return jCheckBox;
    }

    private ButtonModel buildCacheQueryResultsButtonModel() {
        return new CheckBoxModelAdapter(new SimplePropertyValueModel());
    }

    public boolean getCacheQueryResults() {
        return this.cacheQueryResultsButtonModel.isSelected();
    }

    protected JCheckBox buildExclusiveConnectionCheckBox() {
        this.exclusiveConnectionButtonModel = this.buildExclusiveConnectionButtonModel();
        JCheckBox jCheckBox = SwingComponentFactory.buildCheckBox("EXCLUSIVE_CONNECTION_CHECK_BOX", this.exclusiveConnectionButtonModel, this.resourceRepository());
        this.helpManager().addTopicID(jCheckBox, this.helpTopicId() + ".exclusiveConnection");
        jCheckBox.setSelected(this.query.isExclusiveConnection());
        return jCheckBox;
    }

    private ButtonModel buildExclusiveConnectionButtonModel() {
        return new CheckBoxModelAdapter(new SimplePropertyValueModel());
    }

    public boolean getExclusiveConnection() {
        return this.exclusiveConnectionButtonModel.isSelected();
    }

    protected JComboBox buildLockingOptionsComboBox() {
        this.lockingComboBoxModel = new DefaultComboBoxModel(CollectionTools.vector((Iterator)MWAbstractQuery.lockingOptions().toplinkOptions()));
        JComboBox jComboBox = new JComboBox(this.lockingComboBoxModel);
        jComboBox.setSelectedItem(this.query.getLocking());
        jComboBox.addActionListener(this.buildLockingAction());
        jComboBox.setRenderer(this.buildTopLinkModelOptionsCellRenderer());
        this.helpManager().addTopicID(jComboBox, this.helpTopicId() + ".pesimisticLock");
        return jComboBox;
    }

    private ListCellRenderer buildTopLinkModelOptionsCellRenderer() {
        return new SimpleListCellRenderer(){

            protected String buildText(Object object) {
                return QueryAdvancedOptionsDialog.this.resourceRepository().getString(((TopLinkOption)object).resourceKey());
            }
        };
    }

    private ActionListener buildLockingAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                QueryAdvancedOptionsDialog.this.setLocking();
            }
        };
    }

    protected void setLocking() {
        int n;
        MWLockingPolicy mWLockingPolicy = this.query.getOwningDescriptor().getLockingPolicy();
        String string = ((MWAbstractQuery.LockingModel)this.lockingComboBoxModel.getSelectedItem()).getMWModelOption();
        if (!(string == "Do Not Acquire Locks" || string != "Use Descriptor Setting" || mWLockingPolicy.getLockingType() != "Pessimistic Locking" || this.getRefreshIdentityMapResult() && this.getRefreshRemoteIdentityMapResult() || (n = JOptionPane.showConfirmDialog(this.getWorkbenchContext().getCurrentWindow(), this.resourceRepository().getString("SET_LOCKING_DIALOG_MESSAGE"), this.resourceRepository().getString("SET_REFRESH_IDENTITY_MAP_RESULTS.title"), 0, 3)) != 0)) {
            this.refreshRemoteIdentityMapCheckBoxModel.setSelected(true);
            this.refreshIdentityMapResult = true;
        }
    }

    public MWAbstractQuery.LockingModel getLocking() {
        return (MWAbstractQuery.LockingModel)this.lockingComboBoxModel.getSelectedItem();
    }

    protected JComboBox buildDistinctStateComboBox() {
        this.distinctStateComboBoxModel = new DefaultComboBoxModel(CollectionTools.vector((Iterator)MWAbstractQuery.distinctStateOptions().toplinkOptions()));
        JComboBox jComboBox = new JComboBox(this.distinctStateComboBoxModel);
        jComboBox.setSelectedItem(this.query.getDistinctState());
        jComboBox.setRenderer(this.buildTopLinkModelOptionsCellRenderer());
        this.helpManager().addTopicID(jComboBox, this.helpTopicId() + ".distinctState");
        return jComboBox;
    }

    public MWAbstractQuery.DistinctStateModel getDistinctState() {
        return (MWAbstractQuery.DistinctStateModel)this.distinctStateComboBoxModel.getSelectedItem();
    }

    protected JRadioButton buildUseDescriptorTimeoutRadioButton(PropertyValueModel propertyValueModel) {
        return SwingComponentFactory.buildRadioButton("QUERY_TIMEOUT_USE_DESCRIPTOR_SETTING", this.buildUseDescriptorTimeoutRadioButtonModel(propertyValueModel), this.resourceRepository());
    }

    protected JRadioButton buildQueryTimeoutRadioButton(PropertyValueModel propertyValueModel) {
        return SwingComponentFactory.buildRadioButton("QUERY_TIMEOUT_TIMEOUT", this.buildQueryTimeoutRadioButtonModel(propertyValueModel), this.resourceRepository());
    }

    protected JRadioButton buildNoTimeoutRadioButton(PropertyValueModel propertyValueModel) {
        return SwingComponentFactory.buildRadioButton("QUERY_TIMEOUT_NO_TIMEOUT", this.buildNoQueryTimeoutRadioButtonModel(propertyValueModel), this.resourceRepository());
    }

    private RadioButtonModelAdapter buildUseDescriptorTimeoutRadioButtonModel(PropertyValueModel propertyValueModel) {
        return new RadioButtonModelAdapter(propertyValueModel, MWAbstractReadQuery.QUERY_TIMEOUT_UNDEFINED);
    }

    private RadioButtonModelAdapter buildQueryTimeoutRadioButtonModel(PropertyValueModel propertyValueModel) {
        return new RadioButtonModelAdapter(propertyValueModel, Boolean.TRUE);
    }

    private RadioButtonModelAdapter buildNoQueryTimeoutRadioButtonModel(PropertyValueModel propertyValueModel) {
        return new RadioButtonModelAdapter(propertyValueModel, MWAbstractReadQuery.QUERY_TIMEOUT_NO_TIMEOUT);
    }

    protected JSpinner buildQueryTimeoutSpinner(PropertyValueModel propertyValueModel) {
        this.queryTimeoutSpinnerNumberModel = this.buildQueryTimeoutSpinnerModel(propertyValueModel);
        JSpinner jSpinner = new JSpinner();
        jSpinner.setPreferredSize(new Dimension(65, 23));
        jSpinner.setMinimumSize(new Dimension(65, 23));
        jSpinner.setMaximumSize(new Dimension(65, 23));
        jSpinner.setModel(this.queryTimeoutSpinnerNumberModel);
        this.queryTimeoutSpinnerNumberModel.setValue(this.query.getQueryTimeout());
        return jSpinner;
    }

    private SpinnerNumberModel buildQueryTimeoutSpinnerModel(PropertyValueModel propertyValueModel) {
        NumberSpinnerModelAdapter numberSpinnerModelAdapter = new NumberSpinnerModelAdapter(propertyValueModel);
        numberSpinnerModelAdapter.setMinimum(new Integer(1));
        numberSpinnerModelAdapter.setMaximum(new Integer(99999));
        return numberSpinnerModelAdapter;
    }

    protected PropertyValueModel buildQueryTimeoutBooleanHolder(PropertyValueModel propertyValueModel) {
        return new TransformationPropertyValueModel(propertyValueModel){

            protected Object transform(Object object) {
                if (object == null) {
                    return null;
                }
                return (Integer)object > 0;
            }

            protected Object reverseTransform(Object object) {
                if (Boolean.TRUE.equals(object)) {
                    return (Integer)this.valueHolder.getValue() > 0 ? this.valueHolder.getValue() : new Integer(1);
                }
                return MWAbstractReadQuery.QUERY_TIMEOUT_NO_TIMEOUT;
            }
        };
    }

    protected ComponentEnabler buildQueryTimeoutSpinnerEnabler(PropertyValueModel propertyValueModel, Component[] componentArray) {
        TransformationPropertyValueModel transformationPropertyValueModel = new TransformationPropertyValueModel(propertyValueModel){

            protected Object transform(Object object) {
                return (Integer)object > 0;
            }
        };
        return new ComponentEnabler((ValueModel)transformationPropertyValueModel, componentArray);
    }

    public Integer getQueryTimeout() {
        return (Integer)this.queryTimeoutSpinnerNumberModel.getValue();
    }

    protected JCheckBox buildMaximumRowsCheckBox() {
        this.maximumRowCheckBoxModel = new CheckBoxModelAdapter(new SimplePropertyValueModel());
        JCheckBox jCheckBox = SwingComponentFactory.buildCheckBox("NO_MAXIMUM_CHECK_BOX", this.maximumRowCheckBoxModel, this.resourceRepository());
        jCheckBox.setSelected(this.query.getMaximumRows() == 0);
        jCheckBox.addActionListener(this.buildMaximumRowsAction(jCheckBox));
        return jCheckBox;
    }

    private ActionListener buildMaximumRowsAction(final JCheckBox jCheckBox) {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                QueryAdvancedOptionsDialog.this.setMaximumRows(jCheckBox);
            }
        };
    }

    protected void setMaximumRows(JCheckBox jCheckBox) {
        if (jCheckBox.isSelected()) {
            this.maximumRowsSpinner.setEnabled(false);
            this.maximumRowsSpinnerNumberModel.setMinimum(new Integer(0));
            this.maximumRowsSpinnerNumberModel.setValue(new Integer(0));
        } else {
            this.maximumRowsSpinner.setEnabled(true);
            this.maximumRowsSpinnerNumberModel.setValue(this.getMaximumRows() == 0 ? new Integer(1) : this.maximumRowsSpinnerNumberModel.getValue());
            this.maximumRowsSpinnerNumberModel.setMinimum(new Integer(1));
        }
    }

    protected JSpinner buildMaximumRowsSpinner() {
        this.maximumRowsSpinnerNumberModel = this.buildMaximumRowsSpinnerModel();
        this.maximumRowsSpinner = new JSpinner();
        this.maximumRowsSpinner.setEnabled(this.query.getMaximumRows() != 0);
        this.maximumRowsSpinner.setPreferredSize(new Dimension(65, 23));
        this.maximumRowsSpinner.setMinimumSize(new Dimension(65, 23));
        this.maximumRowsSpinner.setMaximumSize(new Dimension(65, 23));
        this.maximumRowsSpinner.setModel(this.maximumRowsSpinnerNumberModel);
        this.maximumRowsSpinner.setValue(new Integer(this.query.getMaximumRows()));
        return this.maximumRowsSpinner;
    }

    private SpinnerNumberModel buildMaximumRowsSpinnerModel() {
        NumberSpinnerModelAdapter numberSpinnerModelAdapter = new NumberSpinnerModelAdapter(new SimplePropertyValueModel());
        numberSpinnerModelAdapter.setMinimum(new Integer(0));
        numberSpinnerModelAdapter.setMaximum(null);
        return numberSpinnerModelAdapter;
    }

    public int getMaximumRows() {
        return (Integer)this.maximumRowsSpinner.getValue();
    }

    protected JCheckBox buildFirstResultCheckBox() {
        this.firstResultCheckBoxModel = new CheckBoxModelAdapter(new SimplePropertyValueModel());
        JCheckBox jCheckBox = SwingComponentFactory.buildCheckBox("SET_FIRST_RESULT_CHECK_BOX", this.firstResultCheckBoxModel, this.resourceRepository());
        jCheckBox.setSelected(this.query.getFirstResult() != 0);
        jCheckBox.addActionListener(this.buildFirstResultAction(jCheckBox));
        return jCheckBox;
    }

    private ActionListener buildFirstResultAction(final JCheckBox jCheckBox) {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                QueryAdvancedOptionsDialog.this.setFirstResult(jCheckBox);
            }
        };
    }

    protected void setFirstResult(JCheckBox jCheckBox) {
        if (!jCheckBox.isSelected()) {
            this.firstResultSpinner.setEnabled(false);
            this.firstResultSpinnerNumberModel.setMinimum(new Integer(0));
            this.firstResultSpinnerNumberModel.setValue(new Integer(0));
        } else {
            this.firstResultSpinner.setEnabled(true);
            this.firstResultSpinnerNumberModel.setValue(this.getFirstResult() == 0 ? new Integer(1) : this.firstResultSpinnerNumberModel.getValue());
            this.firstResultSpinnerNumberModel.setMinimum(new Integer(1));
        }
    }

    protected JSpinner buildFirstResultSpinner() {
        this.firstResultSpinnerNumberModel = this.buildFirstResultSpinnerModel();
        this.firstResultSpinner = new JSpinner();
        this.firstResultSpinner.setEnabled(this.query.getFirstResult() != 0);
        this.firstResultSpinner.setPreferredSize(new Dimension(65, 23));
        this.firstResultSpinner.setMinimumSize(new Dimension(65, 23));
        this.firstResultSpinner.setMaximumSize(new Dimension(65, 23));
        this.firstResultSpinner.setModel(this.firstResultSpinnerNumberModel);
        this.firstResultSpinner.setValue(new Integer(this.query.getFirstResult()));
        return this.firstResultSpinner;
    }

    private SpinnerNumberModel buildFirstResultSpinnerModel() {
        NumberSpinnerModelAdapter numberSpinnerModelAdapter = new NumberSpinnerModelAdapter(new SimplePropertyValueModel());
        numberSpinnerModelAdapter.setMinimum(new Integer(0));
        numberSpinnerModelAdapter.setMaximum(null);
        return numberSpinnerModelAdapter;
    }

    public int getFirstResult() {
        return (Integer)this.firstResultSpinner.getValue();
    }

    protected JCheckBox buildPrepareCheckBox() {
        this.prepareCheckBoxModel = new CheckBoxModelAdapter(new SimplePropertyValueModel());
        JCheckBox jCheckBox = SwingComponentFactory.buildCheckBox("PREPARE_CHECK_BOX", this.prepareCheckBoxModel, this.resourceRepository());
        jCheckBox.setSelected(((MWRelationalQuery)this.query).isPrepare());
        this.helpManager().addTopicID(jCheckBox, this.helpTopicId() + ".prepare");
        return jCheckBox;
    }

    public boolean getPrepare() {
        return this.prepareCheckBoxModel.isSelected();
    }

    protected JCheckBox buildMaintainCacheCheckBox() {
        this.maintainCacheCheckBoxModel = new CheckBoxModelAdapter(new SimplePropertyValueModel());
        JCheckBox jCheckBox = SwingComponentFactory.buildCheckBox("MAINTAIN_CACHE_CHECK_BOX", this.maintainCacheCheckBoxModel, this.resourceRepository());
        jCheckBox.addActionListener(this.buildMaintainCacheAction());
        jCheckBox.setSelected(((MWReadQuery)this.query).isMaintainCache());
        this.helpManager().addTopicID(jCheckBox, this.helpTopicId() + ".maintainCache");
        return jCheckBox;
    }

    private ActionListener buildMaintainCacheAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                QueryAdvancedOptionsDialog.this.setMaintainCache();
            }
        };
    }

    private void setMaintainCache() {
        int n;
        if (!this.getMaintainCache() && (this.getRefreshIdentityMapResult() || this.getRefreshRemoteIdentityMapResult()) && (n = JOptionPane.showConfirmDialog(this.getWorkbenchContext().getCurrentWindow(), this.resourceRepository().getString("SET_FALSE_MAINTAIN_CACHE_DIALOG_MESSAGE"), this.resourceRepository().getString("SET_REFRESH_IDENTITY_MAP_RESULTS.title"), 0, 3)) == 0) {
            this.refreshRemoteIdentityMapCheckBoxModel.setSelected(false);
            this.refreshIdentityMapResult = false;
        }
    }

    public boolean getMaintainCache() {
        return this.maintainCacheCheckBoxModel.isSelected();
    }

    protected JCheckBox buildUseWrapperPolicyCheckBox() {
        this.useWrapperPolicyCheckBoxModel = new CheckBoxModelAdapter(new SimplePropertyValueModel());
        JCheckBox jCheckBox = SwingComponentFactory.buildCheckBox("USE_WRAPPER_POLICY_CHECK_BOX", this.useWrapperPolicyCheckBoxModel, this.resourceRepository());
        jCheckBox.setSelected(((MWReadQuery)this.query).isUseWrapperPolicy());
        this.helpManager().addTopicID(jCheckBox, this.helpTopicId() + ".useWrapper");
        return jCheckBox;
    }

    public boolean getUseWrapperPolicy() {
        return this.useWrapperPolicyCheckBoxModel.isSelected();
    }

    protected JCheckBox buildRefreshRemoteIdentityMapCheckBox() {
        this.refreshRemoteIdentityMapCheckBoxModel = new CheckBoxModelAdapter(new SimplePropertyValueModel());
        JCheckBox jCheckBox = SwingComponentFactory.buildCheckBox("REFRESH_REMOTE_IDENTITY_MAP_RESULTS_CHECK_BOX", this.refreshRemoteIdentityMapCheckBoxModel, this.resourceRepository());
        jCheckBox.setSelected(((MWReadQuery)this.query).isRefreshRemoteIdentityMapResult());
        this.refreshIdentityMapResult = ((MWReadQuery)this.query).isRefreshIdentityMapResult();
        this.helpManager().addTopicID(jCheckBox, this.helpTopicId() + ".refreshRemote");
        return jCheckBox;
    }

    public boolean getRefreshRemoteIdentityMapResult() {
        return this.refreshRemoteIdentityMapCheckBoxModel.isSelected();
    }

    public boolean getRefreshIdentityMapResult() {
        return this.refreshIdentityMapResult;
    }

    protected MWQuery getQuery() {
        return this.query;
    }
}

